/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.PDPConfig;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeFactoryProxy;
import com.sun.xacml.attr.AttributeProxy;
import com.sun.xacml.attr.BaseAttributeFactory;
import com.sun.xacml.attr.StandardAttributeFactory;
import com.sun.xacml.combine.BaseCombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgFactoryProxy;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.combine.StandardCombiningAlgFactory;
import com.sun.xacml.cond.BaseFunctionFactory;
import com.sun.xacml.cond.BasicFunctionFactoryProxy;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionFactoryProxy;
import com.sun.xacml.cond.FunctionProxy;
import com.sun.xacml.cond.StandardFunctionFactory;
import com.sun.xacml.cond.cluster.FunctionCluster;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.ResourceFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationStore {
    public static final String PDP_CONFIG_PROPERTY = "com.sun.xacml.PDPConfigFile";
    private PDPConfig defaultPDPConfig;
    private HashMap pdpConfigMap;
    private AttributeFactory defaultAttributeFactory;
    private HashMap attributeMap;
    private CombiningAlgFactory defaultCombiningFactory;
    private HashMap combiningMap;
    private FunctionFactoryProxy defaultFunctionFactoryProxy;
    private HashMap functionMap;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$ConfigurationStore == null ? (class$com$sun$xacml$ConfigurationStore = ConfigurationStore.class$("com.sun.xacml.ConfigurationStore")) : class$com$sun$xacml$ConfigurationStore).getName());
    static /* synthetic */ Class class$com$sun$xacml$ConfigurationStore;

    public ConfigurationStore() throws ParsingException {
        String configFile = System.getProperty(PDP_CONFIG_PROPERTY);
        if (configFile == null) {
            logger.severe("A property defining a config file was expected, but none was provided");
            throw new ParsingException("Config property com.sun.xacml.PDPConfigFile needs to be set");
        }
        try {
            this.setupConfig(new File(configFile));
        }
        catch (ParsingException pe) {
            logger.log(Level.SEVERE, "Runtime config file couldn't be loaded so no configurations will be available", pe);
            throw pe;
        }
    }

    public ConfigurationStore(File configFile) throws ParsingException {
        try {
            this.setupConfig(configFile);
        }
        catch (ParsingException pe) {
            logger.log(Level.SEVERE, "Runtime config file couldn't be loaded so no configurations will be available", pe);
            throw pe;
        }
    }

    private void setupConfig(File configFile) throws ParsingException {
        logger.config("Loading runtime configuration");
        Node root = this.getRootNode(configFile);
        this.pdpConfigMap = new HashMap();
        this.attributeMap = new HashMap();
        this.combiningMap = new HashMap();
        this.functionMap = new HashMap();
        NamedNodeMap attrs = root.getAttributes();
        String defaultPDP = attrs.getNamedItem("defaultPDP").getNodeValue();
        String defaultAF = attrs.getNamedItem("defaultAttributeFactory").getNodeValue();
        String defaultCAF = attrs.getNamedItem("defaultCombiningAlgFactory").getNodeValue();
        String defaultFF = attrs.getNamedItem("defaultFunctionFactory").getNodeValue();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            String elementName = null;
            if (child.getNodeType() == 1) {
                elementName = child.getAttributes().getNamedItem("name").getNodeValue();
            }
            if (childName.equals("pdp")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading PDP: " + elementName);
                }
                if (this.pdpConfigMap.containsKey(elementName)) {
                    throw new ParsingException("more that one pdp with name \"" + elementName + "\"");
                }
                this.pdpConfigMap.put(elementName, this.parsePDPConfig(child));
                continue;
            }
            if (childName.equals("attributeFactory")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading AttributeFactory: " + elementName);
                }
                if (this.attributeMap.containsKey(elementName)) {
                    throw new ParsingException("more that one attributeFactory with name " + elementName + "\"");
                }
                this.attributeMap.put(elementName, this.parseAttributeFactory(child));
                continue;
            }
            if (childName.equals("combiningAlgFactory")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading CombiningAlgFactory: " + elementName);
                }
                if (this.combiningMap.containsKey(elementName)) {
                    throw new ParsingException("more that one combiningAlgFactory with name \"" + elementName + "\"");
                }
                this.combiningMap.put(elementName, this.parseCombiningAlgFactory(child));
                continue;
            }
            if (!childName.equals("functionFactory")) continue;
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Loading FunctionFactory: " + elementName);
            }
            if (this.functionMap.containsKey(elementName)) {
                throw new ParsingException("more that one functionFactory with name \"" + elementName + "\"");
            }
            this.functionMap.put(elementName, this.parseFunctionFactory(child));
        }
        this.defaultPDPConfig = (PDPConfig)this.pdpConfigMap.get(defaultPDP);
        this.defaultAttributeFactory = (AttributeFactory)this.attributeMap.get(defaultAF);
        this.defaultCombiningFactory = (CombiningAlgFactory)this.combiningMap.get(defaultCAF);
        this.defaultFunctionFactoryProxy = (FunctionFactoryProxy)this.functionMap.get(defaultFF);
    }

    private Node getRootNode(File configFile) throws ParsingException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringComments(true);
        dbFactory.setNamespaceAware(false);
        dbFactory.setValidating(false);
        DocumentBuilder db = null;
        try {
            db = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new ParsingException("couldn't get a document builder", pce);
        }
        Document doc = null;
        try {
            doc = db.parse(new FileInputStream(configFile));
        }
        catch (IOException ioe) {
            throw new ParsingException("failed to load the file ", ioe);
        }
        catch (SAXException saxe) {
            throw new ParsingException("error parsing the XML tree", saxe);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException("no data to parse", iae);
        }
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("config")) {
            throw new ParsingException("unknown document type: " + root.getTagName());
        }
        return root;
    }

    private PDPConfig parsePDPConfig(Node root) throws ParsingException {
        ArrayList<Object> attrModules = new ArrayList<Object>();
        HashSet<Object> policyModules = new HashSet<Object>();
        ArrayList<Object> rsrcModules = new ArrayList<Object>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("policyFinderModule")) {
                policyModules.add(this.loadClass("module", child));
                continue;
            }
            if (name.equals("attributeFinderModule")) {
                attrModules.add(this.loadClass("module", child));
                continue;
            }
            if (!name.equals("resourceFinderModule")) continue;
            rsrcModules.add(this.loadClass("module", child));
        }
        AttributeFinder attrFinder = new AttributeFinder();
        attrFinder.setModules(attrModules);
        PolicyFinder policyFinder = new PolicyFinder();
        policyFinder.setModules(policyModules);
        ResourceFinder rsrcFinder = new ResourceFinder();
        rsrcFinder.setModules(rsrcModules);
        return new PDPConfig(attrFinder, policyFinder, rsrcFinder);
    }

    private AttributeFactory parseAttributeFactory(Node root) throws ParsingException {
        BaseAttributeFactory factory = null;
        if (this.useStandard(root, "useStandardDatatypes")) {
            logger.config("Starting with standard Datatypes");
            StandardAttributeFactory sf = StandardAttributeFactory.getFactory();
            factory = new BaseAttributeFactory(sf.getStandardDatatypes());
        } else {
            factory = new BaseAttributeFactory();
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("datatype")) continue;
            String identifier = child.getAttributes().getNamedItem("identifier").getNodeValue();
            AttributeProxy proxy = (AttributeProxy)this.loadClass("datatype", child);
            try {
                ((AttributeFactory)factory).addDatatype(identifier, proxy);
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw new ParsingException("duplicate datatype: " + identifier, iae);
            }
        }
        return factory;
    }

    private CombiningAlgFactory parseCombiningAlgFactory(Node root) throws ParsingException {
        BaseCombiningAlgFactory factory = null;
        if (this.useStandard(root, "useStandardAlgorithms")) {
            logger.config("Starting with standard Combining Algorithms");
            StandardCombiningAlgFactory sf = StandardCombiningAlgFactory.getFactory();
            factory = new BaseCombiningAlgFactory(sf.getStandardAlgorithms());
        } else {
            factory = new BaseCombiningAlgFactory();
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("algorithm")) continue;
            CombiningAlgorithm alg = (CombiningAlgorithm)this.loadClass("algorithm", child);
            try {
                ((CombiningAlgFactory)factory).addAlgorithm(alg);
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw new ParsingException("duplicate combining algorithm: " + alg.getIdentifier().toString(), iae);
            }
        }
        return factory;
    }

    private FunctionFactoryProxy parseFunctionFactory(Node root) throws ParsingException {
        FunctionFactoryProxy proxy = null;
        FunctionFactory generalFactory = null;
        FunctionFactory conditionFactory = null;
        FunctionFactory targetFactory = null;
        if (this.useStandard(root, "useStandardFunctions")) {
            logger.config("Starting with standard Functions");
            proxy = StandardFunctionFactory.getNewFactoryProxy();
            targetFactory = proxy.getTargetFactory();
            conditionFactory = proxy.getConditionFactory();
            generalFactory = proxy.getGeneralFactory();
        } else {
            generalFactory = new BaseFunctionFactory();
            conditionFactory = new BaseFunctionFactory(generalFactory);
            targetFactory = new BaseFunctionFactory(conditionFactory);
            proxy = new BasicFunctionFactoryProxy(targetFactory, conditionFactory, generalFactory);
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("target")) {
                logger.config("Loading [TARGET] functions");
                this.functionParserHelper(child, targetFactory);
                continue;
            }
            if (name.equals("condition")) {
                logger.config("Loading [CONDITION] functions");
                this.functionParserHelper(child, conditionFactory);
                continue;
            }
            if (!name.equals("general")) continue;
            logger.config("Loading [GENERAL] functions");
            this.functionParserHelper(child, generalFactory);
        }
        return proxy;
    }

    private void functionParserHelper(Node root, FunctionFactory factory) throws ParsingException {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("function")) {
                Function function = (Function)this.loadClass("function", child);
                try {
                    factory.addFunction(function);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new ParsingException("duplicate function", iae);
                }
            }
            if (name.equals("abstractFunction")) {
                URI identifier = null;
                try {
                    identifier = new URI(child.getAttributes().getNamedItem("identifier").getNodeValue());
                }
                catch (URISyntaxException urise) {
                    throw new ParsingException("invalid function identifier", urise);
                }
                FunctionProxy proxy = (FunctionProxy)this.loadClass("abstract function", child);
                try {
                    factory.addAbstractFunction(proxy, identifier);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw new ParsingException("duplicate abstract function", iae);
                }
            }
            if (!name.equals("functionCluster")) continue;
            FunctionCluster cluster = (FunctionCluster)this.loadClass("function cluster", child);
            Iterator it = cluster.getSupportedFunctions().iterator();
            while (it.hasNext()) {
                try {
                    factory.addFunction((Function)it.next());
                }
                catch (IllegalArgumentException iae) {
                    throw new ParsingException("duplicate function", iae);
                }
            }
        }
    }

    private Object loadClass(String prefix, Node root) throws ParsingException {
        String className = root.getAttributes().getNamedItem("class").getNodeValue();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Loading [ " + prefix + ": " + className + " ]");
        }
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        Class<?> c = null;
        try {
            c = cl.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParsingException("couldn't load class " + className, cnfe);
        }
        Object instance = null;
        if (!root.hasChildNodes()) {
            try {
                instance = c.newInstance();
            }
            catch (InstantiationException ie) {
                throw new ParsingException("couldn't instantiate " + className + " with empty constructor", ie);
            }
            catch (IllegalAccessException iae) {
                throw new ParsingException("couldn't get access to instance of " + className, iae);
            }
        }
        List args = null;
        try {
            args = this.getArgs(root);
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException("illegal class arguments", iae);
        }
        int argLength = args.size();
        Constructor<?>[] cons = c.getConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < cons.length; ++i) {
            Class<?>[] params = cons[i].getParameterTypes();
            if (params.length == argLength) {
                Iterator it = args.iterator();
                int j = 0;
                while (it.hasNext() && params[j].isAssignableFrom(it.next().getClass())) {
                    ++j;
                }
                if (j == argLength) {
                    constructor = cons[i];
                }
            }
            if (constructor != null) break;
        }
        if (constructor == null) {
            throw new ParsingException("couldn't find a matching constructor");
        }
        try {
            instance = constructor.newInstance(args.toArray());
        }
        catch (InstantiationException ie) {
            throw new ParsingException("couldn't instantiate " + className, ie);
        }
        catch (IllegalAccessException iae) {
            throw new ParsingException("couldn't get access to instance of " + className, iae);
        }
        catch (InvocationTargetException ite) {
            throw new ParsingException("couldn't create " + className, ite);
        }
        return instance;
    }

    private List getArgs(Node root) {
        ArrayList<Object> args = new ArrayList<Object>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (child.getNodeType() != 1) continue;
            if (name.equals("string")) {
                args.add(child.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equals("list")) {
                args.add(this.getArgs(child));
                continue;
            }
            throw new IllegalArgumentException("unkown arg type: " + name);
        }
        return args;
    }

    private boolean useStandard(Node node, String attributeName) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return true;
        }
        Node attrNode = map.getNamedItem(attributeName);
        if (attrNode == null) {
            return true;
        }
        return attrNode.getNodeValue().equals("true");
    }

    public PDPConfig getDefaultPDPConfig() throws UnknownIdentifierException {
        if (this.defaultPDPConfig == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultPDPConfig;
    }

    public PDPConfig getPDPConfig(String name) throws UnknownIdentifierException {
        Object object = this.pdpConfigMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown pdp: " + name);
        }
        return (PDPConfig)object;
    }

    public Set getSupportedPDPConfigurations() {
        return Collections.unmodifiableSet(this.pdpConfigMap.keySet());
    }

    public AttributeFactory getDefaultAttributeFactory() throws UnknownIdentifierException {
        if (this.defaultAttributeFactory == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultAttributeFactory;
    }

    public AttributeFactory getAttributeFactory(String name) throws UnknownIdentifierException {
        Object object = this.attributeMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown factory: " + name);
        }
        return (AttributeFactory)object;
    }

    public Set getSupportedAttributeFactories() {
        return Collections.unmodifiableSet(this.attributeMap.keySet());
    }

    public CombiningAlgFactory getDefaultCombiningAlgFactory() throws UnknownIdentifierException {
        if (this.defaultCombiningFactory == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultCombiningFactory;
    }

    public CombiningAlgFactory getCombiningAlgFactory(String name) throws UnknownIdentifierException {
        Object object = this.combiningMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown factory: " + name);
        }
        return (CombiningAlgFactory)object;
    }

    public Set getSupportedCombiningAlgFactories() {
        return Collections.unmodifiableSet(this.combiningMap.keySet());
    }

    public FunctionFactoryProxy getDefaultFunctionFactoryProxy() throws UnknownIdentifierException {
        if (this.defaultFunctionFactoryProxy == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultFunctionFactoryProxy;
    }

    public FunctionFactoryProxy getFunctionFactoryProxy(String name) throws UnknownIdentifierException {
        Object object = this.functionMap.get(name);
        if (object == null) {
            throw new UnknownIdentifierException("unknown factory: " + name);
        }
        return (FunctionFactoryProxy)object;
    }

    public Set getSupportedFunctionFactories() {
        return Collections.unmodifiableSet(this.functionMap.keySet());
    }

    public void useDefaultFactories() {
        logger.fine("Switching to default factories from configuration");
        if (this.defaultAttributeFactory != null) {
            AttributeFactory.setDefaultFactory(new AttributeFactoryProxy(){

                public AttributeFactory getFactory() {
                    return ConfigurationStore.this.defaultAttributeFactory;
                }
            });
        }
        if (this.defaultCombiningFactory != null) {
            CombiningAlgFactory.setDefaultFactory(new CombiningAlgFactoryProxy(){

                public CombiningAlgFactory getFactory() {
                    return ConfigurationStore.this.defaultCombiningFactory;
                }
            });
        }
        if (this.defaultFunctionFactoryProxy != null) {
            FunctionFactory.setDefaultFactory(this.defaultFunctionFactoryProxy);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

