/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.Rule;
import com.sun.xacml.Target;
import com.sun.xacml.combine.RuleCombiningAlgorithm;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Policy
extends AbstractPolicy {
    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, Target target) {
        this(id, combiningAlg, null, target, null, null, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, Target target, List rules) {
        this(id, combiningAlg, null, target, null, rules, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, Target target, String defaultVersion, List rules) {
        this(id, combiningAlg, null, target, defaultVersion, rules, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, String description, Target target, List rules) {
        this(id, combiningAlg, description, target, null, rules, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules) {
        this(id, combiningAlg, description, target, defaultVersion, rules, null);
    }

    public Policy(URI id, RuleCombiningAlgorithm combiningAlg, String description, Target target, String defaultVersion, List rules, Set obligations) {
        super(id, combiningAlg, description, target, defaultVersion, obligations);
        if (rules != null) {
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof Rule) continue;
                throw new IllegalArgumentException("non-Rule in rules");
            }
        }
        this.setChildren(rules);
    }

    private Policy(Node root) throws ParsingException {
        super(root, "Policy", "RuleCombiningAlgId");
        ArrayList<Rule> rules = new ArrayList<Rule>();
        String xpathVersion = this.getDefaultVersion();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals("Rule")) continue;
            rules.add(Rule.getInstance(child, xpathVersion));
        }
        this.setChildren(rules);
    }

    public static Policy getInstance(Node root) throws ParsingException {
        if (!root.getNodeName().equals("Policy")) {
            throw new ParsingException("Cannot create Policy from root of type " + root.getNodeName());
        }
        return new Policy(root);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String version;
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<Policy PolicyId=\"" + this.getId().toString() + "\" RuleCombiningAlgId=\"" + this.getCombiningAlg().getIdentifier().toString() + "\">");
        indenter.in();
        String nextIndent = indenter.makeString();
        String description = this.getDescription();
        if (description != null) {
            out.println(nextIndent + "<Description>" + description + "</Description>");
        }
        if ((version = this.getDefaultVersion()) != null) {
            out.println("<PolicyDefaults><XPathVersion>" + version + "</XPathVersion></PolicyDefaults>");
        }
        this.encodeCommonElements(output, indenter);
        indenter.out();
        out.println(indent + "</Policy>");
    }
}

