/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgorithm;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class BaseCombiningAlgFactory
extends CombiningAlgFactory {
    private HashMap algMap = new HashMap();

    public BaseCombiningAlgFactory() {
    }

    public BaseCombiningAlgFactory(Set algorithms) {
        Iterator it = algorithms.iterator();
        while (it.hasNext()) {
            try {
                CombiningAlgorithm alg = (CombiningAlgorithm)it.next();
                this.algMap.put(alg.getIdentifier().toString(), alg);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("an element of the set was not an instance of CombiningAlgorithm");
            }
        }
    }

    public void addAlgorithm(CombiningAlgorithm alg) {
        String algId = alg.getIdentifier().toString();
        if (this.algMap.containsKey(algId)) {
            throw new IllegalArgumentException("algorithm already registered: " + algId);
        }
        this.algMap.put(algId, alg);
    }

    public Set getSupportedAlgorithms() {
        return Collections.unmodifiableSet(this.algMap.keySet());
    }

    public CombiningAlgorithm createAlgorithm(URI algId) throws UnknownIdentifierException {
        String id = algId.toString();
        if (this.algMap.containsKey(id)) {
            return (CombiningAlgorithm)this.algMap.get(algId.toString());
        }
        throw new UnknownIdentifierException("unknown combining algId: " + id);
    }
}

