/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DoubleAttribute;
import com.sun.xacml.attr.IntegerAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NumericConvertFunction
extends FunctionBase {
    public static final String NAME_DOUBLE_TO_INTEGER = "urn:oasis:names:tc:xacml:1.0:function:double-to-integer";
    public static final String NAME_INTEGER_TO_DOUBLE = "urn:oasis:names:tc:xacml:1.0:function:integer-to-double";
    private static final int ID_DOUBLE_TO_INTEGER = 0;
    private static final int ID_INTEGER_TO_DOUBLE = 1;

    public NumericConvertFunction(String functionName) {
        super(functionName, NumericConvertFunction.getId(functionName), NumericConvertFunction.getArgumentType(functionName), false, 1, NumericConvertFunction.getReturnType(functionName), false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_DOUBLE_TO_INTEGER)) {
            return 0;
        }
        if (functionName.equals(NAME_INTEGER_TO_DOUBLE)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown convert function " + functionName);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_DOUBLE_TO_INTEGER);
        set.add(NAME_INTEGER_TO_DOUBLE);
        return set;
    }

    private static String getArgumentType(String functionName) {
        if (functionName.equals(NAME_DOUBLE_TO_INTEGER)) {
            return "http://www.w3.org/2001/XMLSchema#double";
        }
        return "http://www.w3.org/2001/XMLSchema#integer";
    }

    private static String getReturnType(String functionName) {
        if (functionName.equals(NAME_DOUBLE_TO_INTEGER)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        return "http://www.w3.org/2001/XMLSchema#double";
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        AttributeValue[] argValues = new AttributeValue[inputs.size()];
        EvaluationResult result = this.evalArgs(inputs, context, argValues);
        if (result != null) {
            return result;
        }
        switch (this.getFunctionId()) {
            case 0: {
                double arg0 = ((DoubleAttribute)argValues[0]).getValue();
                long longValue = (long)arg0;
                result = new EvaluationResult(new IntegerAttribute(longValue));
                break;
            }
            case 1: {
                long arg0 = ((IntegerAttribute)argValues[0]).getValue();
                double doubleValue = arg0;
                result = new EvaluationResult(new DoubleAttribute(doubleValue));
                break;
            }
        }
        return result;
    }
}

