/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.Utf8NumericParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.sym.BytesToNameCanonicalizer;
import org.codehaus.jackson.sym.Name;
import org.codehaus.jackson.type.TypeReference;
import org.codehaus.jackson.util.ByteArrayBuilder;
import org.codehaus.jackson.util.CharTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utf8StreamParser
extends Utf8NumericParser {
    static final byte BYTE_LF = 10;
    final ObjectCodec _objectCodec;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[32];

    public Utf8StreamParser(IOContext ctxt, int features, InputStream in, ObjectCodec codec, BytesToNameCanonicalizer sym, byte[] inputBuffer, int start, int end, boolean bufferRecyclable) {
        super(ctxt, features, in, inputBuffer, start, end, bufferRecyclable);
        this._objectCodec = codec;
        this._symbols = sym;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        JsonToken t;
        boolean inObject;
        int i;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((i = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (i == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(i, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (i == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(i, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (i != 44) {
                this._reportUnexpectedChar(i, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            i = this._skipWS();
        }
        if (inObject = this._parsingContext.inObject()) {
            Name n = this._parseFieldName(i);
            this._parsingContext.setCurrentName(n.getName());
            i = this._skipWS();
            if (i != 58) {
                this._reportUnexpectedChar(i, "was expecting a colon to separate field name and value");
            }
            this._currToken = JsonToken.FIELD_NAME;
            i = this._skipWS();
        }
        switch (i) {
            case 34: {
                this._tokenIncomplete = true;
                t = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!inObject) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                t = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!inObject) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                t = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(i, "expected a value");
            }
            case 116: {
                this._matchToken(JsonToken.VALUE_TRUE);
                t = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken(JsonToken.VALUE_FALSE);
                t = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken(JsonToken.VALUE_NULL);
                t = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                t = this.parseNumberText(i);
                break;
            }
            default: {
                this._reportUnexpectedChar(i, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
                t = null;
            }
        }
        if (inObject) {
            this._nextToken = t;
            return this._currToken;
        }
        this._currToken = t;
        return t;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken t = this._nextToken;
        this._nextToken = null;
        if (t == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (t == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = t;
        return this._currToken;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._symbols.release();
    }

    @Override
    public final <T> T readValueAs(Class<T> valueType) throws IOException, JsonProcessingException {
        if (this._objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize Json into regular Java objects");
        }
        return this._objectCodec.readValue((JsonParser)this, valueType);
    }

    @Override
    public final <T> T readValueAs(TypeReference<?> valueTypeRef) throws IOException, JsonProcessingException {
        if (this._objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize Json into regular Java objects");
        }
        return this._objectCodec.readValue((JsonParser)this, valueTypeRef);
    }

    @Override
    public final JsonNode readValueAsTree() throws IOException, JsonProcessingException {
        if (this._objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize Json into JsonNode tree");
        }
        return this._objectCodec.readTree(this);
    }

    protected final Name _parseFieldName(int i) throws IOException, JsonParseException {
        int q;
        if (i != 34) {
            this._reportUnexpectedChar(i, "was expecting double-quote to start field name");
        }
        if (this._inputEnd - this._inputPtr < 9) {
            return this.slowParseFieldName();
        }
        int[] codes = CharTypes.getInputCodeLatin1();
        if (codes[q = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (q == 34) {
                return BytesToNameCanonicalizer.getEmptyName();
            }
            return this.parseFieldName(0, q, 0);
        }
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 1);
            }
            return this.parseFieldName(q, i, 1);
        }
        q = q << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 2);
            }
            return this.parseFieldName(q, i, 2);
        }
        q = q << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 3);
            }
            return this.parseFieldName(q, i, 3);
        }
        q = q << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q, 4);
            }
            return this.parseFieldName(q, i, 4);
        }
        return this.parseMediumFieldName(q, i);
    }

    protected Name parseMediumFieldName(int q1, int q2) throws IOException, JsonParseException {
        int i;
        int[] codes = CharTypes.getInputCodeLatin1();
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 1);
            }
            return this.parseFieldName(q1, q2, i, 1);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 2);
            }
            return this.parseFieldName(q1, q2, i, 2);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 3);
            }
            return this.parseFieldName(q1, q2, i, 3);
        }
        q2 = q2 << 8 | i;
        if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (i == 34) {
                return this.findName(q1, q2, 4);
            }
            return this.parseFieldName(q1, q2, i, 4);
        }
        this._quadBuffer[0] = q1;
        this._quadBuffer[1] = q2;
        return this.parseLongFieldName(i);
    }

    protected Name parseLongFieldName(int q) throws IOException, JsonParseException {
        int[] codes = CharTypes.getInputCodeLatin1();
        int qlen = 2;
        while (this._inputEnd - this._inputPtr >= 4) {
            int i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 1);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 1);
            }
            q = q << 8 | i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 2);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 2);
            }
            q = q << 8 | i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 3);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 3);
            }
            q = q << 8 | i;
            if (codes[i = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (i == 34) {
                    return this.findName(this._quadBuffer, qlen, q, 4);
                }
                return this.parseEscapedFieldName(this._quadBuffer, qlen, q, i, 4);
            }
            if (qlen >= this._quadBuffer.length) {
                this._quadBuffer = Utf8StreamParser.growArrayBy(this._quadBuffer, qlen);
            }
            this._quadBuffer[qlen++] = q;
            q = i;
        }
        return this.parseEscapedFieldName(this._quadBuffer, qlen, 0, q, 0);
    }

    protected Name slowParseFieldName() throws IOException, JsonParseException {
        int i;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing quote for name");
        }
        if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseEscapedFieldName(this._quadBuffer, 0, 0, i, 0);
    }

    private final Name parseFieldName(int q1, int ch, int lastQuadBytes) throws IOException, JsonParseException {
        return this.parseEscapedFieldName(this._quadBuffer, 0, q1, ch, lastQuadBytes);
    }

    private final Name parseFieldName(int q1, int q2, int ch, int lastQuadBytes) throws IOException, JsonParseException {
        this._quadBuffer[0] = q1;
        return this.parseEscapedFieldName(this._quadBuffer, 1, q2, ch, lastQuadBytes);
    }

    protected Name parseEscapedFieldName(int[] quads, int qlen, int currQuad, int ch, int currQuadBytes) throws IOException, JsonParseException {
        Name name;
        int[] codes = CharTypes.getInputCodeLatin1();
        while (true) {
            if (codes[ch] != 0) {
                if (ch == 34) break;
                if (ch != 92) {
                    this._throwUnquotedSpace(ch, "name");
                }
                if ((ch = (int)this._decodeEscaped()) > 127) {
                    if (currQuadBytes >= 4) {
                        if (qlen >= quads.length) {
                            quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                            this._quadBuffer = quads;
                        }
                        quads[qlen++] = currQuad;
                        currQuad = 0;
                        currQuadBytes = 0;
                    }
                    if (ch < 2048) {
                        currQuad = currQuad << 8 | (0xC0 | ch >> 6);
                        ++currQuadBytes;
                    } else {
                        currQuad = currQuad << 8 | (0xE0 | ch >> 12);
                        if (++currQuadBytes >= 4) {
                            if (qlen >= quads.length) {
                                quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                                this._quadBuffer = quads;
                            }
                            quads[qlen++] = currQuad;
                            currQuad = 0;
                            currQuadBytes = 0;
                        }
                        currQuad = currQuad << 8 | (0x80 | ch >> 6 & 0x3F);
                        ++currQuadBytes;
                    }
                    ch = 0x80 | ch & 0x3F;
                }
            }
            if (currQuadBytes < 4) {
                ++currQuadBytes;
                currQuad = currQuad << 8 | ch;
            } else {
                if (qlen >= quads.length) {
                    quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                    this._quadBuffer = quads;
                }
                quads[qlen++] = currQuad;
                currQuad = ch;
                currQuadBytes = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            ch = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (currQuadBytes > 0) {
            if (qlen >= quads.length) {
                quads = Utf8StreamParser.growArrayBy(quads, quads.length);
                this._quadBuffer = quads;
            }
            quads[qlen++] = currQuad;
        }
        if ((name = this._symbols.findName(quads, qlen)) == null) {
            name = this.addName(quads, qlen, currQuadBytes);
        }
        return name;
    }

    private final Name findName(int q1, int lastQuadBytes) throws JsonParseException {
        Name name = this._symbols.findName(q1);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = q1;
        return this.addName(this._quadBuffer, 1, lastQuadBytes);
    }

    private final Name findName(int q1, int q2, int lastQuadBytes) throws JsonParseException {
        Name name = this._symbols.findName(q1, q2);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = q1;
        this._quadBuffer[1] = q2;
        return this.addName(this._quadBuffer, 2, lastQuadBytes);
    }

    private final Name findName(int[] quads, int qlen, int lastQuad, int lastQuadBytes) throws JsonParseException {
        if (qlen >= quads.length) {
            quads = Utf8StreamParser.growArrayBy(quads, quads.length);
            this._quadBuffer = quads;
        }
        quads[qlen++] = lastQuad;
        Name name = this._symbols.findName(quads, qlen);
        if (name == null) {
            return this.addName(quads, qlen, lastQuadBytes);
        }
        return name;
    }

    private final Name addName(int[] quads, int qlen, int lastQuadBytes) throws JsonParseException {
        int lastQuad;
        int byteLen = (qlen << 2) - 4 + lastQuadBytes;
        if (lastQuadBytes < 4) {
            lastQuad = quads[qlen - 1];
            quads[qlen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        char[] cbuf = this._textBuffer.emptyAndGetCurrentSegment();
        int cix = 0;
        int ix = 0;
        while (ix < byteLen) {
            int ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            if (ch > 127) {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this._reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this._reportInvalidEOF(" in field name");
                }
                int ch2 = quads[ix >> 2];
                byteIx = ix & 3;
                ++ix;
                if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                if (needed > 2) {
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        cbuf = this._textBuffer.expandCurrentSegment();
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (cix >= cbuf.length) {
                cbuf = this._textBuffer.expandCurrentSegment();
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes < 4) {
            quads[qlen - 1] = lastQuad;
        }
        return this._symbols.addName(baseName, quads, qlen);
    }

    @Override
    protected void _finishString() throws IOException, JsonParseException {
        int outPtr = 0;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int[] codes = CharTypes.getInputCodeUtf8();
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block16: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outBuf.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) {
                        outBuf[outPtr++] = (char)c;
                        continue;
                    }
                    break block16;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            if (c == 34) break;
            switch (codes[c]) {
                case 1: {
                    c = this._decodeEscaped();
                    break;
                }
                case 2: {
                    c = this._decodeUtf8_2(c);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        c = this._decodeUtf8_3fast(c);
                        break;
                    }
                    c = this._decodeUtf8_3(c);
                    break;
                }
                case 4: {
                    c = this._decodeUtf8_4(c);
                    outBuf[outPtr++] = (char)(0xD800 | c >> 10);
                    if (outPtr >= outBuf.length) {
                        outBuf = this._textBuffer.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    if (c < 32) {
                        this._throwUnquotedSpace(c, "string value");
                    }
                    this._reportInvalidChar(c);
                }
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            outBuf[outPtr++] = (char)c;
        }
        this._textBuffer.setCurrentLength(outPtr);
    }

    protected void _skipString() throws IOException, JsonParseException {
        this._tokenIncomplete = false;
        int[] codes = CharTypes.getInputCodeUtf8();
        byte[] inputBuffer = this._inputBuffer;
        block6: while (true) {
            int c;
            int ptr;
            block10: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (codes[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            if (c == 34) break;
            switch (codes[c]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2(c);
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3(c);
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4(c);
                    continue block6;
                }
            }
            if (c < 32) {
                this._throwUnquotedSpace(c, "string value");
            }
            this._reportInvalidChar(c);
        }
    }

    protected void _matchToken(JsonToken token) throws IOException, JsonParseException {
        byte[] matchBytes = token.asByteArray();
        int len = matchBytes.length;
        for (int i = 1; i < len; ++i) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (matchBytes[i] != this._inputBuffer[this._inputPtr]) {
                this._reportInvalidToken(token.asString().substring(0, i));
            }
            ++this._inputPtr;
        }
    }

    private void _reportInvalidToken(String matchedPart) throws IOException, JsonParseException {
        byte i;
        char c;
        StringBuilder sb = new StringBuilder(matchedPart);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c = (char)this._decodeCharForError(i = this._inputBuffer[this._inputPtr++]))) {
            ++this._inputPtr;
            sb.append(c);
        }
        this._reportError("Unrecognized token '" + sb.toString() + "': was expecting 'null', 'true' or 'false'");
    }

    private final int _skipWS() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int i;
            if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (i != 47) {
                    return i;
                }
                this._skipComment();
                continue;
            }
            if (i == 32) continue;
            if (i == 10) {
                this._skipLF();
                continue;
            }
            if (i == 13) {
                this._skipCR();
                continue;
            }
            if (i == 9) continue;
            this._throwInvalidSpace(i);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final int _skipWSOrEnd() throws IOException, JsonParseException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int i;
            if ((i = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (i != 47) {
                    return i;
                }
                this._skipComment();
                continue;
            }
            if (i == 32) continue;
            if (i == 10) {
                this._skipLF();
                continue;
            }
            if (i == 13) {
                this._skipCR();
                continue;
            }
            if (i == 9) continue;
            this._throwInvalidSpace(i);
        }
        this._handleEOF();
        return -1;
    }

    private final void _skipComment() throws IOException, JsonParseException {
        int c;
        if (!this.isFeatureEnabled(JsonParser.Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this._skipCppComment();
        } else if (c == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(c, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() throws IOException, JsonParseException {
        int[] codes = CharTypes.getInputCodeComment();
        block5: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int i;
            int code;
            if ((code = codes[i = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (code) {
                case 42: {
                    if (this._inputBuffer[this._inputPtr] != 47) continue block5;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    this._skipLF();
                    continue block5;
                }
                case 13: {
                    this._skipCR();
                    continue block5;
                }
            }
            this._reportInvalidChar(i);
        }
        this._reportInvalidEOF(" in a comment");
    }

    private final void _skipCppComment() throws IOException, JsonParseException {
        int[] codes = CharTypes.getInputCodeComment();
        block5: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int i;
            int code;
            if ((code = codes[i = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (code) {
                case 10: {
                    this._skipLF();
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block5;
                }
            }
            this._reportInvalidChar(i);
        }
    }

    protected final char _decodeEscaped() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        byte c = this._inputBuffer[this._inputPtr++];
        switch (c) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)c;
            }
            case 117: {
                break;
            }
            default: {
                this._reportError("Unrecognized character escape \\ followed by " + Utf8StreamParser._getCharDesc(this._decodeCharForError(c)));
            }
        }
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            byte ch;
            int digit;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((digit = CharTypes.charToHex(ch = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(ch, "expected a hex-digit for character escape sequence");
            }
            value = value << 4 | digit;
        }
        return (char)value;
    }

    protected int _decodeCharForError(int firstByte) throws IOException, JsonParseException {
        int c = firstByte;
        if (c < 0) {
            int needed;
            if ((c & 0xE0) == 192) {
                c &= 0x1F;
                needed = 1;
            } else if ((c & 0xF0) == 224) {
                c &= 0xF;
                needed = 2;
            } else if ((c & 0xF8) == 240) {
                c &= 7;
                needed = 3;
            } else {
                this._reportInvalidInitial(c & 0xFF);
                needed = 1;
            }
            int d = this.nextByte();
            if ((d & 0xC0) != 128) {
                this._reportInvalidOther(d & 0xFF);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 1) {
                d = this.nextByte();
                if ((d & 0xC0) != 128) {
                    this._reportInvalidOther(d & 0xFF);
                }
                c = c << 6 | d & 0x3F;
                if (needed > 2) {
                    d = this.nextByte();
                    if ((d & 0xC0) != 128) {
                        this._reportInvalidOther(d & 0xFF);
                    }
                    c = c << 6 | d & 0x3F;
                }
            }
        }
        return c;
    }

    private final int _decodeUtf8_2(int c) throws IOException, JsonParseException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private final int _decodeUtf8_3(int c1) throws IOException, JsonParseException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_3fast(int c1) throws IOException, JsonParseException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        return c;
    }

    private final int _decodeUtf8_4(int c) throws IOException, JsonParseException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    private final void _skipUtf8_2(int c) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(c & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_3(int c) throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(c & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(c & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_4(int c) throws IOException, JsonParseException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((d & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    protected final void _skipCR() throws IOException {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected final void _skipLF() throws IOException {
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int nextByte() throws IOException, JsonParseException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidChar(int c) throws JsonParseException {
        if (c < 32) {
            this._throwInvalidSpace(c);
        }
        this._reportInvalidInitial(c);
    }

    protected void _reportInvalidInitial(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }

    protected void _reportInvalidOther(int mask, int ptr) throws JsonParseException {
        this._inputPtr = ptr;
        this._reportInvalidOther(mask);
    }

    public static int[] growArrayBy(int[] arr, int more) {
        if (arr == null) {
            return new int[more];
        }
        int[] old = arr;
        int len = arr.length;
        arr = new int[len + more];
        System.arraycopy(old, 0, arr, 0, len);
        return arr;
    }

    @Override
    protected byte[] _decodeBase64(Base64Variant b64variant) throws IOException, JsonParseException {
        ByteArrayBuilder builder = this._getByteArrayBuilder();
        while (true) {
            int ch;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((ch = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int bits = b64variant.decodeBase64Char(ch);
            if (bits < 0) {
                if (ch == 34) {
                    return builder.toByteArray();
                }
                throw this.reportInvalidChar(b64variant, ch, 0);
            }
            int decodedData = bits;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((bits = b64variant.decodeBase64Char(ch = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                throw this.reportInvalidChar(b64variant, ch, 1);
            }
            decodedData = decodedData << 6 | bits;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((bits = b64variant.decodeBase64Char(ch = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (bits != -2) {
                    throw this.reportInvalidChar(b64variant, ch, 2);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (!b64variant.usesPaddingChar(ch = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                    throw this.reportInvalidChar(b64variant, ch, 3, "expected padding character '" + b64variant.getPaddingChar() + "'");
                }
                builder.append(decodedData >>= 4);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((bits = b64variant.decodeBase64Char(ch = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (bits != -2) {
                    throw this.reportInvalidChar(b64variant, ch, 3);
                }
                builder.appendTwoBytes(decodedData >>= 2);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            builder.appendThreeBytes(decodedData);
        }
    }

    protected IllegalArgumentException reportInvalidChar(Base64Variant b64variant, int ch, int bindex) throws IllegalArgumentException {
        return this.reportInvalidChar(b64variant, ch, bindex, null);
    }

    protected IllegalArgumentException reportInvalidChar(Base64Variant b64variant, int ch, int bindex, String msg) throws IllegalArgumentException {
        String base = ch <= 32 ? "Illegal white space character (code 0x" + Integer.toHexString(ch) + ") as character #" + (bindex + 1) + " of 4-char base64 unit: can only used between units" : (b64variant.usesPaddingChar(ch) ? "Unexpected padding character ('" + b64variant.getPaddingChar() + "') as character #" + (bindex + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(ch) || Character.isISOControl(ch) ? "Illegal character (code 0x" + Integer.toHexString(ch) + ") in base64 content" : "Illegal character '" + (char)ch + "' (code 0x" + Integer.toHexString(ch) + ") in base64 content"));
        if (msg != null) {
            base = base + ": " + msg;
        }
        return new IllegalArgumentException(base);
    }
}

