/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.model.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.ClasspathElement;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.model.JvmSettings;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class AppassemblerModelStaxReader {
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        int eventType = xmlStreamReader.getEventType();
        while (xmlStreamReader.hasNext()) {
            if (eventType == 1) {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (xmlStreamReader.isEndElement()) {
                    values.add(null);
                } else {
                    values.add(new StringBuffer());
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    String value = xmlStreamReader.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append(text);
            } else if (eventType == 2) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public byte getByteValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage());
            }
        }
        return null;
    }

    public String getDefaultValue(String s, String v) {
        if (s == null) {
            s = v;
        }
        return s;
    }

    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private Classpath parseClasspath(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Classpath classpath = new Classpath();
        classpath.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("dependencies");
                ArrayList dependencies = new ArrayList();
                classpath.setDependencies(dependencies);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("dependency")) {
                        classpath.addDependency(this.parseDependency("dependency", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("directories")) {
                if (parsed.contains("directories")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("directories");
                ArrayList directories = new ArrayList();
                classpath.setDirectories(directories);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("directory")) {
                        classpath.addDirectory(this.parseDirectory("directory", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return classpath;
    }

    private ClasspathElement parseClasspathElement(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ClasspathElement classpathElement = new ClasspathElement();
        classpathElement.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("relativePath")) {
                if (parsed.contains("relativePath")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("relativePath");
                classpathElement.setRelativePath(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return classpathElement;
    }

    private Daemon parseDaemon(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Daemon daemon = new Daemon();
        daemon.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        boolean foundRoot = false;
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            if (xmlStreamReader.getLocalName().equals(tagName)) {
                foundRoot = true;
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                daemon.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("mainClass")) {
                if (parsed.contains("mainClass")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("mainClass");
                daemon.setMainClass(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("classpath")) {
                if (parsed.contains("classpath")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("classpath");
                daemon.setClasspath(this.parseClasspath("classpath", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("commandLineArguments")) {
                if (parsed.contains("commandLineArguments")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("commandLineArguments");
                ArrayList<String> commandLineArguments = new ArrayList<String>();
                daemon.setCommandLineArguments(commandLineArguments);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("commandLineArgument")) {
                        commandLineArguments.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("jvmSettings")) {
                if (parsed.contains("jvmSettings")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("jvmSettings");
                daemon.setJvmSettings(this.parseJvmSettings("jvmSettings", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("environmentSetupFileName")) {
                if (parsed.contains("environmentSetupFileName")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("environmentSetupFileName");
                daemon.setEnvironmentSetupFileName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("showConsoleWindow")) {
                if (parsed.contains("showConsoleWindow")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("showConsoleWindow");
                daemon.setShowConsoleWindow(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "true")), "showConsoleWindow", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("useTimestampInSnapshotFileName")) {
                if (parsed.contains("useTimestampInSnapshotFileName")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("useTimestampInSnapshotFileName");
                daemon.setUseTimestampInSnapshotFileName(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "true")), "useTimestampInSnapshotFileName", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("useDaemonIdAsWrapperConfName")) {
                if (parsed.contains("useDaemonIdAsWrapperConfName")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("useDaemonIdAsWrapperConfName");
                daemon.setUseDaemonIdAsWrapperConfName(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "useDaemonIdAsWrapperConfName", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("generatorConfigurations")) {
                if (parsed.contains("generatorConfigurations")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("generatorConfigurations");
                ArrayList generatorConfigurations = new ArrayList();
                daemon.setGeneratorConfigurations(generatorConfigurations);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("generatorConfiguration")) {
                        daemon.addGeneratorConfiguration(this.parseGeneratorConfiguration("generatorConfiguration", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("repositoryName")) {
                if (parsed.contains("repositoryName")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("repositoryName");
                daemon.setRepositoryName(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "repo")));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("licenseHeaderFile")) {
                if (parsed.contains("licenseHeaderFile")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("licenseHeaderFile");
                daemon.setLicenseHeaderFile(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("wrapperLogFile")) {
                if (parsed.contains("wrapperLogFile")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("wrapperLogFile");
                daemon.setWrapperLogFile(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("unixScriptTemplate")) {
                if (parsed.contains("unixScriptTemplate")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("unixScriptTemplate");
                daemon.setUnixScriptTemplate(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("windowsScriptTemplate")) {
                if (parsed.contains("windowsScriptTemplate")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("windowsScriptTemplate");
                daemon.setWindowsScriptTemplate(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!foundRoot || !strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return daemon;
    }

    private Dependency parseDependency(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Dependency dependency = new Dependency();
        dependency.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("groupId");
                dependency.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("artifactId");
                dependency.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("version");
                dependency.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("classifier")) {
                if (parsed.contains("classifier")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("classifier");
                dependency.setClassifier(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("relativePath")) {
                if (parsed.contains("relativePath")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("relativePath");
                dependency.setRelativePath(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return dependency;
    }

    private Directory parseDirectory(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        Directory directory = new Directory();
        directory.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("relativePath")) {
                if (parsed.contains("relativePath")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("relativePath");
                directory.setRelativePath(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return directory;
    }

    private GeneratorConfiguration parseGeneratorConfiguration(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        GeneratorConfiguration generatorConfiguration = new GeneratorConfiguration();
        generatorConfiguration.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("generator")) {
                if (parsed.contains("generator")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("generator");
                generatorConfiguration.setGenerator(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("configuration");
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    generatorConfiguration.addConfiguration(key, value);
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("includes")) {
                if (parsed.contains("includes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("includes");
                ArrayList<String> includes = new ArrayList<String>();
                generatorConfiguration.setIncludes(includes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("include")) {
                        includes.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return generatorConfiguration;
    }

    private JvmSettings parseJvmSettings(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        JvmSettings jvmSettings = new JvmSettings();
        jvmSettings.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("initialMemorySize")) {
                if (parsed.contains("initialMemorySize")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("initialMemorySize");
                jvmSettings.setInitialMemorySize(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("maxMemorySize")) {
                if (parsed.contains("maxMemorySize")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("maxMemorySize");
                jvmSettings.setMaxMemorySize(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("maxStackSize")) {
                if (parsed.contains("maxStackSize")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("maxStackSize");
                jvmSettings.setMaxStackSize(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("systemProperties")) {
                if (parsed.contains("systemProperties")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("systemProperties");
                ArrayList<String> systemProperties = new ArrayList<String>();
                jvmSettings.setSystemProperties(systemProperties);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("systemProperty")) {
                        systemProperties.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("extraArguments")) {
                if (parsed.contains("extraArguments")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("extraArguments");
                ArrayList<String> extraArguments = new ArrayList<String>();
                jvmSettings.setExtraArguments(extraArguments);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("extraArgument")) {
                        extraArguments.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return jvmSettings;
    }

    public Daemon read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        Daemon value = this.parseDaemon("daemon", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public Daemon read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public Daemon read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURL().toExternalForm(), new FileInputStream(file));
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        Daemon value = this.parseDaemon("daemon", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public Daemon read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private void resolveReferences(Daemon value) {
    }
}

