/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate.in;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.typed.TypedXMLStreamException;
import org.codehaus.staxmate.in.CursorBase;
import org.codehaus.staxmate.in.DefaultElementInfo;
import org.codehaus.staxmate.in.ElementInfoFactory;
import org.codehaus.staxmate.in.SMElementInfo;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMFilterFactory;
import org.codehaus.staxmate.in.SMInputContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMInputCursor
extends CursorBase {
    protected SMFilter mFilter = null;
    protected Tracking mElemTracking = Tracking.NONE;
    protected ElementInfoFactory mElemInfoFactory;
    protected Object mData;

    public SMInputCursor(SMInputContext ctxt, SMInputCursor parent, SMFilter filter) {
        super(ctxt, parent == null ? 0 : ctxt.getDepth());
        this.mFilter = filter;
        if (parent == null) {
            this.mElemTracking = Tracking.NONE;
            this._parentTrackedElement = null;
            this.mElemInfoFactory = null;
        } else {
            this.mElemTracking = parent.getElementTracking();
            this._parentTrackedElement = parent.getTrackedElement();
            this.mElemInfoFactory = parent.getElementInfoFactory();
        }
    }

    public final void setFilter(SMFilter f) {
        this.mFilter = f;
    }

    public final void setElementTracking(Tracking tracking) {
        this.mElemTracking = tracking;
    }

    public final Tracking getElementTracking() {
        return this.mElemTracking;
    }

    public final void setElementInfoFactory(ElementInfoFactory f) {
        this.mElemInfoFactory = f;
    }

    public final ElementInfoFactory getElementInfoFactory() {
        return this.mElemInfoFactory;
    }

    public int getNodeCount() {
        return this._nodeCount;
    }

    public int getElementCount() {
        return this._elemCount;
    }

    public abstract int getParentCount();

    public SMEvent getCurrEvent() {
        return this._currEvent;
    }

    public int getCurrEventCode() {
        return this._currEvent == null ? 0 : this._currEvent.getEventCode();
    }

    @Override
    public final boolean isRootCursor() {
        return this._baseDepth == 0;
    }

    public SMElementInfo getTrackedElement() {
        return this._trackedElement;
    }

    public SMElementInfo getParentTrackedElement() {
        return this._parentTrackedElement;
    }

    public final boolean readerAccessible() {
        return this._state == CursorBase.State.ACTIVE;
    }

    public final XMLStreamReader2 getStreamReader() {
        return this._getStreamReader();
    }

    public Location getCursorLocation() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getCursorLocation");
        }
        return this._context.getEventLocation();
    }

    public Location getStreamLocation() {
        return this._context.getStreamLocation();
    }

    @Deprecated
    public Location getLocation() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getLocation");
        }
        return this._context.getStreamLocation();
    }

    public String getText() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getText");
        }
        return this._streamReader.getText();
    }

    public String collectDescendantText(boolean includeIgnorable) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("collectDescendantText");
        }
        SMFilter f = includeIgnorable ? SMFilterFactory.getTextOnlyFilter() : SMFilterFactory.getNonIgnorableTextFilter();
        SMInputCursor childIt = this.descendantCursor(f);
        if (childIt.getNext() == null) {
            return "";
        }
        String text = childIt.getText();
        if (childIt.getNext() == null) {
            return text;
        }
        XMLStreamReader2 sr = childIt._getStreamReader();
        int size = text.length() + sr.getTextLength() + 20;
        StringBuilder sb = new StringBuilder(Math.max(size, 100));
        sb.append(text);
        do {
            sb.append(sr.getTextCharacters(), sr.getTextStart(), sr.getTextLength());
        } while (childIt.getNext() != null);
        return sb.toString();
    }

    public final String collectDescendantText() throws XMLStreamException {
        return this.collectDescendantText(false);
    }

    public void processDescendantText(Writer w, boolean includeIgnorable) throws IOException, XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("processDescendantText");
        }
        SMFilter f = includeIgnorable ? SMFilterFactory.getTextOnlyFilter() : SMFilterFactory.getNonIgnorableTextFilter();
        SMInputCursor childIt = this.descendantCursor(f);
        XMLStreamReader2 sr = childIt._getStreamReader();
        while (childIt.getNext() != null) {
            sr.getText(w, true);
        }
    }

    public QName getQName() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getQName");
        }
        return this._streamReader.getName();
    }

    public String getLocalName() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getLocalName");
        }
        switch (this.getCurrEventCode()) {
            case 1: 
            case 2: 
            case 9: {
                return this._streamReader.getLocalName();
            }
            case 3: {
                return this._streamReader.getPITarget();
            }
            case 11: {
                DTDInfo dtd = this._streamReader.getDTDInfo();
                return dtd == null ? null : dtd.getDTDRootName();
            }
        }
        return null;
    }

    public String getPrefix() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getPrefix");
        }
        String prefix = this._streamReader.getPrefix();
        return prefix == null ? "" : prefix;
    }

    public String getNsUri() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getNsUri");
        }
        String uri = this._streamReader.getNamespaceURI();
        return uri == null ? "" : uri;
    }

    public String getPrefixedName() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getPrefixedName");
        }
        return this._streamReader.getPrefixedName();
    }

    public boolean hasLocalName(String expName) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("hasName");
        }
        if (expName == null) {
            throw new IllegalArgumentException("Can not pass null name to method");
        }
        String name = this.getLocalName();
        return name != null && expName.equals(name);
    }

    public boolean hasName(String expNsURI, String expLN) throws XMLStreamException {
        String uri;
        String ln;
        if (!this.readerAccessible()) {
            throw this._notAccessible("hasName");
        }
        int type = this.getCurrEventCode();
        switch (type) {
            case 1: 
            case 2: {
                ln = this._streamReader.getLocalName();
                uri = this._streamReader.getNamespaceURI();
                break;
            }
            case 9: {
                ln = this._streamReader.getLocalName();
                uri = null;
                break;
            }
            case 3: {
                ln = this._streamReader.getPITarget();
                uri = null;
                break;
            }
            case 11: {
                DTDInfo dtd = this._streamReader.getDTDInfo();
                ln = dtd == null ? null : dtd.getDTDRootName();
                uri = null;
                break;
            }
            default: {
                return false;
            }
        }
        if (ln == null || !ln.equals(expLN)) {
            return false;
        }
        if (expNsURI == null || expNsURI.length() == 0) {
            return uri == null || uri.length() == 0;
        }
        return uri != null && expNsURI.equals(uri);
    }

    public boolean hasName(QName qname) throws XMLStreamException {
        return this.hasName(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public XMLEvent asEvent() throws XMLStreamException {
        if (!this.readerAccessible()) {
            return null;
        }
        return this._context.currentAsEvent();
    }

    public int getAttrCount() throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrCount");
        }
        return this._streamReader.getAttributeCount();
    }

    public int findAttrIndex(String uri, String localName) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrCount");
        }
        return this._streamReader.getAttributeIndex(uri, localName);
    }

    public QName getAttrName(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrName");
        }
        return this._streamReader.getAttributeName(index);
    }

    public String getAttrLocalName(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrLocalName");
        }
        return this._streamReader.getAttributeLocalName(index);
    }

    public String getAttrPrefix(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrPrefix");
        }
        String prefix = this._streamReader.getAttributePrefix(index);
        return prefix == null ? "" : prefix;
    }

    public String getAttrNsUri(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrNsUri");
        }
        String uri = this._streamReader.getAttributeNamespace(index);
        return uri == null ? "" : uri;
    }

    public String getAttrValue(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttributeValue");
        }
        return this._streamReader.getAttributeValue(index);
    }

    public String getAttrValue(String localName) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttributeValue");
        }
        return this._streamReader.getAttributeValue(null, localName);
    }

    public String getAttrValue(String namespaceURI, String localName) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrValue");
        }
        return this._streamReader.getAttributeValue(namespaceURI, localName);
    }

    public boolean getAttrBooleanValue(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrBooleanValue");
        }
        return this._streamReader.getAttributeAsBoolean(index);
    }

    public boolean getAttrBooleanValue(int index, boolean defValue) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrBooleanValue");
        }
        try {
            return this._streamReader.getAttributeAsBoolean(index);
        }
        catch (TypedXMLStreamException e) {
            return defValue;
        }
    }

    public int getAttrIntValue(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrIntValue");
        }
        return this._streamReader.getAttributeAsInt(index);
    }

    public int getAttrIntValue(int index, int defValue) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrIntValue");
        }
        try {
            return this._streamReader.getAttributeAsInt(index);
        }
        catch (TypedXMLStreamException e) {
            return defValue;
        }
    }

    public long getAttrLongValue(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrLongValue");
        }
        return this._streamReader.getAttributeAsLong(index);
    }

    public long getAttrLongValue(int index, long defValue) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrLongValue");
        }
        try {
            return this._streamReader.getAttributeAsLong(index);
        }
        catch (TypedXMLStreamException e) {
            return defValue;
        }
    }

    public double getAttrDoubleValue(int index) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrDoubleValue");
        }
        return this._streamReader.getAttributeAsDouble(index);
    }

    public double getAttrDoubleValue(int index, double defValue) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrDoubleValue");
        }
        try {
            return this._streamReader.getAttributeAsDouble(index);
        }
        catch (TypedXMLStreamException e) {
            return defValue;
        }
    }

    public <T extends Enum<T>> T getAttrEnumValue(int index, Class<T> enumType) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrEnumValue");
        }
        String value = this._streamReader.getAttributeValue(index).trim();
        if (value.length() == 0) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypedException(value, iae, "Invalid enumeration value '" + value + "'; not one of values of " + enumType.getName());
        }
    }

    @Deprecated
    public int getAttrIntValue(String uri, String localName) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrIntValue");
        }
        return this.getAttrIntValue(this.findAttrIndex(uri, localName));
    }

    @Deprecated
    public int getAttrIntValue(String uri, String localName, int defValue) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible("getAttrIntValue");
        }
        return this.getAttrIntValue(this.findAttrIndex(uri, localName), defValue);
    }

    public String getElemStringValue() throws XMLStreamException {
        this._verifyElemAccess("getElemStringValue");
        this._currEvent = SMEvent.END_ELEMENT;
        return this._streamReader.getElementText();
    }

    public boolean getElemBooleanValue() throws XMLStreamException {
        this._verifyElemAccess("getElemBooleanValue");
        this._currEvent = SMEvent.END_ELEMENT;
        return this._streamReader.getElementAsBoolean();
    }

    public boolean getElemBooleanValue(boolean defValue) throws XMLStreamException {
        this._verifyElemAccess("getElemBooleanValue");
        this._currEvent = SMEvent.END_ELEMENT;
        try {
            return this._streamReader.getElementAsBoolean();
        }
        catch (TypedXMLStreamException tse) {
            this._ensureEndElement();
            return defValue;
        }
    }

    public int getElemIntValue() throws XMLStreamException {
        this._verifyElemAccess("getElemIntValue");
        this._currEvent = SMEvent.END_ELEMENT;
        return this._streamReader.getElementAsInt();
    }

    public int getElemIntValue(int defValue) throws XMLStreamException {
        this._verifyElemAccess("getElemIntValue");
        this._currEvent = SMEvent.END_ELEMENT;
        try {
            return this._streamReader.getElementAsInt();
        }
        catch (TypedXMLStreamException tse) {
            this._ensureEndElement();
            return defValue;
        }
    }

    public long getElemLongValue() throws XMLStreamException {
        this._verifyElemAccess("getElemLongValue");
        this._currEvent = SMEvent.END_ELEMENT;
        return this._streamReader.getElementAsLong();
    }

    public long getElemLongValue(long defValue) throws XMLStreamException {
        this._verifyElemAccess("getElemLongValue");
        this._currEvent = SMEvent.END_ELEMENT;
        try {
            return this._streamReader.getElementAsLong();
        }
        catch (TypedXMLStreamException tse) {
            this._ensureEndElement();
            return defValue;
        }
    }

    public double getElemDoubleValue() throws XMLStreamException {
        this._verifyElemAccess("getElemDoubleValue");
        this._currEvent = SMEvent.END_ELEMENT;
        return this._streamReader.getElementAsDouble();
    }

    public double getElemDoubleValue(double defValue) throws XMLStreamException {
        this._verifyElemAccess("getElemDoubleValue");
        this._currEvent = SMEvent.END_ELEMENT;
        try {
            return this._streamReader.getElementAsDouble();
        }
        catch (TypedXMLStreamException tse) {
            this._ensureEndElement();
            return defValue;
        }
    }

    public <T extends Enum<T>> T getElemEnumValue(Class<T> enumType) throws XMLStreamException {
        this._verifyElemAccess("getElemEnumValue");
        this._currEvent = SMEvent.END_ELEMENT;
        String value = this._streamReader.getElementText().trim();
        if (value.length() == 0) {
            return null;
        }
        try {
            return Enum.valueOf(enumType, value);
        }
        catch (IllegalArgumentException iae) {
            throw this._constructTypedException(value, iae, "Invalid enumeration value '" + value + "'; not one of values of " + enumType.getName());
        }
    }

    private final void _verifyElemAccess(String method) throws XMLStreamException {
        if (!this.readerAccessible()) {
            throw this._notAccessible(method);
        }
        if (this.getCurrEvent() != SMEvent.START_ELEMENT) {
            throw this._wrongState(method, SMEvent.START_ELEMENT);
        }
    }

    private final void _ensureEndElement() throws XMLStreamException {
        int code = this._streamReader.getEventType();
        if (code != 2) {
            throw new XMLStreamException("Excepted state to be END_ELEMENT, got " + (Object)((Object)SMInputCursor.eventObjectByEventId(code)), this._streamReader.getLocation());
        }
    }

    public Object getData() {
        return this.mData;
    }

    public void setData(Object o) {
        this.mData = o;
    }

    public abstract SMEvent getNext() throws XMLStreamException;

    public final SMInputCursor advance() throws XMLStreamException {
        this.getNext();
        return this;
    }

    public SMInputCursor childCursor(SMFilter f) throws XMLStreamException {
        if (this._state != CursorBase.State.ACTIVE) {
            if (this._state == CursorBase.State.HAS_CHILD) {
                throw new IllegalStateException("Child cursor already requested.");
            }
            throw new IllegalStateException("Can not iterate children: cursor does not point to a start element (state " + this.getStateDesc() + ")");
        }
        if (this._currEvent != SMEvent.START_ELEMENT) {
            throw new IllegalStateException("Can not iterate children: cursor does not point to a start element (pointing to " + (Object)((Object)this._currEvent) + ")");
        }
        this._childCursor = this.constructChildCursor(f);
        this._state = CursorBase.State.HAS_CHILD;
        return this._childCursor;
    }

    public final SMInputCursor childCursor() throws XMLStreamException {
        return this.childCursor(null);
    }

    public SMInputCursor descendantCursor(SMFilter f) throws XMLStreamException {
        if (this._state != CursorBase.State.ACTIVE) {
            if (this._state == CursorBase.State.HAS_CHILD) {
                throw new IllegalStateException("Child cursor already requested.");
            }
            throw new IllegalStateException("Can not iterate children: cursor does not point to a start element (state " + this.getStateDesc() + ")");
        }
        if (this._currEvent != SMEvent.START_ELEMENT) {
            throw new IllegalStateException("Can not iterate children: cursor does not point to a start element (pointing to " + (Object)((Object)this._currEvent) + ")");
        }
        this._childCursor = this.constructDescendantCursor(f);
        this._state = CursorBase.State.HAS_CHILD;
        return this._childCursor;
    }

    public final SMInputCursor descendantCursor() throws XMLStreamException {
        return this.descendantCursor(null);
    }

    public final SMInputCursor childElementCursor() throws XMLStreamException {
        return this.childCursor(SMFilterFactory.getElementOnlyFilter());
    }

    public final SMInputCursor childElementCursor(QName elemName) throws XMLStreamException {
        return this.childCursor(SMFilterFactory.getElementOnlyFilter(elemName));
    }

    public final SMInputCursor childElementCursor(String elemLocalName) throws XMLStreamException {
        return this.childCursor(SMFilterFactory.getElementOnlyFilter(elemLocalName));
    }

    public final SMInputCursor descendantElementCursor() throws XMLStreamException {
        return this.descendantCursor(SMFilterFactory.getElementOnlyFilter());
    }

    public final SMInputCursor descendantElementCursor(QName elemName) throws XMLStreamException {
        return this.descendantCursor(SMFilterFactory.getElementOnlyFilter(elemName));
    }

    public final SMInputCursor descendantElementCursor(String elemLocalName) throws XMLStreamException {
        return this.descendantCursor(SMFilterFactory.getElementOnlyFilter(elemLocalName));
    }

    public final SMInputCursor childMixedCursor() throws XMLStreamException {
        return this.childCursor(SMFilterFactory.getMixedFilter());
    }

    public final SMInputCursor descendantMixedCursor() throws XMLStreamException {
        return this.descendantCursor(SMFilterFactory.getMixedFilter());
    }

    @Override
    public XMLStreamException constructStreamException(String msg) {
        return new XMLStreamException(msg, this.getStreamLocation());
    }

    @Override
    public void throwStreamException(String msg) throws XMLStreamException {
        throw this.constructStreamException(msg);
    }

    public String getPathDesc() {
        SMElementInfo parent = this.getParentTrackedElement();
        if (parent == null && this.getElementTracking() == Tracking.NONE) {
            return ".";
        }
        StringBuilder sb = new StringBuilder(100);
        SMInputCursor.appendPathDesc(sb, parent, true);
        SMElementInfo curr = this.getTrackedElement();
        if (curr != null && this.getCurrEvent() == SMEvent.START_ELEMENT) {
            SMInputCursor.appendPathDesc(sb, this._trackedElement, false);
        } else {
            sb.append("/*[n").append(this.getNodeCount()).append(']');
        }
        return sb.toString();
    }

    private static void appendPathDesc(StringBuilder sb, SMElementInfo info, boolean recursive) {
        if (info == null) {
            return;
        }
        if (recursive) {
            SMInputCursor.appendPathDesc(sb, info.getParent(), true);
        }
        sb.append('/');
        String prefix = info.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            sb.append(prefix);
            sb.append(':');
        }
        sb.append(info.getLocalName());
        sb.append("[e").append(info.getElementIndex()).append(']');
    }

    @Override
    protected String getCurrEventDesc() {
        return this._currEvent == null ? "[null]" : this._currEvent.toString();
    }

    @Override
    public String toString() {
        return "[Cursor that point(s/ed) to: " + this.getCurrEventDesc() + "]";
    }

    protected SMElementInfo constructElementInfo(SMElementInfo parent, SMElementInfo prevSibling) throws XMLStreamException {
        if (this.mElemInfoFactory != null) {
            return this.mElemInfoFactory.constructElementInfo(this, parent, prevSibling);
        }
        XMLStreamReader2 sr = this._streamReader;
        return new DefaultElementInfo(parent, prevSibling, sr.getPrefix(), sr.getNamespaceURI(), sr.getLocalName(), this._nodeCount - 1, this._elemCount - 1, this.getParentCount());
    }

    protected abstract SMInputCursor constructChildCursor(SMFilter var1) throws XMLStreamException;

    protected abstract SMInputCursor constructDescendantCursor(SMFilter var1) throws XMLStreamException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tracking {
        NONE,
        PARENTS,
        VISIBLE_SIBLINGS,
        ALL_SIBLINGS;

    }
}

