/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.Linear;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MultiLineString<P extends Position>
extends GeometryCollection<P, LineString<P>>
implements Linear {
    public MultiLineString(LineString<P> ... lineStrings) {
        super((Geometry[])lineStrings);
    }

    public MultiLineString(CoordinateReferenceSystem<P> crs) {
        super(crs);
    }

    public Position getStartPosition() {
        return this.getPositionN(0);
    }

    public Position getEndPosition() {
        return this.getPositionN(this.getNumPositions() - 1);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.MULTILINESTRING;
    }

    @Override
    public Class<? extends Geometry> getComponentType() {
        return LineString.class;
    }
}

