/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.Stack;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LLAPositionVisitor;
import org.geolatte.geom.Measured;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.cga.NumericalMethods;
import org.geolatte.geom.codec.db.Encoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;

public abstract class AbstractSDOEncoder
implements Encoder<SDOGeometry> {
    protected <P extends Position> int getLRSDim(Geometry<P> geom) {
        if (Measured.class.isAssignableFrom(geom.getPositionClass())) {
            if (geom.getCoordinateDimension() == 3) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    protected SDOGeometry addPolygon(SDOGeometry sdoGeom, Polygon polygon) {
        int numInteriorRings = polygon.getNumInteriorRing();
        ElemInfo info = new ElemInfo(numInteriorRings + 1);
        int ordinatesPreviousOffset = 0;
        if (sdoGeom.getOrdinates() != null) {
            ordinatesPreviousOffset = sdoGeom.getOrdinates().getOrdinateArray().length;
        }
        int ordinatesOffset = ordinatesPreviousOffset + 1;
        Double[] ordinates = new Double[]{};
        for (int i = 0; i < info.getSize(); ++i) {
            PositionSequence positionSequence;
            ElementType et;
            if (i == 0) {
                et = ElementType.EXTERIOR_RING_STRAIGHT_SEGMENTS;
                positionSequence = polygon.getExteriorRing().getPositions();
                if (!NumericalMethods.isCounterClockwise(positionSequence)) {
                    positionSequence = this.reverse(positionSequence);
                }
            } else {
                et = ElementType.INTERIOR_RING_STRAIGHT_SEGMENTS;
                positionSequence = polygon.getInteriorRingN(i - 1).getPositions();
                if (NumericalMethods.isCounterClockwise(positionSequence)) {
                    positionSequence = this.reverse(positionSequence);
                }
            }
            info.setElement(i, ordinatesOffset, et, 0);
            ordinates = this.addOrdinates(ordinates, this.convertPositionSequence(positionSequence));
            ordinatesOffset = ordinatesPreviousOffset + ordinates.length + 1;
        }
        ElemInfo newInfo = this.addElementInfo(sdoGeom.getInfo(), info);
        Ordinates newOrdiantes = this.addOrdinates(sdoGeom.getOrdinates(), ordinates);
        return new SDOGeometry(sdoGeom.getGType(), sdoGeom.getSRID(), null, newInfo, newOrdiantes);
    }

    protected ElemInfo addElementInfo(ElemInfo oldInfo, ElemInfo added) {
        if (oldInfo == null) {
            return added;
        }
        oldInfo.addElement(added);
        return oldInfo;
    }

    protected Ordinates addOrdinates(Ordinates oldOrdinates, Double[] newOrdinates) {
        if (oldOrdinates == null) {
            return new Ordinates(newOrdinates);
        }
        oldOrdinates.addOrdinates(newOrdinates);
        return oldOrdinates;
    }

    protected Double[] convertPositionSequence(PositionSequence<?> coordinates) {
        int dim = coordinates.getCoordinateDimension();
        if (dim > 4) {
            throw new IllegalArgumentException("Dim parameter value cannot be greater than 4");
        }
        Double[] converted = new Double[coordinates.size() * dim];
        ToArrayVisitor visitor = new ToArrayVisitor(converted);
        coordinates.accept(visitor);
        return converted;
    }

    protected <P extends Position> PositionSequence<P> reverse(PositionSequence<P> positions) {
        PositionSequenceBuilder<Position> builder = PositionSequenceBuilders.fixedSized(positions.size(), positions.getPositionClass());
        Stack<Position> stack = new Stack<Position>();
        for (Position pos : positions) {
            stack.push(pos);
        }
        while (!stack.empty()) {
            builder.add((Position)stack.pop());
        }
        return builder.toPositionSequence();
    }

    protected Double[] addOrdinates(Double[] oldOrdinates, Double[] newOrdinates) {
        Double[] combined = new Double[oldOrdinates.length + newOrdinates.length];
        System.arraycopy(oldOrdinates, 0, combined, 0, oldOrdinates.length);
        System.arraycopy(newOrdinates, 0, combined, oldOrdinates.length, newOrdinates.length);
        return combined;
    }

    private static Double toDouble(double d) {
        return Double.isNaN(d) ? null : Double.valueOf(d);
    }

    static class ToArrayVisitor
    implements LLAPositionVisitor {
        private final Double[] result;
        int idx = 0;

        ToArrayVisitor(Double[] result) {
            this.result = result;
        }

        @Override
        public void visit(double[] coordinate) {
            for (int i = 0; i < coordinate.length; ++i) {
                this.result[this.idx++] = AbstractSDOEncoder.toDouble(coordinate[i]);
            }
        }
    }
}

