/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;

public class SdoPointEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.POINT.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        int dim = geom.getCoordinateDimension();
        int lrsDim = this.getLRSDim(geom);
        boolean isLrs = lrsDim != 0;
        Double[] coord = this.convertPositionSequence(geom.getPositions());
        ElemInfo info = new ElemInfo(1);
        info.setElement(0, 1, ElementType.POINT, 1);
        return new SDOGeometry(new SDOGType(dim, lrsDim, TypeGeometry.POINT), geom.getSRID(), null, info, new Ordinates(coord));
    }
}

