/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.Decoder;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.GeometryCollectionSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.LineStringSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.MultiLineStringSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.MultiPointSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.MultiPolygonSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.PointSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.PolygonSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;

public class Decoders {
    private static final List<AbstractSqlServerDecoder> DECODERS = new ArrayList<AbstractSqlServerDecoder>();

    private static Decoder decoderFor(SqlServerGeometry object) {
        for (Decoder decoder : DECODERS) {
            if (!decoder.accepts(object)) continue;
            return decoder;
        }
        throw new IllegalArgumentException("No decoder for type " + (Object)((Object)object.openGisType()));
    }

    public static Geometry decode(byte[] raw) {
        SqlServerGeometry sqlServerGeom = SqlServerGeometry.deserialize(raw);
        Decoder decoder = Decoders.decoderFor(sqlServerGeom);
        return decoder.decode(sqlServerGeom);
    }

    public static Decoder decoderFor(OpenGisType type) {
        for (AbstractSqlServerDecoder decoder : DECODERS) {
            if (!decoder.accepts(type)) continue;
            return decoder;
        }
        throw new IllegalArgumentException("No decoder for type " + (Object)((Object)type));
    }

    static {
        DECODERS.add(new PointSqlServerDecoder());
        DECODERS.add(new LineStringSqlServerDecoder());
        DECODERS.add(new PolygonSqlServerDecoder());
        DECODERS.add(new MultiLineStringSqlServerDecoder());
        DECODERS.add(new MultiPolygonSqlServerDecoder());
        DECODERS.add(new MultiPointSqlServerDecoder());
        DECODERS.add(new GeometryCollectionSqlServerDecoder());
    }
}

