/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystem;
import org.geolatte.geom.crs.OneDimensionCoordinateSystem;
import org.geolatte.geom.crs.SingleCoordinateReferenceSystem;

public class CompoundCoordinateReferenceSystem<P extends Position>
extends CoordinateReferenceSystem<P> {
    private final List<SingleCoordinateReferenceSystem<?>> components;

    protected CompoundCoordinateReferenceSystem(String name, SingleCoordinateReferenceSystem<?> ... components) {
        super(components[0].getCrsId(), name, CompoundCoordinateReferenceSystem.combineCS(components));
        this.components = Arrays.asList(components);
    }

    private static CoordinateSystem<?> combineCS(SingleCoordinateReferenceSystem<?>[] components) {
        if (components == null || components.length == 0) {
            throw new IllegalArgumentException("Too few arguments, or null arguments");
        }
        CoordinateSystem<Object> coordinateSystem = null;
        for (SingleCoordinateReferenceSystem<?> component : components) {
            if (coordinateSystem == null) {
                coordinateSystem = component.getCoordinateSystem();
                continue;
            }
            if (component.getCoordinateSystem() instanceof OneDimensionCoordinateSystem) {
                coordinateSystem = coordinateSystem.merge((OneDimensionCoordinateSystem)component.getCoordinateSystem());
                continue;
            }
            throw new UnsupportedOperationException("Can't merge specified coordinate systems");
        }
        return coordinateSystem;
    }

    public List<SingleCoordinateReferenceSystem<?>> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public boolean isCompound() {
        return true;
    }
}

