/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.GrizzlyTestCase;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.nio.transport.UDPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransportBuilder;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.utils.EchoFilter;

public class UDPNIOTransportTest
extends GrizzlyTestCase {
    public static final int PORT = 7777;

    @Override
    protected void setUp() throws Exception {
        ByteBufferWrapper.DEBUG_MODE = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartStop() throws IOException {
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        try {
            transport.bind(7777);
            transport.start();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            UDPNIOTransportTest.assertTrue((String)"Exception!!!", (boolean)false);
        }
        finally {
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPortRangeBind() throws Exception {
        int portsTest = 10;
        PortRange portRange = new PortRange(7777, 7786);
        Connection connection = null;
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().setReuseAddress(false).build();
        try {
            for (int i = 0; i < 10; ++i) {
                UDPNIOServerConnection serverConnection = transport.bind("localhost", portRange, 4096);
            }
            try {
                transport.bind("localhost", portRange, 4096);
                UDPNIOTransportTest.fail((String)"All ports in range had to be occupied");
            }
            catch (IOException e) {
                // empty catch block
            }
            transport.start();
            for (int i = 0; i < 10; ++i) {
                GrizzlyFuture future = transport.connect("localhost", 7777 + i);
                connection = (Connection)future.get(10L, TimeUnit.SECONDS);
                UDPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
                connection.close();
            }
        }
        finally {
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectorHandlerConnect() throws Exception {
        Connection connection = null;
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture future = transport.connect("localhost", 7777);
            connection = (Connection)future.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectorHandlerConnectAndWrite() throws Exception {
        Connection connection = null;
        StreamWriter writer = null;
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.configureBlocking(true);
            writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            byte[] sendingBytes = "Hello".getBytes();
            writer.writeByteArray(sendingBytes);
            GrizzlyFuture writeFuture = writer.flush();
            Integer bytesWritten = (Integer)writeFuture.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertTrue((boolean)writeFuture.isDone());
            UDPNIOTransportTest.assertEquals((int)sendingBytes.length, (int)bytesWritten);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleEcho() throws Exception {
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            connection.configureBlocking(true);
            byte[] originalMessage = "Hello".getBytes();
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            writer.writeByteArray(originalMessage);
            GrizzlyFuture writeFuture = writer.flush();
            UDPNIOTransportTest.assertTrue((String)"Write timeout", (boolean)writeFuture.isDone());
            UDPNIOTransportTest.assertEquals((int)originalMessage.length, (int)((Integer)writeFuture.get()));
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            GrizzlyFuture readFuture = reader.notifyAvailable(originalMessage.length);
            UDPNIOTransportTest.assertTrue((String)"Read timeout", (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
            byte[] echoMessage = new byte[originalMessage.length];
            reader.readByteArray(echoMessage);
            UDPNIOTransportTest.assertTrue((boolean)Arrays.equals(echoMessage, originalMessage));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralPacketsEcho() throws Exception {
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7777);
            transport.start();
            transport.configureBlocking(true);
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            for (int i = 0; i < 100; ++i) {
                byte[] originalMessage = ("Hello world #" + i).getBytes();
                writer.writeByteArray(originalMessage);
                GrizzlyFuture writeFuture = writer.flush();
                UDPNIOTransportTest.assertTrue((String)"Write timeout", (boolean)writeFuture.isDone());
                UDPNIOTransportTest.assertEquals((int)originalMessage.length, (int)((Integer)writeFuture.get()));
                GrizzlyFuture readFuture = reader.notifyAvailable(originalMessage.length);
                UDPNIOTransportTest.assertTrue((String)"Read timeout", (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
                byte[] echoMessage = new byte[originalMessage.length];
                reader.readByteArray(echoMessage);
                UDPNIOTransportTest.assertTrue((boolean)Arrays.equals(echoMessage, originalMessage));
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncReadWriteEcho() throws Exception {
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            byte[] originalMessage = "Hello".getBytes();
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            writer.writeByteArray(originalMessage);
            GrizzlyFuture writeFuture = writer.flush();
            Integer writtenBytes = (Integer)writeFuture.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertEquals((int)originalMessage.length, (int)writtenBytes);
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            GrizzlyFuture readFuture = reader.notifyAvailable(originalMessage.length);
            UDPNIOTransportTest.assertTrue((String)"Read timeout", (readFuture.get(10L, TimeUnit.SECONDS) != null ? 1 : 0) != 0);
            byte[] echoMessage = new byte[originalMessage.length];
            reader.readByteArray(echoMessage);
            UDPNIOTransportTest.assertTrue((boolean)Arrays.equals(echoMessage, originalMessage));
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralPacketsAsyncReadWriteEcho() throws Exception {
        int packetsNumber = 100;
        int packetSize = 32;
        Connection connection = null;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new EchoFilter());
        UDPNIOTransport transport = UDPNIOTransportBuilder.newInstance().build();
        transport.setProcessor((Processor)filterChainBuilder.build());
        try {
            transport.setReadBufferSize(2048);
            transport.setWriteBufferSize(2048);
            transport.bind(7777);
            transport.start();
            GrizzlyFuture connectFuture = transport.connect((SocketAddress)new InetSocketAddress("localhost", 7777), (CompletionHandler)new EmptyCompletionHandler<Connection>(){

                public void completed(Connection connection) {
                    connection.configureStandalone(true);
                }
            });
            connection = (Connection)connectFuture.get(10L, TimeUnit.SECONDS);
            UDPNIOTransportTest.assertTrue((connection != null ? 1 : 0) != 0);
            StreamReader reader = StandaloneProcessor.INSTANCE.getStreamReader(connection);
            StreamWriter writer = StandaloneProcessor.INSTANCE.getStreamWriter(connection);
            for (int i = 0; i < packetsNumber; ++i) {
                byte[] message = new byte[32];
                Arrays.fill(message, (byte)i);
                writer.writeByteArray(message);
                writer.flush();
                byte[] rcvMessage = new byte[32];
                GrizzlyFuture future = reader.notifyAvailable(32);
                future.get(10L, TimeUnit.SECONDS);
                UDPNIOTransportTest.assertTrue((boolean)future.isDone());
                reader.readByteArray(rcvMessage);
                UDPNIOTransportTest.assertTrue((String)"Message is corrupted!", (boolean)Arrays.equals(rcvMessage, message));
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            transport.stop();
        }
    }
}

