/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.io.IOException;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterExecutor;
import org.glassfish.grizzly.filterchain.NextAction;

public abstract class ExecutorResolver {
    public static final FilterExecutor UPSTREAM_EXECUTOR_SAMPLE = new UpstreamExecutor();
    public static final FilterExecutor DOWNSTREAM_EXECUTOR_SAMPLE = new DownstreamExecutor();
    private static final ExecutorResolver[] filterExecutors = new ExecutorResolver[]{null, new StaticResolver(new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleAccept(context);
        }
    }), new StaticResolver(new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleConnect(context);
        }
    }), new StaticResolver(new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleRead(context);
        }
    }), new StaticResolver(new DownstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleWrite(context);
        }
    }), new EventResolver(), new StaticResolver(new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleClose(context);
        }
    })};

    protected abstract FilterExecutor doResolve(FilterChainContext var1);

    public static FilterExecutor resolve(FilterChainContext context) {
        return filterExecutors[context.getOperation().ordinal()].doResolve(context);
    }

    public static final class EventResolver
    extends ExecutorResolver {
        private final FilterExecutor upExecutor = new UpstreamExecutor(){

            @Override
            public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
                return filter.handleEvent(context, context.event);
            }
        };
        private final FilterExecutor downExecutor = new DownstreamExecutor(){

            @Override
            public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
                return filter.handleEvent(context, context.event);
            }
        };

        @Override
        protected FilterExecutor doResolve(FilterChainContext context) {
            int startIdx = context.getStartIdx();
            int endIdx = context.getEndIdx();
            int currentIdx = context.getFilterIdx();
            if (currentIdx == Integer.MIN_VALUE || startIdx <= endIdx) {
                return this.upExecutor;
            }
            return this.downExecutor;
        }
    }

    public static final class StaticResolver
    extends ExecutorResolver {
        private final FilterExecutor executor;

        public StaticResolver(FilterExecutor executor) {
            this.executor = executor;
        }

        @Override
        protected FilterExecutor doResolve(FilterChainContext context) {
            return this.executor;
        }
    }

    public static class DownstreamExecutor
    implements FilterExecutor {
        @Override
        public final int defaultStartIdx(FilterChainContext context) {
            if (context.getFilterIdx() != Integer.MIN_VALUE) {
                return context.getFilterIdx();
            }
            int idx = context.getFilterChain().size() - 1;
            context.setFilterIdx(idx);
            return idx;
        }

        @Override
        public final int defaultEndIdx(FilterChainContext context) {
            return -1;
        }

        @Override
        public final int getNextFilter(FilterChainContext context) {
            return context.getFilterIdx() - 1;
        }

        @Override
        public final int getPreviousFilter(FilterChainContext context) {
            return context.getFilterIdx() + 1;
        }

        @Override
        public final boolean hasNextFilter(FilterChainContext context, int idx) {
            return idx > 0;
        }

        @Override
        public final boolean hasPreviousFilter(FilterChainContext context, int idx) {
            return idx < context.getFilterChain().size() - 1;
        }

        @Override
        public final void initIndexes(FilterChainContext context) {
            int startIdx = this.defaultStartIdx(context);
            context.setStartIdx(startIdx);
            context.setFilterIdx(startIdx);
            context.setEndIdx(this.defaultEndIdx(context));
        }

        @Override
        public final boolean isUpstream() {
            return false;
        }

        @Override
        public final boolean isDownstream() {
            return true;
        }

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            throw new UnsupportedOperationException("Subclasses should implement this");
        }
    }

    public static class UpstreamExecutor
    implements FilterExecutor {
        @Override
        public final int defaultStartIdx(FilterChainContext context) {
            if (context.getFilterIdx() != Integer.MIN_VALUE) {
                return context.getFilterIdx();
            }
            context.setFilterIdx(0);
            return 0;
        }

        @Override
        public final int defaultEndIdx(FilterChainContext context) {
            return context.getFilterChain().size();
        }

        @Override
        public final int getNextFilter(FilterChainContext context) {
            return context.getFilterIdx() + 1;
        }

        @Override
        public final int getPreviousFilter(FilterChainContext context) {
            return context.getFilterIdx() - 1;
        }

        @Override
        public final boolean hasNextFilter(FilterChainContext context, int idx) {
            return idx < context.getFilterChain().size() - 1;
        }

        @Override
        public final boolean hasPreviousFilter(FilterChainContext context, int idx) {
            return idx > 0;
        }

        @Override
        public final void initIndexes(FilterChainContext context) {
            int startIdx = this.defaultStartIdx(context);
            context.setStartIdx(startIdx);
            context.setFilterIdx(startIdx);
            context.setEndIdx(this.defaultEndIdx(context));
        }

        @Override
        public final boolean isUpstream() {
            return true;
        }

        @Override
        public final boolean isDownstream() {
            return false;
        }

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            throw new UnsupportedOperationException("Subclasses should implement this");
        }
    }
}

