/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.EmptyIOEventProcessingHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventProcessingHandler;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class TCPNIOServerConnection
extends TCPNIOConnection {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOServerConnection.class);
    private FutureImpl<Connection> acceptListener;
    private final RegisterAcceptedChannelCompletionHandler defaultCompletionHandler;
    private final Object acceptSync = new Object();
    protected static final IOEventProcessingHandler enableInterestProcessingHandler = new EnableReadHandler();

    public TCPNIOServerConnection(TCPNIOTransport transport, ServerSocketChannel serverSocketChannel) {
        super(transport, serverSocketChannel);
        this.defaultCompletionHandler = new RegisterAcceptedChannelCompletionHandler();
    }

    public void listen() throws IOException {
        TCPNIOTransport.RegisterChannelCompletionHandler registerCompletionHandler = ((TCPNIOTransport)this.transport).selectorRegistrationHandler;
        GrizzlyFuture<RegisterChannelResult> future = this.transport.getNIOChannelDistributor().registerChannelAsync(this.channel, 16, this, registerCompletionHandler);
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IOException("Error registering server channel key", e);
        }
        TCPNIOServerConnection.notifyProbesBind(this);
    }

    @Override
    public boolean isBlocking() {
        return this.transport.isBlocking();
    }

    @Override
    public boolean isStandalone() {
        return this.transport.isStandalone();
    }

    public GrizzlyFuture<Connection> accept() throws IOException {
        if (!this.isStandalone()) {
            throw new IllegalStateException("Accept could be used in standalone mode only");
        }
        GrizzlyFuture<Connection> future = this.acceptAsync();
        if (this.isBlocking()) {
            try {
                future.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GrizzlyFuture<Connection> acceptAsync() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is closed");
        }
        Object object = this.acceptSync;
        synchronized (object) {
            SafeFutureImpl<Connection> future = SafeFutureImpl.create();
            SocketChannel acceptedChannel = this.doAccept();
            if (acceptedChannel != null) {
                this.configureAcceptedChannel(acceptedChannel);
                this.registerAcceptedChannel(acceptedChannel, future);
            } else {
                this.acceptListener = future;
                this.enableIOEvent(IOEvent.SERVER_ACCEPT);
            }
            return future;
        }
    }

    private SocketChannel doAccept() throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)this.getChannel();
        return serverChannel.accept();
    }

    private void configureAcceptedChannel(SocketChannel acceptedChannel) throws IOException {
        TCPNIOTransport tcpNIOTransport = (TCPNIOTransport)this.transport;
        tcpNIOTransport.configureChannel(acceptedChannel);
    }

    private void registerAcceptedChannel(SocketChannel acceptedChannel, FutureImpl<Connection> listener) throws IOException {
        RegisterAcceptedChannelCompletionHandler handler;
        TCPNIOTransport tcpNIOTransport = (TCPNIOTransport)this.transport;
        TCPNIOConnection connection = tcpNIOTransport.obtainNIOConnection(acceptedChannel);
        RegisterAcceptedChannelCompletionHandler registerAcceptedChannelCompletionHandler = handler = listener == null ? this.defaultCompletionHandler : new RegisterAcceptedChannelCompletionHandler(listener);
        if (this.processor != null) {
            connection.setProcessor(this.processor);
        }
        if (this.processorSelector != null) {
            connection.setProcessorSelector(this.processorSelector);
        }
        tcpNIOTransport.getNIOChannelDistributor().registerChannelAsync(acceptedChannel, 0, connection, handler);
    }

    @Override
    public void preClose() {
        if (this.acceptListener != null) {
            this.acceptListener.failure(new IOException("Connection is closed"));
        }
        try {
            ((TCPNIOTransport)this.transport).unbind(this);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Exception occurred, when unbind connection: " + this, e);
        }
        super.preClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccept() throws IOException {
        if (!this.isStandalone()) {
            SocketChannel acceptedChannel = this.doAccept();
            if (acceptedChannel == null) {
                return;
            }
            this.configureAcceptedChannel(acceptedChannel);
            this.registerAcceptedChannel(acceptedChannel, this.acceptListener);
        } else {
            Object object = this.acceptSync;
            synchronized (object) {
                if (this.acceptListener == null) {
                    this.disableIOEvent(IOEvent.SERVER_ACCEPT);
                    return;
                }
                SocketChannel acceptedChannel = this.doAccept();
                if (acceptedChannel == null) {
                    return;
                }
                this.configureAcceptedChannel(acceptedChannel);
                this.registerAcceptedChannel(acceptedChannel, this.acceptListener);
                this.acceptListener = null;
            }
        }
        TCPNIOServerConnection.notifyProbesAccept(this);
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        ServerSocket socket = ((ServerSocketChannel)this.channel).socket();
        try {
            int socketReadBufferSize = socket.getReceiveBufferSize();
            if (readBufferSize != -1 && readBufferSize > socketReadBufferSize) {
                socket.setReceiveBufferSize(readBufferSize);
            }
            this.readBufferSize = readBufferSize;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error setting read buffer size", e);
        }
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    private static final class EnableReadHandler
    extends EmptyIOEventProcessingHandler {
        private EnableReadHandler() {
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context);
        }

        @Override
        public void onNotRun(Context context) throws IOException {
            this.onComplete(context);
        }

        @Override
        public void onComplete(Context context) throws IOException {
            NIOConnection nioConnection = (NIOConnection)context.getConnection();
            nioConnection.enableIOEvent(IOEvent.READ);
        }
    }

    protected final class RegisterAcceptedChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private final FutureImpl<Connection> listener;

        public RegisterAcceptedChannelCompletionHandler() {
            this(null);
        }

        public RegisterAcceptedChannelCompletionHandler(FutureImpl<Connection> listener) {
            this.listener = listener;
        }

        @Override
        public void completed(RegisterChannelResult result) {
            try {
                TCPNIOTransport nioTransport = (TCPNIOTransport)TCPNIOServerConnection.this.transport;
                nioTransport.selectorRegistrationHandler.completed(result);
                SelectionKeyHandler selectionKeyHandler = nioTransport.getSelectionKeyHandler();
                SelectionKey acceptedConnectionKey = result.getSelectionKey();
                TCPNIOConnection connection = (TCPNIOConnection)selectionKeyHandler.getConnectionForKey(acceptedConnectionKey);
                connection.resetProperties();
                if (this.listener != null) {
                    this.listener.result(connection);
                }
                TCPNIOServerConnection.this.transport.fireIOEvent(IOEvent.ACCEPTED, connection, !TCPNIOServerConnection.this.isStandalone() ? enableInterestProcessingHandler : null);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception happened, when trying to accept the connection", e);
            }
        }
    }
}

