/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test;

import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import jersey.repackaged.com.google.common.collect.Maps;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.spi.TestContainer;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.After;
import org.junit.Before;

public abstract class JerseyTest {
    private static final Logger LOGGER = Logger.getLogger(JerseyTest.class.getName());
    private static Class<? extends TestContainerFactory> defaultTestContainerFactoryClass;
    private final DeploymentContext context;
    private TestContainerFactory testContainerFactory;
    private TestContainer testContainer;
    private final AtomicReference<Client> client = new AtomicReference<Object>(null);
    private final Map<String, String> propertyMap = Maps.newHashMap();
    private final Map<String, String> forcedPropertyMap = Maps.newHashMap();
    private JerseyTestLogHandler logHandler;
    private final Map<Logger, Level> logLevelMap = Maps.newIdentityHashMap();

    public JerseyTest() {
        this.context = this.configureDeployment();
        this.testContainerFactory = this.getTestContainerFactory();
    }

    public JerseyTest(TestContainerFactory testContainerFactory) {
        this.context = this.configureDeployment();
        this.testContainerFactory = testContainerFactory;
    }

    public JerseyTest(Application jaxrsApplication) {
        this.context = DeploymentContext.newInstance(jaxrsApplication);
        this.testContainerFactory = this.getTestContainerFactory();
    }

    TestContainer getTestContainer() {
        return this.testContainer;
    }

    TestContainer setTestContainer(TestContainer testContainer) {
        TestContainer old = this.testContainer;
        this.testContainer = testContainer;
        return old;
    }

    private TestContainer createTestContainer(DeploymentContext context) {
        return this.getTestContainerFactory().create(this.getBaseUri(), context);
    }

    protected final void enable(String featureName) {
        this.propertyMap.put(featureName, Boolean.TRUE.toString());
    }

    protected final void disable(String featureName) {
        this.propertyMap.put(featureName, Boolean.FALSE.toString());
    }

    protected final void forceEnable(String featureName) {
        this.forcedPropertyMap.put(featureName, Boolean.TRUE.toString());
    }

    protected final void forceDisable(String featureName) {
        this.forcedPropertyMap.put(featureName, Boolean.FALSE.toString());
    }

    protected final void set(String propertyName, Object value) {
        this.set(propertyName, value.toString());
    }

    protected final void set(String propertyName, String value) {
        this.propertyMap.put(propertyName, value);
    }

    protected final void forceSet(String propertyName, String value) {
        this.forcedPropertyMap.put(propertyName, value);
    }

    protected final boolean isEnabled(String propertyName) {
        return Boolean.valueOf(this.getProperty(propertyName));
    }

    private String getProperty(String propertyName) {
        if (this.forcedPropertyMap.containsKey(propertyName)) {
            return this.forcedPropertyMap.get(propertyName);
        }
        Properties systemProperties = (Properties)AccessController.doPrivileged(PropertiesHelper.getSystemProperties());
        if (systemProperties.containsKey(propertyName)) {
            return systemProperties.getProperty(propertyName);
        }
        if (this.propertyMap.containsKey(propertyName)) {
            return this.propertyMap.get(propertyName);
        }
        return null;
    }

    private static String getSystemProperty(String propertyName) {
        Properties systemProperties = (Properties)AccessController.doPrivileged(PropertiesHelper.getSystemProperties());
        return systemProperties.getProperty(propertyName);
    }

    protected Application configure() {
        throw new UnsupportedOperationException("The configure method must be implemented by the extending class");
    }

    protected DeploymentContext configureDeployment() {
        return DeploymentContext.builder(this.configure()).build();
    }

    protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
        if (this.testContainerFactory == null) {
            this.testContainerFactory = JerseyTest.getDefaultTestContainerFactory();
        }
        return this.testContainerFactory;
    }

    private static synchronized TestContainerFactory getDefaultTestContainerFactory() {
        if (defaultTestContainerFactoryClass == null) {
            String factoryClassName = JerseyTest.getSystemProperty("jersey.config.test.container.factory");
            if (factoryClassName != null) {
                LOGGER.log(Level.CONFIG, "Loading test container factory '{0}' specified in the '{1}' system property.", new Object[]{factoryClassName, "jersey.config.test.container.factory"});
                defaultTestContainerFactoryClass = JerseyTest.loadFactoryClass(factoryClassName);
            } else {
                TestContainerFactory[] factories = (TestContainerFactory[])ServiceFinder.find(TestContainerFactory.class).toArray();
                if (factories.length > 0) {
                    if (factories.length == 1) {
                        defaultTestContainerFactoryClass = factories[0].getClass();
                        LOGGER.log(Level.CONFIG, "Using the single found TestContainerFactory service provider '{0}'", defaultTestContainerFactoryClass.getName());
                        return factories[0];
                    }
                    for (TestContainerFactory tcf : factories) {
                        if (!"org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory".equals(tcf.getClass().getName())) continue;
                        defaultTestContainerFactoryClass = tcf.getClass();
                        LOGGER.log(Level.CONFIG, "Found multiple TestContainerFactory service providers, using the default found '{0}'", "org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory");
                        return tcf;
                    }
                    defaultTestContainerFactoryClass = factories[0].getClass();
                    LOGGER.log(Level.WARNING, "Found multiple TestContainerFactory service providers, using the first found '{0}'", defaultTestContainerFactoryClass.getName());
                    return factories[0];
                }
                LOGGER.log(Level.CONFIG, "No TestContainerFactory configured, trying to load and instantiate the default implementation '{0}'", "org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory");
                defaultTestContainerFactoryClass = JerseyTest.loadFactoryClass("org.glassfish.jersey.test.grizzly.GrizzlyTestContainerFactory");
            }
        }
        try {
            return defaultTestContainerFactoryClass.newInstance();
        }
        catch (Exception ex) {
            throw new TestContainerException(String.format("Could not instantiate test container factory '%s'", defaultTestContainerFactoryClass.getName()), ex);
        }
    }

    private static Class<? extends TestContainerFactory> loadFactoryClass(String factoryClassName) {
        Class loadedClass = (Class)AccessController.doPrivileged(ReflectionHelper.classForNamePA((String)factoryClassName, null));
        if (loadedClass == null) {
            throw new TestContainerException(String.format("Test container factory class '%s' cannot be loaded", factoryClassName));
        }
        try {
            return loadedClass.asSubclass(TestContainerFactory.class);
        }
        catch (ClassCastException ex) {
            throw new TestContainerException(String.format("Class '%s' does not implement TestContainerFactory SPI.", factoryClassName), ex);
        }
    }

    public final WebTarget target() {
        return this.client().target(this.getTestContainer().getBaseUri());
    }

    public final WebTarget target(String path) {
        return this.target().path(path);
    }

    public final Client client() {
        return this.getClient();
    }

    @Before
    public void setUp() throws Exception {
        if (this.isLogRecordingEnabled()) {
            this.registerLogHandler();
        }
        TestContainer testContainer = this.createTestContainer(this.context);
        this.setTestContainer(testContainer);
        testContainer.start();
        this.setClient(this.getClient(testContainer.getClientConfig()));
    }

    @After
    public void tearDown() throws Exception {
        if (this.isLogRecordingEnabled()) {
            this.unregisterLogHandler();
        }
        try {
            TestContainer oldContainer = this.setTestContainer(null);
            if (oldContainer != null) {
                oldContainer.stop();
            }
        }
        catch (Throwable throwable) {
            JerseyTest.closeIfNotNull(this.setClient(null));
            throw throwable;
        }
        JerseyTest.closeIfNotNull(this.setClient(null));
    }

    protected Client getClient() {
        return this.client.get();
    }

    protected Client setClient(Client client) {
        return this.client.getAndSet(client);
    }

    private Client getClient(ClientConfig clientConfig) {
        if (clientConfig == null) {
            clientConfig = new ClientConfig();
        }
        if (this.isEnabled("jersey.config.test.logging.enable")) {
            clientConfig.register((Object)new LoggingFeature(LOGGER, this.isEnabled("jersey.config.test.logging.dumpEntity") ? LoggingFeature.Verbosity.PAYLOAD_ANY : LoggingFeature.Verbosity.HEADERS_ONLY));
        }
        this.configureClient(clientConfig);
        return ClientBuilder.newClient((Configuration)clientConfig);
    }

    protected void configureClient(ClientConfig config) {
    }

    protected URI getBaseUri() {
        TestContainer container = this.getTestContainer();
        if (container != null) {
            return container.getBaseUri();
        }
        return UriBuilder.fromUri((String)"http://localhost/").port(this.getPort()).build(new Object[0]);
    }

    protected final int getPort() {
        TestContainer container = this.getTestContainer();
        if (container != null) {
            return container.getBaseUri().getPort();
        }
        String value = this.getProperty("jersey.config.test.container.port");
        if (value != null) {
            try {
                int i = Integer.parseInt(value);
                if (i < 0) {
                    throw new NumberFormatException("Value not positive.");
                }
                return i;
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.CONFIG, "Value of jersey.config.test.container.port property is not a valid positive integer [" + value + "]. Reverting to default [" + 9998 + "].", e);
            }
        }
        return 9998;
    }

    protected final List<LogRecord> getLoggedRecords() {
        return this.getLogHandler().getRecords();
    }

    protected final LogRecord getLastLoggedRecord() {
        List<LogRecord> loggedRecords = this.getLoggedRecords();
        return loggedRecords.isEmpty() ? null : loggedRecords.get(loggedRecords.size() - 1);
    }

    private Set<Logger> getRootLoggers() {
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> loggerNames = logManager.getLoggerNames();
        HashSet rootLoggers = Sets.newHashSet();
        while (loggerNames.hasMoreElements()) {
            Logger logger = logManager.getLogger(loggerNames.nextElement());
            if (logger == null) continue;
            while (logger.getParent() != null) {
                logger = logger.getParent();
            }
            rootLoggers.add(logger);
        }
        return rootLoggers;
    }

    private void registerLogHandler() {
        String recordLogLevel = this.getProperty("jersey.config.test.logging.record.level");
        int recordLogLevelInt = Integer.valueOf(recordLogLevel);
        Level level = Level.parse(recordLogLevel);
        this.logLevelMap.clear();
        for (Logger root : this.getRootLoggers()) {
            this.logLevelMap.put(root, root.getLevel());
            if (root.getLevel().intValue() > recordLogLevelInt) {
                root.setLevel(level);
            }
            root.addHandler(this.getLogHandler());
        }
    }

    private void unregisterLogHandler() {
        for (Logger root : this.getRootLoggers()) {
            root.setLevel(this.logLevelMap.get(root));
            root.removeHandler(this.getLogHandler());
        }
        this.logHandler = null;
    }

    private boolean isLogRecordingEnabled() {
        return this.getProperty("jersey.config.test.logging.record.level") != null;
    }

    private JerseyTestLogHandler getLogHandler() {
        if (this.logHandler == null) {
            this.logHandler = new JerseyTestLogHandler();
        }
        return this.logHandler;
    }

    protected int getAsyncTimeoutMultiplier() {
        String property = this.getProperty("jersey.config.test.async.timeout.multiplier");
        Integer multi = 1;
        if (property != null && (multi = Integer.valueOf(property)) <= 0) {
            throw new NumberFormatException("Property jersey.config.test.async.timeout.multiplier must be a number greater than 0.");
        }
        return multi;
    }

    public final void close(Response ... responses) {
        if (responses == null || responses.length == 0) {
            return;
        }
        for (Response response : responses) {
            if (response == null) continue;
            try {
                response.close();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error closing a response.", t);
            }
        }
    }

    public static void closeIfNotNull(Client ... clients) {
        if (clients == null || clients.length == 0) {
            return;
        }
        for (Client c : clients) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error closing a client instance.", t);
            }
        }
    }

    private class JerseyTestLogHandler
    extends Handler {
        private final int logLevel;
        private final List<LogRecord> records;

        private JerseyTestLogHandler() {
            this.logLevel = Integer.parseInt(JerseyTest.this.getProperty("jersey.config.test.logging.record.level"));
            this.records = new ArrayList<LogRecord>();
        }

        @Override
        public void publish(LogRecord record) {
            String loggerName = record.getLoggerName();
            if (record.getLevel().intValue() >= this.logLevel && loggerName.startsWith("org.glassfish.jersey") && !loggerName.startsWith("org.glassfish.jersey.test")) {
                this.records.add(record);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        public List<LogRecord> getRecords() {
            return this.records;
        }
    }
}

