/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class Weld
extends CDI<Object> {
    private final LoadingCache<String, BeanManagerProxy> beanManagers = CacheBuilder.newBuilder().weakValues().build(new ClassNameToBeanManager());
    private final Set<String> subclassNames;

    public Weld() {
        HashSet<String> names = new HashSet<String>();
        for (Class<?> clazz = this.getClass(); clazz != CDI.class; clazz = clazz.getSuperclass()) {
            names.add(clazz.getName());
        }
        this.subclassNames = Collections.unmodifiableSet(names);
    }

    protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
        throw BeanManagerLogger.LOG.unsatisfiedBeanManager(callerClassName);
    }

    protected BeanManagerImpl ambiguousBeanManager(String callerClassName, Set<BeanManagerImpl> managers) {
        throw BeanManagerLogger.LOG.ambiguousBeanManager(callerClassName);
    }

    @Override
    public BeanManagerProxy getBeanManager() {
        ContainerState state = Container.instance().getState();
        if (state.equals((Object)ContainerState.STOPPED) || state.equals((Object)ContainerState.SHUTDOWN)) {
            throw BeanManagerLogger.LOG.beanManagerNotAvailable();
        }
        return this.beanManagers.getUnchecked(this.getCallingClassName());
    }

    protected String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.subclassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        throw BeanManagerLogger.LOG.unableToIdentifyBeanManager();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.getInstance().iterator();
    }

    @Override
    public Object get() {
        return this.getInstance().get();
    }

    @Override
    public Instance<Object> select(Annotation ... qualifiers) {
        return this.getInstance().select(qualifiers);
    }

    @Override
    public <U> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    @Override
    public <U> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.getInstance().select(subtype, qualifiers);
    }

    @Override
    public boolean isUnsatisfied() {
        return this.getInstance().isUnsatisfied();
    }

    @Override
    public boolean isAmbiguous() {
        return this.getInstance().isAmbiguous();
    }

    protected Instance<Object> getInstance() {
        return this.getBeanManager().delegate().instance();
    }

    public String toString() {
        return "Weld";
    }

    public void cleanup() {
        this.beanManagers.invalidateAll();
    }

    @Override
    public void destroy(Object instance) {
        this.getInstance().destroy(instance);
    }

    private class ClassNameToBeanManager
    extends CacheLoader<String, BeanManagerProxy> {
        private ClassNameToBeanManager() {
        }

        @Override
        public BeanManagerProxy load(String callerClassName) {
            return new BeanManagerProxy(this.findBeanManager(callerClassName));
        }

        public BeanManagerImpl findBeanManager(String callerClassName) {
            if (callerClassName == null) {
                throw BeanManagerLogger.LOG.unableToIdentifyBeanManager();
            }
            Container container = Container.instance();
            HashSet<BeanManagerImpl> managers = new HashSet<BeanManagerImpl>();
            for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : container.beanDeploymentArchives().entrySet()) {
                for (String className : entry.getKey().getBeanClasses()) {
                    if (!className.equals(callerClassName)) continue;
                    managers.add(entry.getValue());
                }
            }
            if (managers.size() == 1) {
                return (BeanManagerImpl)managers.iterator().next();
            }
            if (managers.size() == 0) {
                return Weld.this.unsatisfiedBeanManager(callerClassName);
            }
            return Weld.this.ambiguousBeanManager(callerClassName, managers);
        }
    }
}

