/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.Container;
import org.jboss.weld.context.ForwardingContextual;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;

public class SerializableContextualFactory {
    private SerializableContextualFactory() {
    }

    public static <C extends Contextual<I>, I> SerializableContextual<C, I> create(String contextId, C contextual, ContextualStore contextualStore) {
        if (contextual instanceof PassivationCapable) {
            return new PassivationCapableSerializableContextual(contextId, contextual, contextualStore);
        }
        return new DefaultSerializableContextual(contextId, contextual, contextualStore);
    }

    private static class PassivationCapableSerializableContextual<C extends Contextual<I> & PassivationCapable, I>
    extends AbstractSerializableContextual<C, I>
    implements PassivationCapable {
        private static final long serialVersionUID = -2753893863961869301L;

        public PassivationCapableSerializableContextual(String contextId, C contextual, ContextualStore contextualStore) {
            super(contextId, contextual, contextualStore);
        }

        @Override
        public String getId() {
            return ((PassivationCapable)this.get()).getId();
        }
    }

    private static class DefaultSerializableContextual<C extends Contextual<I>, I>
    extends AbstractSerializableContextual<C, I> {
        private static final long serialVersionUID = -5102624795925717767L;

        public DefaultSerializableContextual(String contextId, C contextual, ContextualStore contextualStore) {
            super(contextId, contextual, contextualStore);
        }
    }

    private static abstract class AbstractSerializableContextual<C extends Contextual<I>, I>
    extends ForwardingContextual<I>
    implements SerializableContextual<C, I> {
        private static final long serialVersionUID = 107855630671709443L;
        private C serializable;
        @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="A cache which is lazily loaded")
        private transient C cached;
        private BeanIdentifier id;
        private String contextId;
        private transient ContextualStore cachedContextualStore;

        @Override
        protected Contextual<I> delegate() {
            return this.get();
        }

        public AbstractSerializableContextual(String contextId, C contextual, ContextualStore contextualStore) {
            this.contextId = contextId;
            this.cachedContextualStore = contextualStore;
            if (contextual instanceof Serializable) {
                this.serializable = contextual;
            } else {
                this.id = this.getId(contextual, contextualStore);
            }
            this.cached = contextual;
        }

        protected BeanIdentifier getId(C contextual, ContextualStore contextualStore) {
            return contextualStore.putIfAbsent((Contextual<?>)contextual);
        }

        private ContextualStore getContextualStore() {
            if (this.cachedContextualStore == null) {
                this.cachedContextualStore = Container.instance(this.contextId).services().get(ContextualStore.class);
            }
            return this.cachedContextualStore;
        }

        @Override
        public C get() {
            if (this.cached == null) {
                this.loadContextual();
            }
            return this.cached;
        }

        private void loadContextual() {
            if (this.serializable != null) {
                this.cached = this.serializable;
            } else if (this.id != null) {
                this.cached = this.getContextualStore().getContextual(this.id);
            }
            if (this.cached == null) {
                throw new IllegalStateException("Error restoring serialized contextual with id " + this.id);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof AbstractSerializableContextual) {
                return this.delegate().equals(((AbstractSerializableContextual)obj).get());
            }
            return this.delegate().equals(obj);
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }
    }
}

