/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.servlet.util.Servlets;

public class WebAppBeanDeploymentArchive
implements BeanDeploymentArchive {
    private static final Logger log = Logger.getLogger(WebAppBeanDeploymentArchive.class);
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    public static final String WEB_INF_BEANS_XML = "/WEB-INF/beans.xml";
    public static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private final Set<String> classes;
    private final BeansXml beansXml;
    private final ServiceRegistry services = new SimpleServiceRegistry();

    public WebAppBeanDeploymentArchive(ServletContext servletContext, Bootstrap bootstrap, URLScanner scanner) {
        this.classes = new HashSet<String>();
        HashSet<URL> urls = new HashSet<URL>();
        if (scanner == null) {
            scanner = new URLScanner(Reflections.getClassLoader());
        }
        scanner.scanResources(new String[]{META_INF_BEANS_XML}, this.classes, urls);
        try {
            URL beans = servletContext.getResource(WEB_INF_BEANS_XML);
            if (beans != null) {
                urls.add(beans);
                File webInfClasses = Servlets.getRealFile(servletContext, WEB_INF_CLASSES);
                if (webInfClasses != null) {
                    File[] files = new File[]{webInfClasses};
                    scanner.scanDirectories(files, this.classes, urls);
                } else if (scanner.isURLHandlingSupported()) {
                    URL url = servletContext.getResource(WEB_INF_CLASSES);
                    if (url != null) {
                        scanner.scanURLs(new URL[]{url}, this.classes, urls);
                    }
                } else {
                    WebAppBeanDeploymentArchive.handleResourcePath(WEB_INF_CLASSES, this.classes, servletContext);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error loading resources from servlet context ", e);
        }
        this.beansXml = bootstrap.parse(urls, true);
    }

    @Override
    public Collection<String> getBeanClasses() {
        return this.classes;
    }

    @Override
    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.emptySet();
    }

    @Override
    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    @Override
    public Collection<EjbDescriptor<?>> getEjbs() {
        return Collections.emptySet();
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public String getId() {
        return "flat";
    }

    static void handleResourcePath(String resourcePath, Set<String> classes, ServletContext servletContext) {
        log.debugv("Handling resource path: {0}", (Object)resourcePath);
        Set subpaths = servletContext.getResourcePaths(resourcePath);
        if (subpaths != null && !subpaths.isEmpty()) {
            for (String subpath : subpaths) {
                if (subpath.endsWith(SLASH)) {
                    WebAppBeanDeploymentArchive.handleResourcePath(subpath, classes, servletContext);
                    continue;
                }
                if (!subpath.endsWith(".class")) continue;
                String className = WebAppBeanDeploymentArchive.toClassName(subpath);
                classes.add(className);
                log.debugv("Class discovered: {0}", (Object)className);
            }
        }
    }

    private static String toClassName(String resourcePath) {
        return resourcePath.substring(WEB_INF_CLASSES.length() + 1, resourcePath.lastIndexOf(".class")).replace(SLASH, DOT);
    }
}

