/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.tomcat;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.weld.environment.servlet.util.Reflections;
import org.jboss.weld.environment.tomcat.ForwardingInstanceManager;
import org.jboss.weld.environment.tomcat.WeldInstanceManager;
import org.jboss.weld.manager.api.WeldManager;

public class WeldForwardingInstanceManager
extends ForwardingInstanceManager {
    private static final String NEITHER_FIELD_NOR_SETTER_FOUND_FOR_INSTANCE_MANAGER = "neither field nor setter found for instanceManager";
    private static final String INSTANCE_MANAGER_FIELD_NAME = "instanceManager";
    private final InstanceManager firstProcessor;
    private final InstanceManager secondProcessor;

    public WeldForwardingInstanceManager(InstanceManager originalAnnotationProcessor, InstanceManager weldProcessor) {
        this.firstProcessor = originalAnnotationProcessor;
        this.secondProcessor = weldProcessor;
    }

    @Override
    protected InstanceManager delegate() {
        return this.firstProcessor;
    }

    @Override
    public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        super.destroyInstance(o);
        this.secondProcessor.destroyInstance(o);
    }

    @Override
    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
        super.newInstance(o);
        this.secondProcessor.newInstance(o);
    }

    @Override
    public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Object a = super.newInstance(fqcn, classLoader);
        this.secondProcessor.newInstance(a);
        return a;
    }

    @Override
    public Object newInstance(String fqcn) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Object a = super.newInstance(fqcn);
        this.secondProcessor.newInstance(a);
        return a;
    }

    @Override
    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        Object a = super.newInstance(clazz);
        this.secondProcessor.newInstance(a);
        return a;
    }

    public static void replaceInstanceManager(ServletContext context, WeldManager manager) {
        StandardContext stdContext = WeldForwardingInstanceManager.getStandardContext(context);
        WeldForwardingInstanceManager.setInstanceManager(stdContext, WeldForwardingInstanceManager.createInstance(manager, stdContext));
    }

    private static WeldForwardingInstanceManager createInstance(WeldManager manager, StandardContext stdContext) {
        try {
            WeldInstanceManager weldProcessor = new WeldInstanceManager(manager);
            return new WeldForwardingInstanceManager(WeldForwardingInstanceManager.getInstanceManager(stdContext), weldProcessor);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create WeldForwardingAnnotationProcessor", e);
        }
    }

    private static StandardContext getStandardContext(ServletContext context) {
        try {
            ApplicationContext appContext = (ApplicationContext)WeldForwardingInstanceManager.getContextFieldValue((ApplicationContextFacade)context, ApplicationContextFacade.class);
            return (StandardContext)WeldForwardingInstanceManager.getContextFieldValue(appContext, ApplicationContext.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get StandardContext from ServletContext", e);
        }
    }

    private static <E> Object getContextFieldValue(E obj, Class<E> clazz) throws NoSuchFieldException, IllegalAccessException {
        Field f = clazz.getDeclaredField("context");
        f.setAccessible(true);
        return f.get(obj);
    }

    public static void restoreInstanceManager(ServletContext context) {
        StandardContext stdContext = WeldForwardingInstanceManager.getStandardContext(context);
        InstanceManager im = WeldForwardingInstanceManager.getInstanceManager(stdContext);
        if (im instanceof WeldForwardingInstanceManager) {
            WeldForwardingInstanceManager.setInstanceManager(stdContext, ((WeldForwardingInstanceManager)im).firstProcessor);
        }
    }

    private static InstanceManager getInstanceManager(StandardContext stdContext) {
        Method method = Reflections.findDeclaredMethod(stdContext.getClass(), "getInstanceManager", new Class[0]);
        if (method != null) {
            return Reflections.invokeMethod(method, InstanceManager.class, stdContext, new Object[0]);
        }
        Field field = Reflections.findDeclaredField(stdContext.getClass(), INSTANCE_MANAGER_FIELD_NAME);
        if (field != null) {
            return Reflections.getFieldValue(field, stdContext, InstanceManager.class);
        }
        throw new RuntimeException(NEITHER_FIELD_NOR_SETTER_FOUND_FOR_INSTANCE_MANAGER);
    }

    private static void setInstanceManager(StandardContext stdContext, InstanceManager instanceManager) {
        Method method = Reflections.findDeclaredMethod(stdContext.getClass(), "setInstanceManager", InstanceManager.class);
        if (method != null) {
            Reflections.invokeMethod(method, Void.TYPE, stdContext, instanceManager);
            return;
        }
        Field field = Reflections.findDeclaredField(stdContext.getClass(), INSTANCE_MANAGER_FIELD_NAME);
        if (field != null) {
            Reflections.setFieldValue(field, stdContext, instanceManager);
            return;
        }
        throw new RuntimeException(NEITHER_FIELD_NOR_SETTER_FOUND_FOR_INSTANCE_MANAGER);
    }
}

