/*
 * Decompiled with CFR 0.152.
 */
package org.jglue.cdiunit;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.naming.InitialContext;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jglue.cdiunit.internal.WeldTestUrlDeployment;
import org.junit.Test;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class CdiRunner
extends BlockJUnit4ClassRunner {
    private Class<?> clazz;
    private Weld weld;
    private WeldContainer container;
    private Throwable startupException;

    public CdiRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.clazz = clazz;
    }

    protected Object createTest() throws Exception {
        try {
            Weld.class.getDeclaredMethod("createDeployment", ResourceLoader.class, Bootstrap.class);
            this.weld = new Weld(){

                protected Deployment createDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap) {
                    try {
                        return new WeldTestUrlDeployment(resourceLoader, bootstrap, CdiRunner.this.clazz);
                    }
                    catch (IOException e) {
                        CdiRunner.this.startupException = e;
                        throw new RuntimeException(e);
                    }
                }
            };
            try {
                this.container = this.weld.initialize();
            }
            catch (Throwable e) {
                if (this.startupException == null) {
                    this.startupException = e;
                }
            }
        }
        catch (NoSuchMethodException e) {
            this.startupException = new Exception("Weld 1.0.1 is not supported, please use weld 1.1.0 or newer. If you are using maven add\n<dependency>\n  <groupId>org.jboss.weld.se</groupId>\n  <artifactId>weld-se-core</artifactId>\n  <version>1.1.0.Final</version>\n</dependency>\n to your pom.");
        }
        catch (ClassFormatError e) {
            this.startupException = new Exception("There were class format errors. This is often caused by API only jars on the classpath. If you are using maven then you need to place these after the CDI unit dependency as 'provided' scope is still available during testing.", e);
        }
        catch (Throwable e) {
            this.startupException = new Exception("Unable to start weld", e);
        }
        return this.createTest(this.clazz);
    }

    private <T> T createTest(Class<T> testClass) {
        Object t = this.container.instance().select(testClass, new Annotation[0]).get();
        return (T)t;
    }

    protected Statement methodBlock(final FrameworkMethod method) {
        final Statement defaultStatement = super.methodBlock(method);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (CdiRunner.this.startupException != null) {
                    if (((Test)method.getAnnotation(Test.class)).expected() == CdiRunner.this.startupException.getClass()) {
                        return;
                    }
                    throw CdiRunner.this.startupException;
                }
                System.setProperty("java.naming.factory.initial", "org.jglue.cdiunit.internal.CdiUnitContextFactory");
                InitialContext initialContext = new InitialContext();
                initialContext.bind("java:comp/BeanManager", (Object)CdiRunner.this.container.getBeanManager());
                try {
                    defaultStatement.evaluate();
                }
                finally {
                    initialContext.close();
                    CdiRunner.this.weld.shutdown();
                }
            }
        };
    }
}

