/*
 * Decompiled with CFR 0.152.
 */
package org.jglue.cdiunit;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.servlet.HttpContextLifecycle;
import org.jboss.weld.servlet.spi.HttpContextActivationFilter;
import org.jboss.weld.servlet.spi.helpers.AcceptingHttpContextActivationFilter;
import org.jglue.cdiunit.internal.LifecycleAwareRequest;

@ApplicationScoped
public class ContextController {
    private HttpServletRequest currentRequest;
    @Inject
    private BeanManager beanManager;
    private HttpContextLifecycle lifecycle;
    private HttpSession currentSession;

    @PostConstruct
    public void setup() {
        try {
            this.lifecycle = new HttpContextLifecycle(BeanManagerProxy.unwrap((BeanManager)this.beanManager), (HttpContextActivationFilter)AcceptingHttpContextActivationFilter.INSTANCE, true, true);
        }
        catch (NoSuchMethodError e) {
            try {
                this.lifecycle = (HttpContextLifecycle)HttpContextLifecycle.class.getConstructor(BeanManager.class, AcceptingHttpContextActivationFilter.class).newInstance(BeanManagerProxy.unwrap((BeanManager)this.beanManager), AcceptingHttpContextActivationFilter.INSTANCE);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        this.lifecycle.setConversationActivationEnabled(true);
    }

    public void openRequest(HttpServletRequest request) {
        if (this.currentRequest != null) {
            throw new RuntimeException("A request is already open");
        }
        this.currentRequest = new LifecycleAwareRequest(this.lifecycle, request, this.currentSession);
        this.lifecycle.requestInitialized(this.currentRequest, null);
    }

    public void closeRequest() {
        this.lifecycle.requestDestroyed(this.currentRequest);
        this.currentSession = this.currentRequest.getSession(false);
        this.currentRequest = null;
    }

    public void closeSession() {
        if (this.currentRequest != null) {
            this.currentSession = this.currentRequest.getSession(false);
        }
        if (this.currentSession != null) {
            this.lifecycle.sessionDestroyed(this.currentSession);
            this.currentSession = null;
        }
    }
}

