/*
 * Decompiled with CFR 0.152.
 */
package org.jglue.cdiunit.internal;

import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.servlet.http.HttpServletRequest;
import org.jglue.cdiunit.ContextController;
import org.jglue.cdiunit.InRequestScope;
import org.jglue.cdiunit.internal.CdiUnitRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@InRequestScope
public class InRequestInterceptor {
    private static Logger log = LoggerFactory.getLogger(InRequestInterceptor.class);
    @Inject
    private ContextController contextController;
    @Inject
    @CdiUnitRequest
    private Provider<Object> requestProvider;
    @Inject
    private Provider<HttpServletRequest> cdi1Provider;

    @AroundInvoke
    public Object around(InvocationContext ctx) throws Exception {
        try {
            HttpServletRequest httpServletRequest;
            try {
                httpServletRequest = (HttpServletRequest)this.requestProvider.get();
            }
            catch (UnsatisfiedResolutionException e) {
                httpServletRequest = (HttpServletRequest)this.cdi1Provider.get();
            }
            this.contextController.openRequest(httpServletRequest);
            Object object = ctx.proceed();
            return object;
        }
        catch (Exception e) {
            log.error("Failed to open request context. This can occur is you are using cal10n-0.7.4, see http://jira.qos.ch/browse/CAL-29", (Throwable)e);
            throw e;
        }
        finally {
            this.contextController.closeRequest();
        }
    }
}

