/*
 * Decompiled with CFR 0.152.
 */
package org.jglue.cdiunit.internal;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.interceptor.Interceptor;
import javax.servlet.http.HttpServletRequest;
import org.easymock.Mock;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.bootstrap.spi.Scanning;
import org.jboss.weld.environment.se.WeldSEBeanRegistrant;
import org.jboss.weld.environment.se.discovery.AbstractWeldSEDeployment;
import org.jboss.weld.environment.se.discovery.ImmutableBeanDeploymentArchive;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jglue.cdiunit.ActivatedAlternatives;
import org.jglue.cdiunit.AdditionalClasses;
import org.jglue.cdiunit.ProducesAlternative;
import org.jglue.cdiunit.internal.EasyMockExtension;
import org.jglue.cdiunit.internal.HttpObjectsExtension;
import org.jglue.cdiunit.internal.InConversationInterceptor;
import org.jglue.cdiunit.internal.InRequestInterceptor;
import org.jglue.cdiunit.internal.InSessionInterceptor;
import org.jglue.cdiunit.internal.MockitoExtension;
import org.jglue.cdiunit.internal.TestScopeExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldTestUrlDeployment
extends AbstractWeldSEDeployment {
    private final BeanDeploymentArchive beanDeploymentArchive;
    private Collection<Metadata<Extension>> extensions = new ArrayList<Metadata<Extension>>();
    private static Logger log = LoggerFactory.getLogger(WeldTestUrlDeployment.class);
    private Set<URL> cdiClasspathEntries = new HashSet<URL>();

    public WeldTestUrlDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap, Class<?> testClass) throws IOException {
        super(bootstrap);
        BeansXmlImpl beansXml;
        this.populateCdiClasspathSet();
        try {
            beansXml = new BeansXmlImpl(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), Scanning.EMPTY_SCANNING, new URL("file:cdi-unit"), BeanDiscoveryMode.ALL, "cdi-unit");
        }
        catch (NoClassDefFoundError e) {
            try {
                beansXml = (BeansXml)BeansXmlImpl.class.getConstructors()[0].newInstance(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), Scanning.EMPTY_SCANNING);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        LinkedHashSet<String> discoveredClasses = new LinkedHashSet<String>();
        HashSet<String> alternatives = new HashSet<String>();
        discoveredClasses.add(testClass.getName());
        LinkedHashSet classesToProcess = new LinkedHashSet();
        HashSet<Class> classesProcessed = new HashSet<Class>();
        Set<Class<?>> classesToIgnore = this.findMockedClassesOfTest(testClass);
        classesToProcess.add(testClass);
        this.extensions.add((Metadata<Extension>)new MetadataImpl((Object)new TestScopeExtension(testClass), TestScopeExtension.class.getName()));
        try {
            HttpServletRequest.class.getName();
            this.extensions.add((Metadata<Extension>)new MetadataImpl((Object)new HttpObjectsExtension(), HttpObjectsExtension.class.getName()));
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            Class.forName("javax.servlet.http.HttpServletRequest");
            classesToProcess.add(InRequestInterceptor.class);
            classesToProcess.add(InSessionInterceptor.class);
            classesToProcess.add(InConversationInterceptor.class);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        while (!classesToProcess.isEmpty()) {
            Class c = (Class)classesToProcess.iterator().next();
            if (!(!this.isCdiClass(c) && !Extension.class.isAssignableFrom(c) || classesProcessed.contains(c) || c.isPrimitive() || classesToIgnore.contains(c))) {
                Class superClass;
                ActivatedAlternatives alternativeClasses;
                AdditionalClasses additionalClasses;
                classesProcessed.add(c);
                discoveredClasses.add(c.getName());
                if (Extension.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                    try {
                        this.extensions.add((Metadata<Extension>)new MetadataImpl((Object)((Extension)c.newInstance()), c.getName()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (c.isAnnotationPresent(Interceptor.class)) {
                    beansXml.getEnabledInterceptors().add(new MetadataImpl((Object)c.getName(), c.getName()));
                }
                if (this.isAlternativeStereotype(c)) {
                    beansXml.getEnabledAlternativeStereotypes().add(new MetadataImpl((Object)c.getName(), c.getName()));
                }
                if ((additionalClasses = c.getAnnotation(AdditionalClasses.class)) != null) {
                    for (Class<?> supportClass : additionalClasses.value()) {
                        classesToProcess.add(supportClass);
                    }
                    for (String lateBound : additionalClasses.late()) {
                        try {
                            Class<?> clazz = Class.forName(lateBound);
                            classesToProcess.add(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                if ((alternativeClasses = c.getAnnotation(ActivatedAlternatives.class)) != null) {
                    for (Class<?> alternativeClass : alternativeClasses.value()) {
                        classesToProcess.add(alternativeClass);
                        if (this.isAlternativeStereotype(alternativeClass)) continue;
                        alternatives.add(alternativeClass.getName());
                    }
                }
                if ((superClass = c.getSuperclass()) != null && superClass != Object.class) {
                    classesToProcess.add(superClass);
                }
                for (Field field : c.getDeclaredFields()) {
                    Type type;
                    if (field.isAnnotationPresent(Inject.class) || field.isAnnotationPresent(Produces.class)) {
                        type = field.getType();
                        classesToProcess.add((Class<?>)type);
                    }
                    if (!field.getType().equals(Provider.class)) continue;
                    type = (ParameterizedType)field.getGenericType();
                    classesToProcess.add((Class)type.getActualTypeArguments()[0]);
                }
                for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                    if (!accessibleObject.isAnnotationPresent(Inject.class) && !accessibleObject.isAnnotationPresent(Produces.class)) continue;
                    for (Class<?> param : ((Method)accessibleObject).getParameterTypes()) {
                        classesToProcess.add(param);
                    }
                }
            }
            classesToProcess.remove(c);
        }
        beansXml.getEnabledAlternativeStereotypes().add(new MetadataImpl((Object)ProducesAlternative.class.getName(), ProducesAlternative.class.getName()));
        for (String alternative : alternatives) {
            beansXml.getEnabledAlternativeClasses().add(new MetadataImpl((Object)alternative, alternative));
        }
        try {
            Class.forName("org.mockito.Mock");
            this.extensions.add((Metadata<Extension>)new MetadataImpl((Object)new MockitoExtension(), MockitoExtension.class.getName()));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            Class.forName("org.easymock.EasyMockRunner");
            this.extensions.add((Metadata<Extension>)new MetadataImpl((Object)new EasyMockExtension(), EasyMockExtension.class.getName()));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        this.extensions.add((Metadata<Extension>)new MetadataImpl((Object)new WeldSEBeanRegistrant(), WeldSEBeanRegistrant.class.getName()));
        this.beanDeploymentArchive = new ImmutableBeanDeploymentArchive("cdi-unit" + UUID.randomUUID(), discoveredClasses, (BeansXml)beansXml);
        this.beanDeploymentArchive.getServices().add(ResourceLoader.class, (Service)resourceLoader);
        log.debug("CDI-Unit discovered:");
        for (String clazz : discoveredClasses) {
            if (clazz.startsWith("org.jglue.cdiunit.internal.")) continue;
            log.debug(clazz);
        }
    }

    private Set<Class<?>> findMockedClassesOfTest(Class<?> testClass) {
        Class<?> type;
        HashSet mockedClasses = new HashSet();
        try {
            for (Field field : testClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(org.mockito.Mock.class)) continue;
                type = field.getType();
                mockedClasses.add(type);
            }
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        try {
            for (Field field : testClass.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Mock.class)) continue;
                type = field.getType();
                mockedClasses.add(type);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return mockedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCdiClasspathSet() throws IOException {
        String classpath;
        ClassLoader classLoader = WeldTestUrlDeployment.class.getClassLoader();
        ArrayList<URL> entries = new ArrayList<URL>(Arrays.asList(((URLClassLoader)classLoader).getURLs()));
        JarInputStream firstEntry = new JarInputStream(((URL)entries.get(0)).openStream());
        Manifest manifest = firstEntry.getManifest();
        if (manifest != null && (classpath = (String)manifest.getMainAttributes().get(Attributes.Name.CLASS_PATH)) != null) {
            String[] manifestEntries;
            for (String entry : manifestEntries = classpath.split(" ?file:")) {
                if (entry.length() <= 0) continue;
                entries.add(new URL("file:" + entry));
            }
        }
        firstEntry.close();
        for (URL url : entries) {
            boolean gradleClasses;
            URLClassLoader cl = new URLClassLoader(new URL[]{url}, null);
            if (url.getFile().endsWith("/classes/")) {
                URL webInfBeans = new URL(url, "../../src/main/webapp/WEB-INF/beans.xml");
                try {
                    webInfBeans.openConnection();
                    this.cdiClasspathEntries.add(url);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            URL resource = cl.getResource("META-INF/beans.xml");
            boolean mavenClasses = url.getFile().endsWith("/test-classes/");
            boolean bl = gradleClasses = url.getFile().endsWith("/classes/test/") || url.getFile().endsWith("/classes/main/");
            if (resource == null && !mavenClasses && !gradleClasses) continue;
            this.cdiClasspathEntries.add(url);
        }
    }

    private boolean isCdiClass(Class<?> c) {
        if (c.getProtectionDomain().getCodeSource() == null) {
            return false;
        }
        URL location = c.getProtectionDomain().getCodeSource().getLocation();
        boolean isCdi = this.cdiClasspathEntries.contains(location);
        return isCdi;
    }

    private boolean isAlternativeStereotype(Class<?> c) {
        return c.isAnnotationPresent(Stereotype.class) && c.isAnnotationPresent(Alternative.class);
    }

    public Iterable<Metadata<Extension>> getExtensions() {
        return this.extensions;
    }

    public List<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.singletonList(this.beanDeploymentArchive);
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        return this.beanDeploymentArchive;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        return this.beanDeploymentArchive;
    }
}

