/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.MapReduceCommand;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.MapreduceResults;
import org.mongodb.morphia.MapreduceType;
import org.mongodb.morphia.aggregation.AggregationPipeline;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryFactory;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public interface Datastore {
    public AggregationPipeline createAggregation(Class var1);

    public <T> Query<T> createQuery(Class<T> var1);

    public <T> UpdateOperations<T> createUpdateOperations(Class<T> var1);

    public <T, V> WriteResult delete(Class<T> var1, V var2);

    public <T, V> WriteResult delete(Class<T> var1, Iterable<V> var2);

    public <T> WriteResult delete(Query<T> var1);

    public <T> WriteResult delete(Query<T> var1, WriteConcern var2);

    public <T> WriteResult delete(T var1);

    public <T> WriteResult delete(T var1, WriteConcern var2);

    public void ensureCaps();

    public <T> void ensureIndex(Class<T> var1, String var2);

    public <T> void ensureIndex(Class<T> var1, String var2, String var3, boolean var4, boolean var5);

    public void ensureIndexes();

    public void ensureIndexes(boolean var1);

    public <T> void ensureIndexes(Class<T> var1);

    public <T> void ensureIndexes(Class<T> var1, boolean var2);

    public Key<?> exists(Object var1);

    public <T> Query<T> find(Class<T> var1);

    public <T, V> Query<T> find(Class<T> var1, String var2, V var3);

    public <T, V> Query<T> find(Class<T> var1, String var2, V var3, int var4, int var5);

    public <T> T findAndDelete(Query<T> var1);

    public <T> T findAndModify(Query<T> var1, UpdateOperations<T> var2);

    public <T> T findAndModify(Query<T> var1, UpdateOperations<T> var2, boolean var3);

    public <T> T findAndModify(Query<T> var1, UpdateOperations<T> var2, boolean var3, boolean var4);

    public <T, V> Query<T> get(Class<T> var1, Iterable<V> var2);

    public <T, V> T get(Class<T> var1, V var2);

    public <T> T get(T var1);

    public <T> T getByKey(Class<T> var1, Key<T> var2);

    public <T> List<T> getByKeys(Class<T> var1, Iterable<Key<T>> var2);

    public <T> List<T> getByKeys(Iterable<Key<T>> var1);

    public DBCollection getCollection(Class<?> var1);

    public <T> long getCount(T var1);

    public <T> long getCount(Class<T> var1);

    public <T> long getCount(Query<T> var1);

    public DB getDB();

    public WriteConcern getDefaultWriteConcern();

    public void setDefaultWriteConcern(WriteConcern var1);

    public <T> Key<T> getKey(T var1);

    public MongoClient getMongo();

    public QueryFactory getQueryFactory();

    public void setQueryFactory(QueryFactory var1);

    public <T> MapreduceResults<T> mapReduce(MapreduceType var1, Query var2, String var3, String var4, String var5, Map<String, Object> var6, Class<T> var7);

    public <T> MapreduceResults<T> mapReduce(MapreduceType var1, Query var2, Class<T> var3, MapReduceCommand var4);

    public <T> Key<T> merge(T var1);

    public <T> Key<T> merge(T var1, WriteConcern var2);

    public <T> Query<T> queryByExample(T var1);

    public <T> Iterable<Key<T>> save(Iterable<T> var1);

    public <T> Iterable<Key<T>> save(Iterable<T> var1, WriteConcern var2);

    public <T> Iterable<Key<T>> save(T ... var1);

    public <T> Key<T> save(T var1);

    public <T> Key<T> save(T var1, WriteConcern var2);

    public <T> UpdateResults update(T var1, UpdateOperations<T> var2);

    public <T> UpdateResults update(Key<T> var1, UpdateOperations<T> var2);

    public <T> UpdateResults update(Query<T> var1, UpdateOperations<T> var2);

    public <T> UpdateResults update(Query<T> var1, UpdateOperations<T> var2, boolean var3);

    public <T> UpdateResults update(Query<T> var1, UpdateOperations<T> var2, boolean var3, WriteConcern var4);

    public <T> UpdateResults updateFirst(Query<T> var1, UpdateOperations<T> var2);

    public <T> UpdateResults updateFirst(Query<T> var1, UpdateOperations<T> var2, boolean var3);

    public <T> UpdateResults updateFirst(Query<T> var1, UpdateOperations<T> var2, boolean var3, WriteConcern var4);

    public <T> UpdateResults updateFirst(Query<T> var1, T var2, boolean var3);
}

