/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.BulkWriteOperation;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.MapReduceCommand;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.AdvancedDatastore;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.MapreduceResults;
import org.mongodb.morphia.MapreduceType;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.aggregation.AggregationPipeline;
import org.mongodb.morphia.aggregation.AggregationPipelineImpl;
import org.mongodb.morphia.annotations.CappedAt;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.annotations.Field;
import org.mongodb.morphia.annotations.Index;
import org.mongodb.morphia.annotations.IndexOptions;
import org.mongodb.morphia.annotations.Indexed;
import org.mongodb.morphia.annotations.Indexes;
import org.mongodb.morphia.annotations.NotSaved;
import org.mongodb.morphia.annotations.PostPersist;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.annotations.Text;
import org.mongodb.morphia.annotations.Transient;
import org.mongodb.morphia.annotations.Version;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.mapping.lazy.proxy.ProxyHelper;
import org.mongodb.morphia.query.DefaultQueryFactory;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryException;
import org.mongodb.morphia.query.QueryFactory;
import org.mongodb.morphia.query.QueryImpl;
import org.mongodb.morphia.query.UpdateException;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateOpsImpl;
import org.mongodb.morphia.query.UpdateResults;
import org.mongodb.morphia.utils.Assert;
import org.mongodb.morphia.utils.IndexType;
import org.mongodb.morphia.utils.ReflectionUtils;

public class DatastoreImpl
implements AdvancedDatastore {
    private static final Logger LOG = MorphiaLoggerFactory.get(DatastoreImpl.class);
    private final Morphia morphia;
    private final MongoClient mongoClient;
    private final DB db;
    private Mapper mapper;
    private WriteConcern defConcern = WriteConcern.ACKNOWLEDGED;
    private DBDecoderFactory decoderFactory;
    private volatile QueryFactory queryFactory = new DefaultQueryFactory();

    public DatastoreImpl(Morphia morphia, MongoClient mongoClient, String dbName) {
        this(morphia, morphia.getMapper(), mongoClient, dbName);
    }

    public DatastoreImpl(Morphia morphia, Mapper mapper, MongoClient mongoClient, String dbName) {
        this.morphia = morphia;
        this.mapper = mapper;
        this.mongoClient = mongoClient;
        this.db = mongoClient.getDB(dbName);
    }

    public DatastoreImpl copy(String database) {
        return new DatastoreImpl(this.morphia, this.mapper, this.mongoClient, database);
    }

    @Override
    public AggregationPipeline createAggregation(Class source) {
        return new AggregationPipelineImpl(this, source);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> collection) {
        return this.newQuery(collection, this.getCollection((Class)collection));
    }

    @Override
    public <T> UpdateOperations<T> createUpdateOperations(Class<T> clazz) {
        return new UpdateOpsImpl<T>(clazz, this.getMapper());
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, V id) {
        return this.delete(clazz, id, this.getWriteConcern(clazz));
    }

    @Override
    public <T, V> WriteResult delete(Class<T> clazz, Iterable<V> ids) {
        Query<T> q = this.find(clazz).filter("_id in", ids);
        return this.delete((T)q);
    }

    @Override
    public <T> WriteResult delete(Query<T> query) {
        return this.delete((T)query, this.getWriteConcern(query.getEntityClass()));
    }

    @Override
    public <T> WriteResult delete(Query<T> query, WriteConcern wc) {
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        if (query.getSortObject() != null || query.getOffset() != 0 || query.getLimit() > 0) {
            throw new QueryException("Delete does not allow sort/offset/limit query options.");
        }
        DBObject queryObject = query.getQueryObject();
        WriteResult wr = queryObject != null ? (wc == null ? dbColl.remove(queryObject) : dbColl.remove(queryObject, wc)) : (wc == null ? dbColl.remove((DBObject)new BasicDBObject()) : dbColl.remove((DBObject)new BasicDBObject(), wc));
        return wr;
    }

    @Override
    public <T> WriteResult delete(T entity) {
        return this.delete(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> WriteResult delete(T entity, WriteConcern wc) {
        T wrapped = ProxyHelper.unwrap(entity);
        if (wrapped instanceof Class) {
            throw new MappingException("Did you mean to delete all documents? -- delete(ds.createQuery(???.class))");
        }
        try {
            Object id = this.mapper.getId(wrapped);
            return this.delete(wrapped.getClass(), id, wc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void ensureCaps() {
        for (MappedClass mc : this.mapper.getMappedClasses()) {
            DB database;
            if (mc.getEntityAnnotation() == null || mc.getEntityAnnotation().cap().value() <= 0L) continue;
            CappedAt cap = mc.getEntityAnnotation().cap();
            String collName = this.mapper.getCollectionName(mc.getClazz());
            BasicDBObjectBuilder dbCapOpts = BasicDBObjectBuilder.start((String)"capped", (Object)true);
            if (cap.value() > 0L) {
                dbCapOpts.add("size", (Object)cap.value());
            }
            if (cap.count() > 0L) {
                dbCapOpts.add("max", (Object)cap.count());
            }
            if ((database = this.getDB()).getCollectionNames().contains(collName)) {
                CommandResult dbResult = database.command(BasicDBObjectBuilder.start((String)"collstats", (Object)collName).get());
                if (dbResult.containsField("capped")) {
                    LOG.debug("DBCollection already exists and is capped already; doing nothing. " + dbResult);
                    continue;
                }
                LOG.warning("DBCollection already exists with same name(" + collName + ") and is not capped; not creating capped version!");
                continue;
            }
            this.getDB().createCollection(collName, dbCapOpts.get());
            LOG.debug("Created capped DBCollection (" + collName + ") with opts " + dbCapOpts);
        }
    }

    @Override
    public <T> void ensureIndex(Class<T> type, String fields) {
        this.ensureIndex(type, null, fields, false, false);
    }

    @Override
    public <T> void ensureIndex(Class<T> clazz, String name, String fields, boolean unique, boolean dropDupsOnCreate) {
        this.ensureIndex(clazz, name, QueryImpl.parseFieldsString(fields, clazz, this.mapper, true, Collections.<MappedClass>emptyList(), Collections.<MappedField>emptyList()), unique, dropDupsOnCreate, false, false, -1);
    }

    @Override
    public void ensureIndexes() {
        this.ensureIndexes(false);
    }

    @Override
    public void ensureIndexes(boolean background) {
        for (MappedClass mc : this.mapper.getMappedClasses()) {
            this.ensureIndexes(mc, background);
        }
    }

    @Override
    public <T> void ensureIndexes(Class<T> clazz) {
        this.ensureIndexes(clazz, false);
    }

    @Override
    public <T> void ensureIndexes(Class<T> clazz, boolean background) {
        MappedClass mc = this.mapper.getMappedClass(clazz);
        this.ensureIndexes(mc, background);
    }

    @Override
    public Key<?> exists(Object entityOrKey) {
        Query<?> query = this.buildExistsQuery(entityOrKey);
        return query.getKey();
    }

    @Override
    public <T> Query<T> find(Class<T> clazz) {
        return this.createQuery(clazz);
    }

    @Override
    public <T, V> Query<T> find(Class<T> clazz, String property, V value) {
        Query<T> query = this.createQuery(clazz);
        return query.filter(property, value);
    }

    @Override
    public <T, V> Query<T> find(Class<T> clazz, String property, V value, int offset, int size) {
        Query<T> query = this.createQuery(clazz);
        query.offset(offset);
        query.limit(size);
        return query.filter(property, value);
    }

    @Override
    public <T> T findAndDelete(Query<T> query) {
        DBObject result;
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing findAndModify(" + dbColl.getName() + ") with delete ...");
        }
        if ((result = dbColl.findAndModify(query.getQueryObject(), query.getFieldsObject(), query.getSortObject(), true, null, false, false)) != null) {
            return this.mapper.fromDBObject(this, query.getEntityClass(), result, this.createCache());
        }
        return null;
    }

    @Override
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations) {
        return this.findAndModify(query, operations, false);
    }

    @Override
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations, boolean oldVersion) {
        return this.findAndModify(query, operations, oldVersion, false);
    }

    @Override
    public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations, boolean oldVersion, boolean createIfMissing) {
        DBObject res;
        block5: {
            DBCollection dbColl = query.getCollection();
            if (dbColl == null) {
                dbColl = this.getCollection((Class)query.getEntityClass());
            }
            if (LOG.isTraceEnabled()) {
                LOG.info("Executing findAndModify(" + dbColl.getName() + ") with update ");
            }
            res = null;
            try {
                res = dbColl.findAndModify(query.getQueryObject(), query.getFieldsObject(), query.getSortObject(), false, ((UpdateOpsImpl)operations).getOps(), !oldVersion, createIfMissing);
            }
            catch (MongoException e) {
                if (e.getMessage() != null && e.getMessage().contains("matching")) break block5;
                throw e;
            }
        }
        if (res == null) {
            return null;
        }
        return this.mapper.fromDBObject(this, query.getEntityClass(), res, this.createCache());
    }

    @Override
    public <T, V> Query<T> get(Class<T> clazz, Iterable<V> ids) {
        return this.find(clazz).disableValidation().filter("_id in", ids).enableValidation();
    }

    @Override
    public <T, V> T get(Class<T> clazz, V id) {
        return this.find(this.getCollection((Class)clazz).getName(), clazz, "_id", id, 0, 1, true).get();
    }

    @Override
    public <T> T get(T entity) {
        T unwrapped = ProxyHelper.unwrap(entity);
        Object id = this.mapper.getId(unwrapped);
        if (id == null) {
            throw new MappingException("Could not get id for " + unwrapped.getClass().getName());
        }
        return (T)this.get(unwrapped.getClass(), id);
    }

    @Override
    public <T> T getByKey(Class<T> clazz, Key<T> key) {
        String keyCollection;
        String collectionName = this.mapper.getCollectionName(clazz);
        if (!collectionName.equals(keyCollection = this.mapper.updateCollection(key))) {
            throw new RuntimeException("collection names don't match for key and class: " + collectionName + " != " + keyCollection);
        }
        return this.get(clazz, key.getId());
    }

    @Override
    public <T> List<T> getByKeys(Class<T> clazz, Iterable<Key<T>> keys) {
        HashMap<String, ArrayList<Key<T>>> kindMap = new HashMap<String, ArrayList<Key<T>>>();
        ArrayList entities = new ArrayList();
        for (Key<T> key : keys) {
            this.mapper.updateCollection(key);
            if (kindMap.containsKey(key.getCollection())) {
                ((List)kindMap.get(key.getCollection())).add(key);
                continue;
            }
            kindMap.put(key.getCollection(), new ArrayList<Key<T>>(Collections.singletonList(key)));
        }
        for (Map.Entry entry : kindMap.entrySet()) {
            List kindKeys = (List)entry.getValue();
            ArrayList<Object> objIds = new ArrayList<Object>();
            for (Key key : kindKeys) {
                objIds.add(key.getId());
            }
            List kindResults = this.find((String)entry.getKey(), null).disableValidation().filter("_id in", objIds).asList();
            entities.addAll(kindResults);
        }
        return entities;
    }

    @Override
    public <T> List<T> getByKeys(Iterable<Key<T>> keys) {
        return this.getByKeys(null, keys);
    }

    public DBCollection getCollection(Class clazz) {
        String collName = this.mapper.getCollectionName(clazz);
        return this.getDB().getCollection(collName);
    }

    @Override
    public <T> long getCount(T entity) {
        return this.getCollection(ProxyHelper.unwrap(entity)).count();
    }

    @Override
    public <T> long getCount(Class<T> clazz) {
        return this.getCollection((Class)clazz).count();
    }

    @Override
    public <T> long getCount(Query<T> query) {
        return query.countAll();
    }

    @Override
    public DB getDB() {
        return this.db;
    }

    @Override
    public WriteConcern getDefaultWriteConcern() {
        return this.defConcern;
    }

    @Override
    public void setDefaultWriteConcern(WriteConcern wc) {
        this.defConcern = wc;
    }

    @Override
    @Deprecated
    public <T> Key<T> getKey(T entity) {
        return this.mapper.getKey(entity);
    }

    @Override
    public MongoClient getMongo() {
        return this.mongoClient;
    }

    @Override
    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    @Override
    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public <T> MapreduceResults<T> mapReduce(MapreduceType type, Query query, String map, String reduce, String finalize, Map<String, Object> scopeFields, Class<T> outputType) {
        MapReduceCommand.OutputType outType;
        DBCollection dbColl = query.getCollection();
        String outColl = this.mapper.getCollectionName(outputType);
        switch (type) {
            case REDUCE: {
                outType = MapReduceCommand.OutputType.REDUCE;
                break;
            }
            case MERGE: {
                outType = MapReduceCommand.OutputType.MERGE;
                break;
            }
            case INLINE: {
                outType = MapReduceCommand.OutputType.INLINE;
                break;
            }
            default: {
                outType = MapReduceCommand.OutputType.REPLACE;
            }
        }
        MapReduceCommand cmd = new MapReduceCommand(dbColl, map, reduce, outColl, outType, query.getQueryObject());
        if (query.getLimit() > 0) {
            cmd.setLimit(query.getLimit());
        }
        if (query.getSortObject() != null) {
            cmd.setSort(query.getSortObject());
        }
        if (finalize != null && finalize.length() != 0) {
            cmd.setFinalize(finalize);
        }
        if (scopeFields != null && !scopeFields.isEmpty()) {
            cmd.setScope(scopeFields);
        }
        return this.mapReduce(type, query, outputType, cmd);
    }

    @Override
    public <T> MapreduceResults<T> mapReduce(MapreduceType type, Query query, Class<T> outputType, MapReduceCommand baseCommand) {
        MapReduceCommand.OutputType outType;
        Assert.parametersNotNull("map", baseCommand.getMap());
        Assert.parameterNotEmpty("map", baseCommand.getMap());
        Assert.parametersNotNull("reduce", baseCommand.getReduce());
        Assert.parameterNotEmpty("reduce", baseCommand.getReduce());
        if (query.getOffset() != 0 || query.getFieldsObject() != null) {
            throw new QueryException("mapReduce does not allow the offset/retrievedFields query options.");
        }
        switch (type) {
            case REDUCE: {
                outType = MapReduceCommand.OutputType.REDUCE;
                break;
            }
            case MERGE: {
                outType = MapReduceCommand.OutputType.MERGE;
                break;
            }
            case INLINE: {
                outType = MapReduceCommand.OutputType.INLINE;
                break;
            }
            default: {
                outType = MapReduceCommand.OutputType.REPLACE;
            }
        }
        DBCollection dbColl = query.getCollection();
        MapReduceCommand cmd = new MapReduceCommand(dbColl, baseCommand.getMap(), baseCommand.getReduce(), baseCommand.getOutputTarget(), outType, query.getQueryObject());
        cmd.setFinalize(baseCommand.getFinalize());
        cmd.setScope(baseCommand.getScope());
        if (query.getLimit() > 0) {
            cmd.setLimit(query.getLimit());
        }
        if (query.getSortObject() != null) {
            cmd.setSort(query.getSortObject());
        }
        if (LOG.isTraceEnabled()) {
            LOG.info("Executing " + cmd.toString());
        }
        EntityCache cache = this.createCache();
        MapreduceResults<T> results = new MapreduceResults<T>(dbColl.mapReduce(baseCommand));
        results.setType(type);
        if (MapreduceType.INLINE.equals((Object)type)) {
            results.setInlineRequiredOptions(this, outputType, this.getMapper(), cache);
        } else {
            results.setQuery(this.newQuery(outputType, this.db.getCollection(results.getOutputCollectionName())));
        }
        return results;
    }

    @Override
    public <T> Key<T> merge(T entity) {
        return this.merge(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> merge(T entity, WriteConcern wc) {
        UpdateResults res;
        T unwrapped = entity;
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.mapper.toDBObject(unwrapped, involvedObjects);
        Key<T> key = this.mapper.getKey(unwrapped);
        Object id = this.mapper.getId(unwrapped = ProxyHelper.unwrap(unwrapped));
        if (id == null) {
            throw new MappingException("Could not get id for " + unwrapped.getClass().getName());
        }
        Object idValue = dbObj.get("_id");
        dbObj.removeField("_id");
        MappedClass mc = this.mapper.getMappedClass(unwrapped);
        DBCollection dbColl = this.getCollection(unwrapped);
        WriteResult wr = this.tryVersionedUpdate(dbColl, unwrapped, dbObj, idValue, wc, mc);
        if (wr == null) {
            Query<?> query = this.createQuery(unwrapped.getClass()).filter("_id", id);
            wr = this.update(query, (DBObject)new BasicDBObject("$set", (Object)dbObj), false, false, wc).getWriteResult();
        }
        if ((res = new UpdateResults(wr)).getUpdatedCount() == 0) {
            throw new UpdateException("Nothing updated");
        }
        dbObj.put("_id", idValue);
        this.postSaveOperations(Collections.singletonList(entity), involvedObjects, dbColl, false);
        return key;
    }

    @Override
    public <T> Query<T> queryByExample(T ex) {
        return this.queryByExample(this.getCollection(ex), ex);
    }

    @Override
    public <T> Iterable<Key<T>> save(Iterable<T> entities) {
        if (entities == null) {
            return new ArrayList<Key<T>>();
        }
        Iterator<T> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return new ArrayList<Key<T>>();
        }
        return this.save(entities, this.getWriteConcern(iterator.next()));
    }

    @Override
    public <T> Iterable<Key<T>> save(Iterable<T> entities, WriteConcern wc) {
        ArrayList<Key<T>> savedKeys = new ArrayList<Key<T>>();
        for (T ent : entities) {
            savedKeys.add(this.save(ent, wc));
        }
        return savedKeys;
    }

    @Override
    public <T> Iterable<Key<T>> save(T ... entities) {
        ArrayList<Key<T>> savedKeys = new ArrayList<Key<T>>();
        for (T ent : entities) {
            savedKeys.add(this.save(ent));
        }
        return savedKeys;
    }

    @Override
    public <T> Key<T> save(T entity) {
        return this.save(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> save(T entity, WriteConcern wc) {
        T unwrapped = ProxyHelper.unwrap(entity);
        return this.save(this.getCollection(unwrapped), unwrapped, wc);
    }

    @Override
    public <T> UpdateResults update(T entity, UpdateOperations<T> operations) {
        if (entity instanceof Query) {
            return this.update((Query)entity, operations);
        }
        MappedClass mc = this.mapper.getMappedClass(entity);
        Query<?> q = this.createQuery(mc.getClazz());
        q.disableValidation().filter("_id", this.mapper.getId(entity));
        if (!mc.getFieldsAnnotatedWith(Version.class).isEmpty()) {
            MappedField versionMF = mc.getFieldsAnnotatedWith(Version.class).get(0);
            Long oldVer = (Long)versionMF.getFieldValue(entity);
            q.filter(versionMF.getNameToStore(), oldVer);
            operations.set(versionMF.getNameToStore(), this.nextValue(oldVer));
        }
        return this.update(q, operations);
    }

    @Override
    public <T> UpdateResults update(Key<T> key, UpdateOperations<T> operations) {
        Class<Object> clazz = key.getType();
        if (clazz == null) {
            clazz = this.mapper.getClassFromCollection(key.getCollection());
        }
        return this.updateFirst(this.createQuery(clazz).disableValidation().filter("_id", key.getId()), operations);
    }

    @Override
    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> operations) {
        return this.update(query, operations, false, true);
    }

    @Override
    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing) {
        return this.update(query, operations, createIfMissing, this.getWriteConcern(query.getEntityClass()));
    }

    @Override
    public <T> UpdateResults update(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing, WriteConcern wc) {
        return this.update(query, operations, createIfMissing, true, wc);
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> operations) {
        return this.update(query, operations, false, false);
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing) {
        return this.update(query, operations, createIfMissing, false);
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, UpdateOperations<T> operations, boolean createIfMissing, WriteConcern wc) {
        return this.update(query, operations, createIfMissing, false, wc);
    }

    @Override
    public <T> UpdateResults updateFirst(Query<T> query, T entity, boolean createIfMissing) {
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.mapper.toDBObject(entity, involvedObjects);
        UpdateResults res = this.update(query, dbObj, createIfMissing, false, this.getWriteConcern(entity));
        if (res.getInsertedCount() > 0) {
            dbObj.put("_id", res.getNewId());
        }
        this.postSaveOperations(Collections.singletonList(entity), involvedObjects, this.getCollection(entity), false);
        return res;
    }

    @Override
    public <T> Query<T> createQuery(String collection, Class<T> type) {
        return this.newQuery(type, this.db.getCollection(collection));
    }

    @Override
    public <T> Query<T> createQuery(Class<T> clazz, DBObject q) {
        return this.newQuery(clazz, this.getCollection((Class)clazz), q);
    }

    @Override
    public <T> Query<T> createQuery(String collection, Class<T> type, DBObject q) {
        return this.newQuery(type, this.getCollection(collection), q);
    }

    @Override
    public <T, V> DBRef createRef(Class<T> clazz, V id) {
        if (id == null) {
            throw new MappingException("Could not get id for " + clazz.getName());
        }
        return new DBRef(this.getCollection((Class)clazz).getName(), id);
    }

    @Override
    public <T> DBRef createRef(T entity) {
        T wrapped = ProxyHelper.unwrap(entity);
        Object id = this.mapper.getId(wrapped);
        if (id == null) {
            throw new MappingException("Could not get id for " + wrapped.getClass().getName());
        }
        return this.createRef(wrapped.getClass(), id);
    }

    @Override
    public <T> UpdateOperations<T> createUpdateOperations(Class<T> type, DBObject ops) {
        UpdateOpsImpl upOps = (UpdateOpsImpl)this.createUpdateOperations(type);
        upOps.setOps(ops);
        return upOps;
    }

    @Override
    public <T, V> WriteResult delete(String kind, Class<T> clazz, V id) {
        return this.delete((T)this.find(kind, clazz).filter("_id", id));
    }

    @Override
    public <T, V> WriteResult delete(String kind, Class<T> clazz, V id, WriteConcern wc) {
        return this.delete((T)this.find(kind, clazz).filter("_id", id), wc);
    }

    @Override
    public <T> void ensureIndex(String collection, Class<T> type, String fields) {
        this.ensureIndex(collection, type, null, fields, false, false);
    }

    @Override
    public <T> void ensureIndex(String collection, Class<T> clazz, String name, String fields, boolean unique, boolean dropDupsOnCreate) {
        this.ensureIndex(this.getCollection(collection), name, QueryImpl.parseFieldsString(fields, clazz, this.mapper, true, Collections.<MappedClass>emptyList(), Collections.<MappedField>emptyList()), unique, dropDupsOnCreate, false, false, -1);
    }

    @Override
    public <T> void ensureIndexes(String collection, Class<T> clazz) {
        this.ensureIndexes(collection, clazz, false);
    }

    @Override
    public <T> void ensureIndexes(String collection, Class<T> clazz, boolean background) {
        MappedClass mc = this.mapper.getMappedClass(clazz);
        this.ensureIndexes(collection, mc, background);
    }

    @Override
    public Key<?> exists(Object entityOrKey, ReadPreference readPreference) {
        Query<?> query = this.buildExistsQuery(entityOrKey);
        if (readPreference != null) {
            query.useReadPreference(readPreference);
        }
        return query.getKey();
    }

    @Override
    public <T> Query<T> find(String collection, Class<T> clazz) {
        return this.createQuery(collection, clazz);
    }

    @Override
    public <T, V> Query<T> find(String collection, Class<T> clazz, String property, V value, int offset, int size) {
        return this.find(collection, clazz, property, value, offset, size, true);
    }

    @Override
    public <T> T get(Class<T> clazz, DBRef ref) {
        DBObject object = this.getDB().getCollection(ref.getCollectionName()).findOne((DBObject)new BasicDBObject("_id", ref.getId()));
        return this.mapper.fromDBObject(this, clazz, object, this.createCache());
    }

    @Override
    public <T, V> T get(String collection, Class<T> clazz, V id) {
        List results = this.find(collection, clazz, "_id", id, 0, 1).asList();
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    @Override
    public long getCount(String collection) {
        return this.getCollection(collection).count();
    }

    @Override
    public DBDecoderFactory getDecoderFact() {
        return this.decoderFactory != null ? this.decoderFactory : DefaultDBDecoder.FACTORY;
    }

    @Override
    public void setDecoderFact(DBDecoderFactory fact) {
        this.decoderFactory = fact;
    }

    @Override
    public <T> Key<T> insert(String collection, T entity) {
        T unwrapped = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(collection);
        return this.insert(dbColl, unwrapped, this.getWriteConcern(unwrapped));
    }

    @Override
    public <T> Key<T> insert(T entity) {
        return this.insert(entity, this.getWriteConcern(entity));
    }

    @Override
    public <T> Key<T> insert(T entity, WriteConcern wc) {
        T unwrapped = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(unwrapped);
        return this.insert(dbColl, unwrapped, wc);
    }

    @Override
    public <T> Iterable<Key<T>> insert(T ... entities) {
        return this.insert((Iterable<T>)Arrays.asList(entities), this.getWriteConcern(entities[0]));
    }

    @Override
    public <T> Iterable<Key<T>> insert(Iterable<T> entities, WriteConcern wc) {
        return this.insert(this.getCollection(entities.iterator().next()), entities, wc);
    }

    @Override
    public <T> Iterable<Key<T>> insert(String collection, Iterable<T> entities) {
        return this.insert(collection, entities, (WriteConcern)null);
    }

    @Override
    public <T> Iterable<Key<T>> insert(String collection, Iterable<T> entities, WriteConcern wc) {
        return this.insert(this.db.getCollection(collection), entities, wc);
    }

    @Override
    public <T> Query<T> queryByExample(String collection, T ex) {
        return this.queryByExample(this.db.getCollection(collection), ex);
    }

    @Override
    public <T> Key<T> save(String collection, T entity) {
        T unwrapped = ProxyHelper.unwrap(entity);
        return this.save(collection, entity, this.getWriteConcern(unwrapped));
    }

    @Override
    public <T> Key<T> save(String collection, T entity, WriteConcern wc) {
        return this.save(this.getCollection(collection), ProxyHelper.unwrap(entity), wc);
    }

    public <T, V> WriteResult delete(Class<T> clazz, V id, WriteConcern wc) {
        return this.delete((T)this.createQuery(clazz).filter("_id", id), wc);
    }

    public <T, V> Query<T> find(String collection, Class<T> clazz, String property, V value, int offset, int size, boolean validate) {
        Query<T> query = this.find(collection, clazz);
        if (!validate) {
            query.disableValidation();
        }
        query.offset(offset);
        query.limit(size);
        return query.filter(property, value).enableValidation();
    }

    public DBCollection getCollection(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.getCollection((Class)(obj instanceof Class ? (Class<?>)obj : obj.getClass()));
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public <T> Iterable<Key<T>> insert(Iterable<T> entities) {
        return this.insert(entities, (WriteConcern)null);
    }

    public <T> Key<T> insert(String collection, T entity, WriteConcern wc) {
        T unwrapped = ProxyHelper.unwrap(entity);
        DBCollection dbColl = this.getCollection(collection);
        return this.insert(dbColl, unwrapped, wc);
    }

    protected <T> void ensureIndex(Class<T> clazz, String name, BasicDBObject fields, boolean unique, boolean dropDupsOnCreate, boolean background, boolean sparse, int expireAfterSeconds) {
        DBCollection dbColl = this.getCollection((Class)clazz);
        this.ensureIndex(dbColl, name, fields, unique, dropDupsOnCreate, background, sparse, expireAfterSeconds);
    }

    protected void ensureIndex(DBCollection dbColl, String name, BasicDBObject fields, boolean unique, boolean dropDupsOnCreate, boolean background, boolean sparse, int expireAfterSeconds) {
        BasicDBObject opts = new BasicDBObject();
        if (name != null && name.length() != 0) {
            opts.append("name", (Object)name);
        }
        if (unique) {
            opts.append("unique", (Object)true);
            if (dropDupsOnCreate) {
                opts.append("dropDups", (Object)true);
            }
        }
        if (background) {
            opts.append("background", (Object)true);
        }
        if (sparse) {
            opts.append("sparse", (Object)true);
        }
        if (expireAfterSeconds > -1) {
            opts.append("expireAfterSeconds", (Object)expireAfterSeconds);
        }
        LOG.debug(String.format("Creating index for %s with keys:%s and opts:%s", dbColl.getName(), fields, opts));
        dbColl.createIndex((DBObject)fields, (DBObject)opts);
    }

    protected void ensureIndex(MappedClass mc, DBCollection dbColl, Field[] fields, IndexOptions options, boolean background, List<MappedClass> parentMCs, List<MappedField> parentMFs) {
        BasicDBObject keys = new BasicDBObject();
        StringBuilder name = new StringBuilder();
        if (!parentMCs.isEmpty()) {
            for (MappedField pmf : parentMFs) {
                name.append(pmf.getNameToStore()).append(".");
            }
        }
        DBObject opts = this.extractOptions(options, background);
        for (Field field : fields) {
            String value = field.value();
            String key = name + value;
            if (!"$**".equals(value)) {
                ArrayList<String> namePath = new ArrayList<String>();
                MappedField mappedField = this.findField(namePath, mc, value);
                if (!options.disableValidation() && mappedField == null) {
                    throw new MappingException(String.format("Unknown field '%s' for index: %s", value, mc.getClazz().getName()));
                }
                StringBuilder sb = new StringBuilder();
                for (String s : namePath) {
                    if (sb.length() != 0) {
                        sb.append(".");
                    }
                    sb.append(s);
                }
                key = name + sb.toString();
            }
            keys.put(key, field.type().toIndexValue());
            if (field.weight() == -1) continue;
            if (field.type() != IndexType.TEXT) {
                throw new MappingException("Weight values only apply to text indexes: " + Arrays.toString(fields));
            }
            DBObject weights = (DBObject)opts.get("weights");
            if (weights == null) {
                weights = new BasicDBObject();
                opts.put("weights", (Object)weights);
            }
            weights.put(key, (Object)field.weight());
        }
        LOG.debug(String.format("Creating index for %s with keys:%s and opts:%s", dbColl.getName(), keys, opts));
        dbColl.createIndex((DBObject)keys, opts);
    }

    protected void ensureIndex(DBCollection dbColl, DBObject keys, DBObject options) {
        LOG.debug(String.format("Creating index for %s with keys:%s and opts:%s", dbColl.getName(), keys, options));
        dbColl.createIndex(keys, options);
    }

    protected void ensureIndexes(MappedClass mc, boolean background, List<MappedClass> parentMCs, List<MappedField> parentMFs) {
        this.ensureIndexes(this.getCollection((Class)mc.getClazz()), mc, background, parentMCs, parentMFs);
    }

    protected void ensureIndexes(String collName, MappedClass mc, boolean background) {
        this.ensureIndexes(this.getCollection(collName), mc, background, Collections.<MappedClass>emptyList(), Collections.<MappedField>emptyList());
    }

    protected void ensureIndexes(DBCollection dbColl, MappedClass mc, boolean background, List<MappedClass> parentMCs, List<MappedField> parentMFs) {
        if (parentMCs.contains(mc)) {
            return;
        }
        if (mc.getEmbeddedAnnotation() != null && parentMCs.isEmpty()) {
            return;
        }
        this.processClassAnnotations(dbColl, mc, background, parentMCs, parentMFs);
        this.processEmbeddedAnnotations(dbColl, mc, background, parentMCs, parentMFs);
    }

    protected void ensureIndexes(MappedClass mc, boolean background) {
        this.ensureIndexes(mc, background, new ArrayList<MappedClass>(), new ArrayList<MappedField>());
    }

    protected DBCollection getCollection(String kind) {
        if (kind == null) {
            return null;
        }
        return this.getDB().getCollection(kind);
    }

    @Deprecated
    protected Object getId(Object entity) {
        return this.mapper.getId(entity);
    }

    protected <T> Key<T> insert(DBCollection dbColl, T entity, WriteConcern wc) {
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.entityToDBObj(entity, involvedObjects);
        if (wc == null) {
            dbColl.insert(new DBObject[]{dbObj});
        } else {
            dbColl.insert(dbObj, wc);
        }
        return this.postSaveOperations(Collections.singletonList(entity), involvedObjects, dbColl).get(0);
    }

    protected <T> Key<T> save(DBCollection dbColl, T entity, WriteConcern wc) {
        Object idValue;
        if (entity == null) {
            throw new UpdateException("Can not persist a null entity");
        }
        MappedClass mc = this.mapper.getMappedClass(entity);
        if (mc.getAnnotation(NotSaved.class) != null) {
            throw new MappingException(String.format("Entity type: %s is marked as NotSaved which means you should not try to save it!", mc.getClazz().getName()));
        }
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        DBObject dbObj = this.entityToDBObj(entity, involvedObjects);
        WriteResult wr = this.tryVersionedUpdate(dbColl, entity, dbObj, idValue = dbObj.get("_id"), wc, mc);
        if (wr == null) {
            if (wc == null) {
                dbColl.save(dbObj);
            } else {
                dbColl.save(dbObj, wc);
            }
        }
        return this.postSaveOperations(Collections.singletonList(entity), involvedObjects, dbColl).get(0);
    }

    protected <T> WriteResult tryVersionedUpdate(DBCollection dbColl, T entity, DBObject dbObj, Object idValue, WriteConcern wc, MappedClass mc) {
        WriteResult wr;
        if (mc.getFieldsAnnotatedWith(Version.class).isEmpty()) {
            return null;
        }
        MappedField mfVersion = mc.getMappedVersionField();
        String versionKeyName = mfVersion.getNameToStore();
        Long oldVersion = (Long)mfVersion.getFieldValue(entity);
        long newVersion = this.nextValue(oldVersion);
        dbObj.put(versionKeyName, (Object)newVersion);
        if (idValue != null && newVersion != 1L) {
            boolean compoundId;
            Query<?> query = this.find(dbColl.getName(), entity.getClass());
            boolean bl = compoundId = !ReflectionUtils.isPrimitiveLike(mc.getMappedIdField().getType()) && idValue instanceof DBObject;
            if (compoundId) {
                query.disableValidation();
            }
            query.filter("_id", idValue);
            if (compoundId) {
                query.enableValidation();
            }
            query.filter(versionKeyName, oldVersion);
            UpdateResults res = this.update(query, dbObj, false, false, wc);
            wr = res.getWriteResult();
            if (res.getUpdatedCount() != 1) {
                throw new ConcurrentModificationException(String.format("Entity of class %s (id='%s',version='%d') was concurrently updated.", entity.getClass().getName(), idValue, oldVersion));
            }
        } else {
            wr = wc == null ? dbColl.save(dbObj) : dbColl.save(dbObj, wc);
        }
        return wr;
    }

    private Query<?> buildExistsQuery(Object entityOrKey) {
        Object unwrapped = ProxyHelper.unwrap(entityOrKey);
        Key<Object> key = this.mapper.getKey(unwrapped);
        Object id = key.getId();
        if (id == null) {
            throw new MappingException("Could not get id for " + unwrapped.getClass().getName());
        }
        return this.find(key.getCollection(), key.getType()).filter("_id", key.getId());
    }

    private EntityCache createCache() {
        return this.mapper.createEntityCache();
    }

    private void createTextIndex(DBCollection dbColl, List<MappedClass> parentMCs, List<MappedField> parentMFs, MappedField mf) {
        Text index = mf.getAnnotation(Text.class);
        StringBuilder prefix = new StringBuilder();
        if (!parentMCs.isEmpty()) {
            for (MappedField pmf : parentMFs) {
                prefix.append(pmf.getNameToStore()).append(".");
            }
        }
        String field = prefix + mf.getNameToStore();
        BasicDBObject keys = new BasicDBObject(field, IndexType.TEXT.toIndexValue());
        DBObject opts = this.extractOptions(index.options(), false);
        if (index.value() != -1) {
            BasicDBObject weights = new BasicDBObject();
            opts.put("weights", (Object)weights);
            weights.put(field, (Object)index.value());
        }
        LOG.debug(String.format("Creating index for %s with keys:%s and opts:%s", dbColl.getName(), keys, opts));
        dbColl.createIndex((DBObject)keys, opts);
    }

    private DBObject entityToDBObj(Object entity, Map<Object, DBObject> involvedObjects) {
        return this.mapper.toDBObject(ProxyHelper.unwrap(entity), involvedObjects);
    }

    private DBObject extractOptions(IndexOptions options, boolean background) {
        BasicDBObject opts = new BasicDBObject();
        this.putIfNotEmpty((DBObject)opts, "name", options.name());
        this.putIfNotEmpty((DBObject)opts, "default_language", options.language());
        this.putIfNotEmpty((DBObject)opts, "language_override", options.languageOverride());
        this.putIfTrue((DBObject)opts, "background", options.background() || background);
        this.putIfTrue((DBObject)opts, "dropDups", options.dropDups());
        this.putIfTrue((DBObject)opts, "sparse", options.sparse());
        this.putIfTrue((DBObject)opts, "unique", options.unique());
        if (options.expireAfterSeconds() != -1) {
            opts.put("expireAfterSeconds", (Object)options.expireAfterSeconds());
        }
        return opts;
    }

    private DBObject extractOptions(Indexed indexed) {
        BasicDBObject opts = new BasicDBObject();
        this.putIfNotEmpty((DBObject)opts, "name", indexed.name());
        this.putIfTrue((DBObject)opts, "background", indexed.background());
        this.putIfTrue((DBObject)opts, "dropDups", indexed.dropDups());
        this.putIfTrue((DBObject)opts, "sparse", indexed.sparse());
        this.putIfTrue((DBObject)opts, "unique", indexed.unique());
        if (indexed.expireAfterSeconds() != -1) {
            opts.put("expireAfterSeconds", (Object)indexed.expireAfterSeconds());
        }
        return opts;
    }

    private MappedField findField(List<String> namePath, MappedClass mc, String value) {
        if (value.contains(".")) {
            String segment = value.substring(0, value.indexOf("."));
            MappedField field = this.findField(namePath, mc, segment);
            if (field != null) {
                MappedClass mappedClass = this.getMapper().getMappedClass(field.getSubType() != null ? field.getSubType() : field.getConcreteType());
                return this.findField(namePath, mappedClass, value.substring(value.indexOf(".") + 1));
            }
            namePath.addAll(Arrays.asList(value.split("\\.")));
            return null;
        }
        MappedField mf = mc.getMappedField(value);
        if (mf == null) {
            mf = mc.getMappedFieldByJavaField(value);
        }
        if (mf != null) {
            namePath.add(mf.getNameToStore());
        }
        return mf;
    }

    private <T> Iterable<Key<T>> insert(DBCollection dbColl, Iterable<T> entities, WriteConcern wc) {
        WriteConcern writeConcern = wc;
        if (writeConcern == null) {
            writeConcern = this.getWriteConcern(entities.iterator().next());
        }
        LinkedHashMap<Object, DBObject> involvedObjects = new LinkedHashMap<Object, DBObject>();
        if (this.morphia.getUseBulkWriteOperations()) {
            BulkWriteOperation bulkWriteOperation = dbColl.initializeOrderedBulkOperation();
            for (T entity : entities) {
                bulkWriteOperation.insert(this.toDbObject(entity, involvedObjects));
            }
            bulkWriteOperation.execute(writeConcern);
        } else {
            writeConcern = this.getWriteConcern(entities.iterator().next());
            ArrayList<DBObject> list = new ArrayList<DBObject>();
            for (T entity : entities) {
                list.add(this.toDbObject(entity, involvedObjects));
            }
            dbColl.insert(writeConcern, list.toArray(new DBObject[list.size()]));
        }
        return this.postSaveOperations(entities, involvedObjects, dbColl);
    }

    private <T> Query<T> newQuery(Class<T> type, DBCollection collection, DBObject query) {
        return this.getQueryFactory().createQuery(this, collection, type, query);
    }

    private <T> Query<T> newQuery(Class<T> type, DBCollection collection) {
        return this.getQueryFactory().createQuery(this, collection, type);
    }

    private long nextValue(Long oldVersion) {
        return oldVersion == null ? 1L : oldVersion + 1L;
    }

    private <T> List<Key<T>> postSaveOperations(Iterable<T> entities, Map<Object, DBObject> involvedObjects, DBCollection collection) {
        return this.postSaveOperations(entities, involvedObjects, collection, true);
    }

    private <T> List<Key<T>> postSaveOperations(Iterable<T> entities, Map<Object, DBObject> involvedObjects, DBCollection collection, boolean fetchKeys) {
        ArrayList<Key<T>> keys = new ArrayList<Key<T>>();
        for (T t : entities) {
            DBObject dbObj = involvedObjects.remove(t);
            if (fetchKeys) {
                if (dbObj.get("_id") == null) {
                    throw new MappingException(String.format("Missing _id after save on %s", t.getClass().getName()));
                }
                this.mapper.updateKeyAndVersionInfo(this, dbObj, this.createCache(), t);
                keys.add(new Key(t.getClass(), collection.getName(), this.mapper.getId(t)));
            }
            this.mapper.getMappedClass(t).callLifecycleMethods(PostPersist.class, t, dbObj, this.mapper);
        }
        for (Map.Entry entry : involvedObjects.entrySet()) {
            Object key = entry.getKey();
            this.mapper.getMappedClass(key).callLifecycleMethods(PostPersist.class, key, (DBObject)entry.getValue(), this.mapper);
        }
        return keys;
    }

    private void processClassAnnotations(DBCollection dbColl, MappedClass mc, boolean background, List<MappedClass> parentMCs, List<MappedField> parentMFs) {
        List indexes = mc.getAnnotations(Indexes.class);
        if (indexes != null) {
            for (Indexes idx : indexes) {
                if (idx.value().length <= 0) continue;
                for (Index index : idx.value()) {
                    if (index.fields().length != 0) {
                        this.ensureIndex(mc, dbColl, index.fields(), index.options(), background, parentMCs, parentMFs);
                        continue;
                    }
                    LOG.warning(String.format("This index on '%s' is using deprecated configuration options.  Please update to use the fields value on @Index: %s", mc.getClazz().getName(), index.toString()));
                    BasicDBObject fields = QueryImpl.parseFieldsString(index.value(), mc.getClazz(), this.mapper, !index.disableValidation(), parentMCs, parentMFs);
                    this.ensureIndex(dbColl, index.name(), fields, index.unique(), index.dropDups(), index.background() ? index.background() : background, index.sparse(), index.expireAfterSeconds());
                }
            }
        }
    }

    private void processEmbeddedAnnotations(DBCollection dbColl, MappedClass mc, boolean background, List<MappedClass> parentMCs, List<MappedField> parentMFs) {
        List<MappedField> annotatedWith = mc.getFieldsAnnotatedWith(Text.class);
        if (annotatedWith.size() > 1) {
            throw new MappingException("Only one text index can be defined per collection: " + mc.getClazz().getName());
        }
        for (MappedField mf : mc.getPersistenceFields()) {
            if (mf.hasAnnotation(Indexed.class)) {
                Indexed index = mf.getAnnotation(Indexed.class);
                StringBuilder prefix = new StringBuilder();
                if (!parentMCs.isEmpty()) {
                    for (MappedField pmf : parentMFs) {
                        prefix.append(pmf.getNameToStore()).append(".");
                    }
                }
                BasicDBObject oldOptions = (BasicDBObject)this.extractOptions(index);
                IndexOptions options = index.options();
                BasicDBObject newOptions = (BasicDBObject)this.extractOptions(options, false);
                if (!oldOptions.isEmpty() && !newOptions.isEmpty()) {
                    throw new MappingException("Mixed usage of deprecated @Indexed value with the new @IndexOption values is not allowed.  Please migrate all settings to @IndexOptions");
                }
                if (!newOptions.isEmpty()) {
                    this.ensureIndex(dbColl, (DBObject)new BasicDBObject(prefix + mf.getNameToStore(), index.value().toIndexValue()), (DBObject)newOptions);
                } else {
                    this.ensureIndex(dbColl, index.name(), new BasicDBObject(prefix + mf.getNameToStore(), index.value().toIndexValue()), index.unique(), index.dropDups(), index.background() || background, index.sparse(), index.expireAfterSeconds());
                }
            }
            if (mf.hasAnnotation(Text.class)) {
                this.createTextIndex(dbColl, parentMCs, parentMFs, mf);
            }
            if (mf.isTypeMongoCompatible() || mf.hasAnnotation(Reference.class) || mf.hasAnnotation(Serialized.class) || mf.hasAnnotation(NotSaved.class) || mf.hasAnnotation(Transient.class)) continue;
            ArrayList<MappedClass> newParentClasses = new ArrayList<MappedClass>(parentMCs);
            ArrayList<MappedField> newParents = new ArrayList<MappedField>(parentMFs);
            newParentClasses.add(mc);
            newParents.add(mf);
            this.ensureIndexes(dbColl, this.mapper.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass()), background, newParentClasses, newParents);
        }
    }

    private void putIfNotEmpty(DBObject opts, String key, String value) {
        if (!value.equals("")) {
            opts.put(key, (Object)value);
        }
    }

    private void putIfTrue(DBObject opts, String key, boolean value) {
        if (value) {
            opts.put(key, (Object)true);
        }
    }

    private <T> Query<T> queryByExample(DBCollection coll, T example) {
        Class<?> type = example.getClass();
        DBObject query = this.entityToDBObj(example, new HashMap<Object, DBObject>());
        return this.newQuery(type, coll, query);
    }

    private <T> DBObject toDbObject(T ent, Map<Object, DBObject> involvedObjects) {
        MappedClass mc = this.mapper.getMappedClass(ent);
        if (mc.getAnnotation(NotSaved.class) != null) {
            throw new MappingException(String.format("Entity type: %s is marked as NotSaved which means you should not try to save it!", mc.getClazz().getName()));
        }
        DBObject dbObject = this.entityToDBObj(ent, involvedObjects);
        List<MappedField> versionFields = mc.getFieldsAnnotatedWith(Version.class);
        for (MappedField mappedField : versionFields) {
            String name = mappedField.getNameToStore();
            if (dbObject.get(name) != null) continue;
            dbObject.put(name, (Object)1);
            mappedField.setFieldValue(ent, 1L);
        }
        return dbObject;
    }

    private <T> UpdateResults update(Query<T> query, UpdateOperations ops, boolean createIfMissing, boolean multi) {
        return this.update(query, ops, createIfMissing, multi, this.getWriteConcern(query.getEntityClass()));
    }

    private <T> UpdateResults update(Query<T> query, UpdateOperations ops, boolean createIfMissing, boolean multi, WriteConcern wc) {
        DBObject u = ((UpdateOpsImpl)ops).getOps();
        if (((UpdateOpsImpl)ops).isIsolated()) {
            Query<T> q = query.cloneQuery();
            q.disableValidation().filter("$atomic", true);
            return this.update(q, u, createIfMissing, multi, wc);
        }
        return this.update(query, u, createIfMissing, multi, wc);
    }

    private <T> UpdateResults update(Query<T> query, DBObject u, boolean createIfMissing, boolean multi, WriteConcern wc) {
        MappedField versionMF;
        MappedClass mc;
        List<MappedField> fields;
        DBCollection dbColl = query.getCollection();
        if (dbColl == null) {
            dbColl = this.getCollection((Class)query.getEntityClass());
        }
        if (query.getSortObject() != null && query.getSortObject().keySet() != null && !query.getSortObject().keySet().isEmpty()) {
            throw new QueryException("sorting is not allowed for updates.");
        }
        if (query.getOffset() > 0) {
            throw new QueryException("a query offset is not allowed for updates.");
        }
        if (query.getLimit() > 0) {
            throw new QueryException("a query limit is not allowed for updates.");
        }
        DBObject q = query.getQueryObject();
        if (q == null) {
            q = new BasicDBObject();
        }
        if (!(fields = (mc = this.getMapper().getMappedClass(query.getEntityClass())).getFieldsAnnotatedWith(Version.class)).isEmpty() && q.get((versionMF = fields.get(0)).getNameToStore()) == null) {
            if (!u.containsField("$inc")) {
                u.put("$inc", (Object)new BasicDBObject(versionMF.getNameToStore(), (Object)1));
            } else {
                ((Map)u.get("$inc")).put(versionMF.getNameToStore(), 1);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing update(" + dbColl.getName() + ") for query: " + q + ", ops: " + u + ", multi: " + multi + ", upsert: " + createIfMissing);
        }
        WriteResult wr = wc == null ? dbColl.update(q, u, createIfMissing, multi) : dbColl.update(q, u, createIfMissing, multi, wc);
        return new UpdateResults(wr);
    }

    WriteConcern getWriteConcern(Object clazzOrEntity) {
        Entity entityAnn;
        WriteConcern wc = this.defConcern;
        if (clazzOrEntity != null && (entityAnn = this.getMapper().getMappedClass(clazzOrEntity).getEntityAnnotation()) != null && entityAnn.concern() != null && entityAnn.concern().length() != 0) {
            wc = WriteConcern.valueOf((String)entityAnn.concern());
        }
        return wc;
    }
}

