/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import com.mongodb.MapReduceOutput;
import java.util.Iterator;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.MapreduceType;
import org.mongodb.morphia.annotations.NotSaved;
import org.mongodb.morphia.annotations.Transient;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.query.MorphiaIterator;
import org.mongodb.morphia.query.Query;

@NotSaved
public class MapreduceResults<T>
implements Iterable<T> {
    private static final Logger LOG = MorphiaLoggerFactory.get(MapreduceResults.class);
    private final Stats counts = new Stats();
    private MapReduceOutput output;
    private String outputCollectionName;
    private MapreduceType type;
    private Query<T> query;
    @Transient
    private Class<T> clazz;
    @Transient
    private Mapper mapper;
    @Transient
    private EntityCache cache;
    private Datastore datastore;

    public MapreduceResults(MapReduceOutput output) {
        this.output = output;
        this.outputCollectionName = output.getCollectionName();
    }

    public Query<T> createQuery() {
        if (this.type == MapreduceType.INLINE) {
            throw new MappingException("No collection available for inline mapreduce jobs");
        }
        return this.query.cloneQuery();
    }

    public Stats getCounts() {
        return this.counts;
    }

    public long getElapsedMillis() {
        return this.output.getDuration();
    }

    @Deprecated
    public String getError() {
        LOG.warning("MapreduceResults.getError() will always return null.");
        return null;
    }

    public Iterator<T> getInlineResults() {
        return new MorphiaIterator(this.datastore, this.output.results().iterator(), this.mapper, this.clazz, null, this.cache);
    }

    public MapreduceType getType() {
        return this.type;
    }

    void setType(MapreduceType type) {
        this.type = type;
    }

    @Deprecated
    public boolean isOk() {
        LOG.warning("MapreduceResults.isOk() will always return true.");
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.type == MapreduceType.INLINE) {
            return this.getInlineResults();
        }
        return this.createQuery().fetch().iterator();
    }

    public void setInlineRequiredOptions(Datastore datastore, Class<T> clazz, Mapper mapper, EntityCache cache) {
        this.mapper = mapper;
        this.datastore = datastore;
        this.clazz = clazz;
        this.cache = cache;
    }

    String getOutputCollectionName() {
        return this.outputCollectionName;
    }

    void setQuery(Query<T> query) {
        this.query = query;
    }

    public class Stats {
        public int getEmitCount() {
            return MapreduceResults.this.output.getEmitCount();
        }

        public int getInputCount() {
            return MapreduceResults.this.output.getInputCount();
        }

        public int getOutputCount() {
            return MapreduceResults.this.output.getOutputCount();
        }
    }
}

