/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia;

import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Set;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.DatastoreImpl;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.utils.ReflectionUtils;

public class Morphia {
    private final Mapper mapper;
    private boolean useBulkWriteOperations = false;

    public Morphia() {
        this(new Mapper(), Collections.emptySet());
    }

    public Morphia(Mapper mapper, Set<Class> classesToMap) {
        this.mapper = mapper;
        for (Class c : classesToMap) {
            this.map(c);
        }
    }

    public Morphia(Mapper mapper) {
        this(mapper, Collections.emptySet());
    }

    public Morphia(Set<Class> classesToMap) {
        this(new Mapper(), classesToMap);
    }

    public Datastore createDatastore(MongoClient mongoClient, String dbName) {
        return new DatastoreImpl(this, mongoClient, dbName);
    }

    public Datastore createDatastore(MongoClient mongoClient, Mapper mapper, String dbName) {
        return new DatastoreImpl(this, mapper, mongoClient, dbName);
    }

    public <T> T fromDBObject(Datastore datastore, Class<T> entityClass, DBObject dbObject) {
        return this.fromDBObject(datastore, entityClass, dbObject, this.mapper.createEntityCache());
    }

    public <T> T fromDBObject(Datastore datastore, Class<T> entityClass, DBObject dbObject, EntityCache cache) {
        if (!entityClass.isInterface() && !this.mapper.isMapped(entityClass)) {
            throw new MappingException("Trying to map to an unmapped class: " + entityClass.getName());
        }
        try {
            return this.mapper.fromDBObject(datastore, entityClass, dbObject, cache);
        }
        catch (Exception e) {
            throw new MappingException("Could not map entity from DBObject", e);
        }
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public boolean getUseBulkWriteOperations() {
        return this.useBulkWriteOperations;
    }

    public boolean isMapped(Class entityClass) {
        return this.mapper.isMapped(entityClass);
    }

    public boolean isUseBulkWriteOperations() {
        return this.useBulkWriteOperations;
    }

    public void setUseBulkWriteOperations(boolean useBulkWriteOperations) {
        this.useBulkWriteOperations = useBulkWriteOperations;
    }

    public synchronized Morphia map(Class ... entityClasses) {
        if (entityClasses != null && entityClasses.length > 0) {
            for (Class entityClass : entityClasses) {
                if (this.mapper.isMapped(entityClass)) continue;
                this.mapper.addMappedClass(entityClass);
            }
        }
        return this;
    }

    public synchronized Morphia map(Set<Class> entityClasses) {
        if (entityClasses != null && !entityClasses.isEmpty()) {
            for (Class entityClass : entityClasses) {
                if (this.mapper.isMapped(entityClass)) continue;
                this.mapper.addMappedClass(entityClass);
            }
        }
        return this;
    }

    public synchronized Morphia mapPackage(String packageName) {
        return this.mapPackage(packageName, false);
    }

    public synchronized Morphia mapPackage(String packageName, boolean ignoreInvalidClasses) {
        try {
            for (Class<?> clazz : ReflectionUtils.getClasses(packageName, this.mapper.getOptions().isMapSubPackages())) {
                try {
                    Embedded embeddedAnn = ReflectionUtils.getClassEmbeddedAnnotation(clazz);
                    Entity entityAnn = ReflectionUtils.getClassEntityAnnotation(clazz);
                    boolean isAbstract = Modifier.isAbstract(clazz.getModifiers());
                    if (entityAnn == null && embeddedAnn == null || isAbstract) continue;
                    this.map(clazz);
                }
                catch (MappingException ex) {
                    if (ignoreInvalidClasses) continue;
                    throw ex;
                }
            }
            return this;
        }
        catch (IOException e) {
            throw new MappingException("Could not get map classes from package " + packageName, e);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Could not get map classes from package " + packageName, e);
        }
    }

    public Morphia mapPackageFromClass(Class clazz) {
        return this.mapPackage(clazz.getPackage().getName(), false);
    }

    public DBObject toDBObject(Object entity) {
        try {
            return this.mapper.toDBObject(entity);
        }
        catch (Exception e) {
            throw new MappingException("Could not map entity to DBObject", e);
        }
    }
}

