/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.aggregation;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bson.BSONObject;
import org.mongodb.morphia.DatastoreImpl;
import org.mongodb.morphia.aggregation.Accumulator;
import org.mongodb.morphia.aggregation.AggregationPipeline;
import org.mongodb.morphia.aggregation.GeoNear;
import org.mongodb.morphia.aggregation.Group;
import org.mongodb.morphia.aggregation.Projection;
import org.mongodb.morphia.aggregation.Sort;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.query.MorphiaIterator;
import org.mongodb.morphia.query.Query;

public class AggregationPipelineImpl
implements AggregationPipeline {
    private static final Logger LOG = MorphiaLoggerFactory.get(AggregationPipelineImpl.class);
    private final DBCollection collection;
    private final Class source;
    private final List<DBObject> stages = new ArrayList<DBObject>();
    private final Mapper mapper;
    private final DatastoreImpl datastore;
    private boolean firstStage = false;

    public AggregationPipelineImpl(DatastoreImpl datastore, Class source) {
        this.datastore = datastore;
        this.collection = datastore.getCollection(source);
        this.mapper = datastore.getMapper();
        this.source = source;
    }

    public List<DBObject> getStages() {
        return this.stages;
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target) {
        return this.aggregate(target, AggregationOptions.builder().build(), this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options) {
        return this.aggregate(target, options, this.collection.getReadPreference());
    }

    @Override
    public <U> Iterator<U> aggregate(Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        return this.aggregate(this.datastore.getCollection((Class)target).getName(), target, options, readPreference);
    }

    @Override
    public <U> Iterator<U> aggregate(String collectionName, Class<U> target, AggregationOptions options, ReadPreference readPreference) {
        LOG.debug("stages = " + this.stages);
        Cursor cursor = this.collection.aggregate(this.stages, options, readPreference);
        return new MorphiaIterator(this.datastore, (Iterator<DBObject>)cursor, this.mapper, target, this.collection.getName(), this.mapper.createEntityCache());
    }

    @Override
    public AggregationPipeline geoNear(GeoNear geoNear) {
        BasicDBObject geo = new BasicDBObject();
        this.putIfNull((DBObject)geo, "near", geoNear.getNear());
        this.putIfNull((DBObject)geo, "distanceField", geoNear.getDistanceField());
        this.putIfNull((DBObject)geo, "limit", geoNear.getLimit());
        this.putIfNull((DBObject)geo, "num", geoNear.getMaxDocuments());
        this.putIfNull((DBObject)geo, "maxDistance", geoNear.getMaxDistance());
        if (geoNear.getQuery() != null) {
            geo.put("query", (Object)geoNear.getQuery().getQueryObject());
        }
        this.putIfNull((DBObject)geo, "spherical", geoNear.getSpherical());
        this.putIfNull((DBObject)geo, "distanceMultiplier", geoNear.getDistanceMultiplier());
        this.putIfNull((DBObject)geo, "includeLocs", geoNear.getIncludeLocations());
        this.putIfNull((DBObject)geo, "uniqueDocs", geoNear.getUniqueDocuments());
        this.stages.add((DBObject)new BasicDBObject("$geoNear", (Object)geo));
        return this;
    }

    @Override
    public AggregationPipeline group(String id, Group ... groupings) {
        BasicDBObject group = new BasicDBObject("_id", (Object)("$" + id));
        for (Group grouping : groupings) {
            Accumulator accumulator = grouping.getAccumulator();
            group.put(grouping.getName(), (Object)new BasicDBObject(accumulator.getOperation(), accumulator.getField()));
        }
        this.stages.add((DBObject)new BasicDBObject("$group", (Object)group));
        return this;
    }

    @Override
    public AggregationPipeline group(List<Group> id, Group ... groupings) {
        BasicDBObject idGroup = new BasicDBObject();
        for (Group group : id) {
            idGroup.put(group.getName(), (Object)group.getSourceField());
        }
        BasicDBObject group = new BasicDBObject("_id", (Object)idGroup);
        for (Group grouping : groupings) {
            Accumulator accumulator = grouping.getAccumulator();
            group.put(grouping.getName(), (Object)new BasicDBObject(accumulator.getOperation(), accumulator.getField()));
        }
        this.stages.add((DBObject)new BasicDBObject("$group", (Object)group));
        return this;
    }

    @Override
    public AggregationPipeline limit(int count) {
        this.stages.add((DBObject)new BasicDBObject("$limit", (Object)count));
        return this;
    }

    @Override
    public AggregationPipeline match(Query query) {
        this.stages.add((DBObject)new BasicDBObject("$match", (Object)query.getQueryObject()));
        return this;
    }

    @Override
    public <U> Iterator<U> out(Class<U> target) {
        return this.out(this.datastore.getCollection((Class)target).getName(), target);
    }

    @Override
    public <U> Iterator<U> out(Class<U> target, AggregationOptions options) {
        return this.out(this.datastore.getCollection((Class)target).getName(), target, options);
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target) {
        return this.out(collectionName, target, AggregationOptions.builder().build());
    }

    @Override
    public <U> Iterator<U> out(String collectionName, Class<U> target, AggregationOptions options) {
        this.stages.add((DBObject)new BasicDBObject("$out", (Object)collectionName));
        return this.aggregate(target, options);
    }

    @Override
    public AggregationPipeline project(Projection ... projections) {
        this.firstStage = this.stages.isEmpty();
        BasicDBObject dbObject = new BasicDBObject();
        for (Projection projection : projections) {
            dbObject.putAll((BSONObject)this.toDBObject(projection));
        }
        this.stages.add((DBObject)new BasicDBObject("$project", (Object)dbObject));
        return this;
    }

    @Override
    public AggregationPipeline skip(int count) {
        this.stages.add((DBObject)new BasicDBObject("$skip", (Object)count));
        return this;
    }

    @Override
    public AggregationPipeline sort(Sort ... sorts) {
        BasicDBObject sortList = new BasicDBObject();
        for (Sort sort : sorts) {
            sortList.put(sort.getField(), (Object)sort.getDirection());
        }
        this.stages.add((DBObject)new BasicDBObject("$sort", (Object)sortList));
        return this;
    }

    @Override
    public AggregationPipeline unwind(String field) {
        this.stages.add((DBObject)new BasicDBObject("$unwind", (Object)("$" + field)));
        return this;
    }

    public DBObject toDBObject(Projection projection) {
        String target;
        if (this.firstStage) {
            MappedField field = this.mapper.getMappedClass(this.source).getMappedField(projection.getTarget());
            target = field.getNameToStore();
        } else {
            target = projection.getTarget();
        }
        if (projection.getProjections() != null) {
            List<Projection> list = projection.getProjections();
            BasicDBObject projections = new BasicDBObject();
            for (Projection subProjection : list) {
                projections.putAll((BSONObject)this.toDBObject(subProjection));
            }
            return new BasicDBObject(target, (Object)projections);
        }
        if (projection.getSource() != null) {
            return new BasicDBObject(target, (Object)projection.getSource());
        }
        if (projection.getArguments() != null) {
            if (target == null) {
                return this.toExpressionArgs(projection.getArguments());
            }
            return new BasicDBObject(target, (Object)this.toExpressionArgs(projection.getArguments()));
        }
        return new BasicDBObject(target, (Object)(projection.isSuppressed() ? 0 : 1));
    }

    private void putIfNull(DBObject dbObject, String name, Object value) {
        if (value != null) {
            dbObject.put(name, value);
        }
    }

    private BasicDBList toExpressionArgs(List<Object> args) {
        BasicDBList result = new BasicDBList();
        for (Object arg : args) {
            if (arg instanceof Projection) {
                Projection projection = (Projection)arg;
                if (projection.getArguments() != null || projection.getProjections() != null || projection.getSource() != null) {
                    result.add((Object)this.toDBObject(projection));
                    continue;
                }
                result.add((Object)("$" + projection.getTarget()));
                continue;
            }
            if (arg instanceof Number) {
                result.add(arg);
                continue;
            }
            if (!(arg instanceof String)) continue;
            result.add(arg);
        }
        return result;
    }

    public String toString() {
        return this.stages.toString();
    }
}

