/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.aggregation;

import java.util.Arrays;
import java.util.List;
import org.mongodb.morphia.aggregation.Accumulator;

public class Group {
    private final String name;
    private Accumulator accumulator;
    private String sourceField;

    private Group(String name, Accumulator accumulator) {
        this.name = name;
        this.accumulator = accumulator;
    }

    public Group(String name, String sourceField) {
        this.name = name;
        this.sourceField = "$" + sourceField;
    }

    public static List<Group> id(Group ... fields) {
        return Arrays.asList(fields);
    }

    public static Group grouping(String name) {
        return Group.grouping(name, name);
    }

    public static Group grouping(String name, String sourceField) {
        return new Group(name, sourceField);
    }

    public static Group grouping(String name, Accumulator accumulator) {
        return new Group(name, accumulator);
    }

    public static Accumulator addToSet(String field) {
        return new Accumulator("$addToSet", field);
    }

    public static Accumulator average(String field) {
        return new Accumulator("$avg", field);
    }

    public static Accumulator first(String field) {
        return new Accumulator("$first", field);
    }

    public static Accumulator last(String field) {
        return new Accumulator("$last", field);
    }

    public static Accumulator max(String field) {
        return new Accumulator("$max", field);
    }

    public static Accumulator min(String field) {
        return new Accumulator("$min", field);
    }

    public static Accumulator push(String field) {
        return new Accumulator("$push", field);
    }

    public static Accumulator sum(String field) {
        return new Accumulator("$sum", field);
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceField() {
        return this.sourceField;
    }
}

