/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.mongodb.morphia.converters.BooleanConverter;
import org.mongodb.morphia.converters.ByteConverter;
import org.mongodb.morphia.converters.CharArrayConverter;
import org.mongodb.morphia.converters.CharacterConverter;
import org.mongodb.morphia.converters.ClassConverter;
import org.mongodb.morphia.converters.Converters;
import org.mongodb.morphia.converters.DateConverter;
import org.mongodb.morphia.converters.DoubleConverter;
import org.mongodb.morphia.converters.EnumConverter;
import org.mongodb.morphia.converters.EnumSetConverter;
import org.mongodb.morphia.converters.FloatConverter;
import org.mongodb.morphia.converters.IdentityConverter;
import org.mongodb.morphia.converters.IntegerConverter;
import org.mongodb.morphia.converters.IterableConverter;
import org.mongodb.morphia.converters.KeyConverter;
import org.mongodb.morphia.converters.LocaleConverter;
import org.mongodb.morphia.converters.LongConverter;
import org.mongodb.morphia.converters.MapOfValuesConverter;
import org.mongodb.morphia.converters.ObjectIdConverter;
import org.mongodb.morphia.converters.SerializedObjectConverter;
import org.mongodb.morphia.converters.ShortConverter;
import org.mongodb.morphia.converters.StringConverter;
import org.mongodb.morphia.converters.TimestampConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.converters.URIConverter;
import org.mongodb.morphia.geo.GeometryConverter;
import org.mongodb.morphia.geo.GeometryShapeConverter;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;

public class DefaultConverters
extends Converters {
    private final IdentityConverter identityConverter;
    private final SerializedObjectConverter serializedConverter;

    public DefaultConverters(Mapper mapper) {
        super(mapper);
        this.addConverter(new IdentityConverter(DBObject.class, BasicDBObject.class));
        this.addConverter(new EnumSetConverter());
        this.addConverter(new EnumConverter());
        this.addConverter(new StringConverter());
        this.addConverter(new CharacterConverter());
        this.addConverter(new ByteConverter());
        this.addConverter(new BooleanConverter());
        this.addConverter(new DoubleConverter());
        this.addConverter(new FloatConverter());
        this.addConverter(new LongConverter());
        this.addConverter(new LocaleConverter());
        this.addConverter(new ShortConverter());
        this.addConverter(new IntegerConverter());
        this.addConverter(new CharArrayConverter());
        this.addConverter(new DateConverter());
        this.addConverter(new URIConverter());
        this.addConverter(new KeyConverter());
        this.addConverter(new MapOfValuesConverter());
        this.addConverter(new IterableConverter());
        this.addConverter(new ClassConverter());
        this.addConverter(new ObjectIdConverter());
        this.addConverter(new TimestampConverter());
        this.addConverter(new GeometryShapeConverter.PointConverter());
        this.addConverter(new GeometryShapeConverter.LineStringConverter());
        this.addConverter(new GeometryShapeConverter.MultiPointConverter());
        this.addConverter(new GeometryShapeConverter.MultiLineStringConverter());
        this.addConverter(new GeometryShapeConverter.PolygonConverter());
        this.addConverter(new GeometryShapeConverter.MultiPolygonConverter());
        this.addConverter(new GeometryConverter());
        this.identityConverter = new IdentityConverter(new Class[0]);
        this.serializedConverter = new SerializedObjectConverter();
    }

    @Override
    protected TypeConverter getEncoder(Class c) {
        TypeConverter encoder = super.getEncoder(c);
        if (encoder == null && this.identityConverter.canHandle(c)) {
            encoder = this.identityConverter;
        }
        return encoder;
    }

    @Override
    protected TypeConverter getEncoder(Object val, MappedField mf) {
        if (this.serializedConverter.canHandle(mf)) {
            return this.serializedConverter;
        }
        TypeConverter encoder = super.getEncoder(val, mf);
        if (encoder == null && (this.identityConverter.canHandle(mf) || val != null && this.identityConverter.isSupported((Class)val.getClass(), mf))) {
            encoder = this.identityConverter;
        }
        return encoder;
    }
}

