/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import com.mongodb.DBRef;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.converters.ConverterException;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;

public class KeyConverter
extends TypeConverter {
    public KeyConverter() {
        super(Key.class);
    }

    public Object decode(Class targetClass, Object o, MappedField optionalExtraInfo) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof DBRef)) {
            throw new ConverterException(String.format("cannot convert %s to Key because it isn't a DBRef", o.toString()));
        }
        return this.getMapper().refToKey((DBRef)o);
    }

    @Override
    public Object encode(Object t, MappedField optionalExtraInfo) {
        if (t == null) {
            return null;
        }
        return this.getMapper().keyToDBRef((Key)t);
    }
}

