/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.converters;

import java.util.List;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.utils.ReflectionUtils;

public class StringConverter
extends TypeConverter
implements SimpleValueConverter {
    public StringConverter() {
        super(String.class, String[].class);
    }

    public Object decode(Class targetClass, Object fromDBObject, MappedField optionalExtraInfo) {
        if (fromDBObject == null) {
            return null;
        }
        if (targetClass.equals(fromDBObject.getClass())) {
            return fromDBObject;
        }
        if (fromDBObject instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return ReflectionUtils.convertToArray(type, (List)fromDBObject);
        }
        if (targetClass.equals(String[].class)) {
            return new String[]{fromDBObject.toString()};
        }
        return fromDBObject.toString();
    }
}

