/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.dao;

import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.DatastoreImpl;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.dao.DAO;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryResults;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateResults;

public class BasicDAO<T, K>
implements DAO<T, K> {
    protected Class<T> entityClazz;
    protected DatastoreImpl ds;

    public BasicDAO(Class<T> entityClass, MongoClient mongoClient, Morphia morphia, String dbName) {
        this.initDS(mongoClient, morphia, dbName);
        this.initType(entityClass);
    }

    public BasicDAO(Class<T> entityClass, Datastore ds) {
        this.ds = (DatastoreImpl)ds;
        this.initType(entityClass);
    }

    protected BasicDAO(MongoClient mongoClient, Morphia morphia, String dbName) {
        this.initDS(mongoClient, morphia, dbName);
        this.initType((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    protected BasicDAO(Datastore ds) {
        this.ds = (DatastoreImpl)ds;
        this.initType((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
    }

    @Override
    public long count() {
        return this.ds.getCount(this.entityClazz);
    }

    @Override
    public long count(String key, Object value) {
        return this.count(this.ds.find(this.entityClazz, key, value));
    }

    @Override
    public long count(Query<T> query) {
        return this.ds.getCount(query);
    }

    @Override
    public Query<T> createQuery() {
        return this.ds.createQuery(this.entityClazz);
    }

    @Override
    public UpdateOperations<T> createUpdateOperations() {
        return this.ds.createUpdateOperations(this.entityClazz);
    }

    @Override
    public WriteResult delete(T entity) {
        return this.ds.delete(entity);
    }

    @Override
    public WriteResult delete(T entity, WriteConcern wc) {
        return this.ds.delete(entity, wc);
    }

    @Override
    public WriteResult deleteById(K id) {
        return this.ds.delete(this.entityClazz, id);
    }

    @Override
    public WriteResult deleteByQuery(Query<T> query) {
        return this.ds.delete(query);
    }

    @Override
    public void ensureIndexes() {
        this.ds.ensureIndexes(this.entityClazz);
    }

    @Override
    public boolean exists(String key, Object value) {
        return this.exists(this.ds.find(this.entityClazz, key, value));
    }

    @Override
    public boolean exists(Query<T> query) {
        return this.ds.getCount(query) > 0L;
    }

    @Override
    public QueryResults<T> find() {
        return this.createQuery();
    }

    @Override
    public QueryResults<T> find(Query<T> query) {
        return query;
    }

    @Override
    public List<K> findIds() {
        return this.keysToIds(this.ds.find(this.entityClazz).asKeyList());
    }

    @Override
    public List<K> findIds(String key, Object value) {
        return this.keysToIds(this.ds.find(this.entityClazz, key, value).asKeyList());
    }

    @Override
    public List<K> findIds(Query<T> query) {
        return this.keysToIds(query.asKeyList());
    }

    @Override
    public T findOne(String key, Object value) {
        return this.ds.find(this.entityClazz, key, value).get();
    }

    @Override
    public T findOne(Query<T> query) {
        return query.get();
    }

    @Override
    public Key<T> findOneId() {
        return this.findOneId(this.ds.find(this.entityClazz));
    }

    @Override
    public Key<T> findOneId(String key, Object value) {
        return this.findOneId(this.ds.find(this.entityClazz, key, value));
    }

    @Override
    public Key<T> findOneId(Query<T> query) {
        Iterator keys = query.fetchKeys().iterator();
        return keys.hasNext() ? (Key)keys.next() : null;
    }

    @Override
    public T get(K id) {
        return this.ds.get(this.entityClazz, id);
    }

    @Override
    public DBCollection getCollection() {
        return this.ds.getCollection((Class)this.entityClazz);
    }

    @Override
    public Datastore getDatastore() {
        return this.ds;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClazz;
    }

    @Override
    public Key<T> save(T entity) {
        return this.ds.save(entity);
    }

    @Override
    public Key<T> save(T entity, WriteConcern wc) {
        return this.ds.save(entity, wc);
    }

    @Override
    public UpdateResults update(Query<T> query, UpdateOperations<T> ops) {
        return this.ds.update(query, ops);
    }

    @Override
    public UpdateResults updateFirst(Query<T> query, UpdateOperations<T> ops) {
        return this.ds.updateFirst(query, ops);
    }

    public DatastoreImpl getDs() {
        return this.ds;
    }

    public Class<T> getEntityClazz() {
        return this.entityClazz;
    }

    protected void initDS(MongoClient mongoClient, Morphia mor, String db) {
        this.ds = new DatastoreImpl(mor, mongoClient, db);
    }

    protected void initType(Class<T> type) {
        this.entityClazz = type;
        this.ds.getMapper().addMappedClass(type);
    }

    protected List<?> keysToIds(List<Key<T>> keys) {
        ArrayList<Object> ids = new ArrayList<Object>(keys.size() * 2);
        for (Key<T> key : keys) {
            ids.add(key.getId());
        }
        return ids;
    }
}

