/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping;

import org.mongodb.morphia.ObjectFactory;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.CustomMapper;
import org.mongodb.morphia.mapping.DefaultCreator;
import org.mongodb.morphia.mapping.EmbeddedMapper;
import org.mongodb.morphia.mapping.ReferenceMapper;
import org.mongodb.morphia.mapping.ValueMapper;
import org.mongodb.morphia.mapping.cache.DefaultEntityCacheFactory;
import org.mongodb.morphia.mapping.cache.EntityCacheFactory;
import org.mongodb.morphia.mapping.lazy.DatastoreProvider;

public class MapperOptions {
    private static final Logger LOG = MorphiaLoggerFactory.get(MapperOptions.class);
    private boolean actLikeSerializer;
    private boolean ignoreFinals;
    private boolean storeNulls;
    private boolean storeEmpties;
    private boolean useLowerCaseCollectionNames;
    private boolean cacheClassLookups = false;
    private boolean mapSubPackages = false;
    private ObjectFactory objectFactory = new DefaultCreator(this);
    private EntityCacheFactory cacheFactory = new DefaultEntityCacheFactory();
    private CustomMapper embeddedMapper;
    private CustomMapper defaultMapper = this.embeddedMapper = new EmbeddedMapper();
    private CustomMapper referenceMapper = new ReferenceMapper();
    private CustomMapper valueMapper = new ValueMapper();
    private DatastoreProvider datastoreProvider = null;

    public MapperOptions() {
    }

    public MapperOptions(MapperOptions options) {
        this.setActLikeSerializer(options.isActLikeSerializer());
        this.setIgnoreFinals(options.isIgnoreFinals());
        this.setStoreNulls(options.isStoreNulls());
        this.setStoreEmpties(options.isStoreEmpties());
        this.setUseLowerCaseCollectionNames(options.isUseLowerCaseCollectionNames());
        this.setCacheClassLookups(options.isCacheClassLookups());
        this.setObjectFactory(options.getObjectFactory());
        this.setCacheFactory(options.getCacheFactory());
        this.setEmbeddedMapper(options.getEmbeddedMapper());
        this.setDefaultMapper(options.getDefaultMapper());
        this.setReferenceMapper(options.getReferenceMapper());
        this.setValueMapper(options.getValueMapper());
    }

    public EntityCacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    public void setCacheFactory(EntityCacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public DatastoreProvider getDatastoreProvider() {
        return this.datastoreProvider;
    }

    public void setDatastoreProvider(DatastoreProvider datastoreProvider) {
        LOG.warning("DatastoreProviders are no longer needed or used.");
        this.datastoreProvider = datastoreProvider;
    }

    public CustomMapper getDefaultMapper() {
        return this.defaultMapper;
    }

    public void setDefaultMapper(CustomMapper pDefaultMapper) {
        this.defaultMapper = pDefaultMapper;
    }

    public CustomMapper getEmbeddedMapper() {
        return this.embeddedMapper;
    }

    public void setEmbeddedMapper(CustomMapper pEmbeddedMapper) {
        this.embeddedMapper = pEmbeddedMapper;
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public CustomMapper getReferenceMapper() {
        return this.referenceMapper;
    }

    public void setReferenceMapper(CustomMapper pReferenceMapper) {
        this.referenceMapper = pReferenceMapper;
    }

    public CustomMapper getValueMapper() {
        return this.valueMapper;
    }

    public void setValueMapper(CustomMapper pValueMapper) {
        this.valueMapper = pValueMapper;
    }

    public boolean isActLikeSerializer() {
        return this.actLikeSerializer;
    }

    public void setActLikeSerializer(boolean actLikeSerializer) {
        this.actLikeSerializer = actLikeSerializer;
    }

    public boolean isCacheClassLookups() {
        return this.cacheClassLookups;
    }

    public void setCacheClassLookups(boolean cacheClassLookups) {
        this.cacheClassLookups = cacheClassLookups;
    }

    public boolean isIgnoreFinals() {
        return this.ignoreFinals;
    }

    public void setIgnoreFinals(boolean ignoreFinals) {
        this.ignoreFinals = ignoreFinals;
    }

    public boolean isStoreEmpties() {
        return this.storeEmpties;
    }

    public void setStoreEmpties(boolean storeEmpties) {
        this.storeEmpties = storeEmpties;
    }

    public boolean isStoreNulls() {
        return this.storeNulls;
    }

    public void setStoreNulls(boolean storeNulls) {
        this.storeNulls = storeNulls;
    }

    public boolean isUseLowerCaseCollectionNames() {
        return this.useLowerCaseCollectionNames;
    }

    public void setUseLowerCaseCollectionNames(boolean useLowerCaseCollectionNames) {
        this.useLowerCaseCollectionNames = useLowerCaseCollectionNames;
    }

    public boolean isMapSubPackages() {
        return this.mapSubPackages;
    }

    public void setMapSubPackages(boolean mapSubPackages) {
        this.mapSubPackages = mapSubPackages;
    }
}

