/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.lazy.proxy;

import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.mapping.lazy.proxy.AbstractReference;
import org.mongodb.morphia.mapping.lazy.proxy.LazyReferenceFetchingException;
import org.mongodb.morphia.mapping.lazy.proxy.ProxiedEntityReference;

public class EntityObjectReference
extends AbstractReference
implements ProxiedEntityReference {
    private static final long serialVersionUID = 1L;
    private final Key key;

    public EntityObjectReference(Datastore datastore, Class targetClass, Key key) {
        super(datastore, targetClass, false);
        this.key = key;
    }

    public Key __getKey() {
        return this.key;
    }

    @Override
    protected void beforeWriteObject() {
        this.object = null;
    }

    @Override
    protected Object fetch() {
        Object entity = this.getDatastore().getByKey(this.referenceObjClass, this.key);
        if (entity == null) {
            throw new LazyReferenceFetchingException(String.format("During the lifetime of the proxy, the Entity identified by '%s' disappeared from the Datastore.", this.key));
        }
        return entity;
    }
}

