/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.fieldrules;

import java.util.Set;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.fieldrules.FieldConstraint;

public class LazyReferenceOnArray
extends FieldConstraint {
    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        Class type;
        Reference ref = mf.getAnnotation(Reference.class);
        if (ref != null && ref.lazy() && (type = mf.getType()).isArray()) {
            ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "The lazy attribute cannot be used for an Array. If you need a lazy array please use ArrayList instead."));
        }
    }
}

