/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.fieldrules;

import java.io.Serializable;
import java.util.Set;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.fieldrules.FieldConstraint;
import org.mongodb.morphia.utils.ReflectionUtils;

public class MapNotSerializable
extends FieldConstraint {
    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.isMap() && mf.hasAnnotation(Serialized.class)) {
            Class keyClass = ReflectionUtils.getParameterizedClass(mf.getField(), 0);
            Class valueClass = ReflectionUtils.getParameterizedClass(mf.getField(), 1);
            if (keyClass != null && !Serializable.class.isAssignableFrom(keyClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Key class (" + keyClass.getName() + ") is not Serializable"));
            }
            if (valueClass != null && !Serializable.class.isAssignableFrom(keyClass)) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), "Value class (" + valueClass.getName() + ") is not Serializable"));
            }
        }
    }
}

