/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.mapping.validation.fieldrules;

import java.util.Set;
import org.mongodb.morphia.annotations.Id;
import org.mongodb.morphia.annotations.Reference;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.MappingException;
import org.mongodb.morphia.mapping.validation.ConstraintViolation;
import org.mongodb.morphia.mapping.validation.fieldrules.FieldConstraint;

public class ReferenceToUnidentifiable
extends FieldConstraint {
    @Override
    protected void check(Mapper mapper, MappedClass mc, MappedField mf, Set<ConstraintViolation> ve) {
        if (mf.hasAnnotation(Reference.class)) {
            Class realType;
            Class clazz = realType = mf.isSingleValue() ? mf.getType() : mf.getSubClass();
            if (realType == null) {
                throw new MappingException("Type is null for this MappedField: " + mf);
            }
            if (!realType.isInterface() && mapper.getMappedClass(realType).getIdField() == null) {
                ve.add(new ConstraintViolation(ConstraintViolation.Level.FATAL, mc, mf, this.getClass(), mf.getFullName() + " is annotated as a @" + Reference.class.getSimpleName() + " but the " + mf.getType().getName() + " class is missing the @" + Id.class.getSimpleName() + " annotation"));
            }
        }
    }
}

