/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mongodb.morphia.query.AbstractCriteria;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainer;
import org.mongodb.morphia.query.CriteriaJoin;
import org.mongodb.morphia.query.FieldEnd;
import org.mongodb.morphia.query.FieldEndImpl;
import org.mongodb.morphia.query.QueryImpl;

public class CriteriaContainerImpl
extends AbstractCriteria
implements CriteriaContainer {
    private CriteriaJoin joinMethod;
    private List<Criteria> children;
    private QueryImpl<?> query;

    protected CriteriaContainerImpl(QueryImpl<?> query, CriteriaJoin joinMethod) {
        this(joinMethod);
        this.query = query;
    }

    protected CriteriaContainerImpl(CriteriaJoin joinMethod) {
        this.joinMethod = joinMethod;
        this.children = new ArrayList<Criteria>();
    }

    @Override
    public void add(Criteria ... criteria) {
        for (Criteria c : criteria) {
            c.attach(this);
            this.children.add(c);
        }
    }

    @Override
    public CriteriaContainer and(Criteria ... criteria) {
        return this.collect(CriteriaJoin.AND, criteria);
    }

    @Override
    public FieldEnd<? extends CriteriaContainer> criteria(String name) {
        return this.criteria(name, this.query.isValidatingNames());
    }

    @Override
    public CriteriaContainer or(Criteria ... criteria) {
        return this.collect(CriteriaJoin.OR, criteria);
    }

    @Override
    public void remove(Criteria criteria) {
        this.children.remove(criteria);
    }

    @Override
    public void addTo(DBObject obj) {
        if (this.joinMethod == CriteriaJoin.AND) {
            HashSet<String> fields = new HashSet<String>();
            int nonNullFieldNames = 0;
            for (Criteria criteria : this.children) {
                if (null == criteria.getFieldName()) continue;
                fields.add(criteria.getFieldName());
                ++nonNullFieldNames;
            }
            if (fields.size() < nonNullFieldNames) {
                BasicDBList and = new BasicDBList();
                for (Criteria child : this.children) {
                    BasicDBObject container = new BasicDBObject();
                    child.addTo((DBObject)container);
                    and.add((Object)container);
                }
                obj.put("$and", (Object)and);
            } else {
                for (Criteria criteria : this.children) {
                    criteria.addTo(obj);
                }
            }
        } else if (this.joinMethod == CriteriaJoin.OR) {
            BasicDBList or = new BasicDBList();
            for (Criteria child : this.children) {
                BasicDBObject basicDBObject = new BasicDBObject();
                child.addTo((DBObject)basicDBObject);
                or.add((Object)basicDBObject);
            }
            obj.put("$or", (Object)or);
        }
    }

    @Override
    public String getFieldName() {
        return this.joinMethod.toString();
    }

    public List<Criteria> getChildren() {
        return this.children;
    }

    public void setChildren(List<Criteria> children) {
        this.children = children;
    }

    public CriteriaJoin getJoinMethod() {
        return this.joinMethod;
    }

    public void setJoinMethod(CriteriaJoin joinMethod) {
        this.joinMethod = joinMethod;
    }

    public QueryImpl<?> getQuery() {
        return this.query;
    }

    public void setQuery(QueryImpl<?> query) {
        this.query = query;
    }

    private CriteriaContainer collect(CriteriaJoin cj, Criteria ... criteria) {
        CriteriaContainerImpl parent = new CriteriaContainerImpl(this.query, cj);
        for (Criteria c : criteria) {
            parent.add(c);
        }
        this.add(parent);
        return parent;
    }

    private FieldEnd<? extends CriteriaContainer> criteria(String field, boolean validateName) {
        return new FieldEndImpl<CriteriaContainerImpl>(this.query, field, this, validateName);
    }
}

