/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.cache.EntityCache;

public class MorphiaIterator<T, V>
implements Iterable<V>,
Iterator<V> {
    private final Iterator<DBObject> wrapped;
    private final Mapper mapper;
    private final Class<T> clazz;
    private final String collection;
    private final EntityCache cache;
    private long driverTime;
    private long mapperTime;
    private Datastore datastore;

    public MorphiaIterator(Datastore datastore, Iterator<DBObject> it, Mapper mapper, Class<T> clazz, String collection, EntityCache cache) {
        this.wrapped = it;
        this.mapper = mapper;
        this.clazz = clazz;
        this.collection = collection;
        this.cache = cache;
        this.datastore = datastore;
    }

    public void close() {
        if (this.wrapped != null && this.wrapped instanceof DBCursor) {
            ((DBCursor)this.wrapped).close();
        }
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getCollection() {
        return this.collection;
    }

    public DBCursor getCursor() {
        return (DBCursor)this.wrapped;
    }

    public long getDriverTime() {
        return this.driverTime;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public long getMapperTime() {
        return this.mapperTime;
    }

    @Override
    public boolean hasNext() {
        if (this.wrapped == null) {
            return false;
        }
        long start = System.currentTimeMillis();
        boolean ret = this.wrapped.hasNext();
        this.driverTime += System.currentTimeMillis() - start;
        return ret;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DBObject dbObj = this.getNext();
        return this.processItem(dbObj);
    }

    @Override
    public void remove() {
        long start = System.currentTimeMillis();
        this.wrapped.remove();
        this.driverTime += System.currentTimeMillis() - start;
    }

    @Override
    public Iterator<V> iterator() {
        return this;
    }

    protected V convertItem(DBObject dbObj) {
        return (V)this.mapper.fromDBObject(this.datastore, this.clazz, dbObj, this.cache);
    }

    protected DBObject getNext() {
        long start = System.currentTimeMillis();
        DBObject dbObj = this.wrapped.next();
        this.driverTime += System.currentTimeMillis() - start;
        return dbObj;
    }

    protected V processItem(DBObject dbObj) {
        long start = System.currentTimeMillis();
        V item = this.convertItem(dbObj);
        this.mapperTime += System.currentTimeMillis() - start;
        return item;
    }
}

