/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BSONObject;
import org.bson.types.CodeWScope;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.DatastoreImpl;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.mapping.cache.EntityCache;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.CriteriaContainerImpl;
import org.mongodb.morphia.query.CriteriaJoin;
import org.mongodb.morphia.query.FieldCriteria;
import org.mongodb.morphia.query.FieldEnd;
import org.mongodb.morphia.query.FieldEndImpl;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.MorphiaIterator;
import org.mongodb.morphia.query.MorphiaKeyIterator;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.QueryException;
import org.mongodb.morphia.query.QueryValidator;
import org.mongodb.morphia.query.WhereCriteria;

public class QueryImpl<T>
extends CriteriaContainerImpl
implements Query<T> {
    private static final Logger LOG = MorphiaLoggerFactory.get(QueryImpl.class);
    private final DatastoreImpl ds;
    private final DBCollection dbColl;
    private final Class<T> clazz;
    private EntityCache cache;
    private boolean validateName = true;
    private boolean validateType = true;
    private String[] fields;
    private Boolean includeFields;
    private BasicDBObject sort;
    private BasicDBObject max;
    private BasicDBObject min;
    private int offset;
    private int limit = -1;
    private int batchSize;
    private String indexHint;
    private BasicDBObject baseQuery;
    private boolean snapshotted;
    private boolean noTimeout;
    private boolean tail;
    private boolean tailAwaitData;
    private ReadPreference readPref;
    private Integer maxScan;
    private Long maxTime;
    private TimeUnit maxTimeUnit;
    private String comment;
    private boolean returnKey;

    public QueryImpl(Class<T> clazz, DBCollection coll, Datastore ds) {
        super(CriteriaJoin.AND);
        Entity entAn;
        this.setQuery(this);
        this.clazz = clazz;
        this.ds = (DatastoreImpl)ds;
        this.dbColl = coll;
        this.cache = this.ds.getMapper().createEntityCache();
        MappedClass mc = this.ds.getMapper().getMappedClass(clazz);
        Entity entity = entAn = mc == null ? null : mc.getEntityAnnotation();
        if (entAn != null) {
            this.readPref = this.ds.getMapper().getMappedClass(clazz).getEntityAnnotation().queryNonPrimary() ? ReadPreference.secondaryPreferred() : null;
        }
    }

    public static BasicDBObject parseFieldsString(String str, Class clazz, Mapper mapper, boolean validate, List<MappedClass> parentMCs, List<MappedField> parentMFs) {
        String[] parts;
        BasicDBObjectBuilder ret = BasicDBObjectBuilder.start();
        for (String s : parts = str.split(",")) {
            s = s.trim();
            int dir = 1;
            if (s.startsWith("-")) {
                dir = -1;
                s = s.substring(1).trim();
            }
            if (validate) {
                StringBuilder sb = new StringBuilder(s);
                QueryValidator.validateQuery(clazz, mapper, sb, FilterOperator.IN, "", true, false);
                s = sb.toString();
            }
            ret = ret.add(s, (Object)dir);
        }
        return (BasicDBObject)ret.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Key<T>> asKeyList() {
        ArrayList<Key<T>> results = new ArrayList<Key<T>>();
        MorphiaKeyIterator<T> keys = this.fetchKeys();
        try {
            for (Key key : keys) {
                results.add(key);
            }
        }
        finally {
            keys.close();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> asList() {
        ArrayList<T> results = new ArrayList<T>();
        MorphiaIterator<T, T> iter = this.fetch();
        try {
            for (T ent : iter) {
                results.add(ent);
            }
        }
        finally {
            iter.close();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("asList: %s \t %d entities, iterator time: driver %d ms, mapper %d ms %n\t cache: %s %n\t for %s", this.dbColl.getName(), results.size(), iter.getDriverTime(), iter.getMapperTime(), this.cache.stats(), this.getQueryObject()));
        }
        return results;
    }

    @Override
    public long countAll() {
        DBObject query = this.getQueryObject();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing count(" + this.dbColl.getName() + ") for query: " + query);
        }
        return this.dbColl.getCount(query);
    }

    @Override
    public MorphiaIterator<T, T> fetch() {
        DBCursor cursor = this.prepareCursor();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting cursor(" + this.dbColl.getName() + ")  for query:" + cursor.getQuery());
        }
        return new MorphiaIterator(this.ds, (Iterator<DBObject>)cursor, this.ds.getMapper(), this.clazz, this.dbColl.getName(), this.cache);
    }

    @Override
    public MorphiaIterator<T, T> fetchEmptyEntities() {
        String[] oldFields = this.fields;
        Boolean oldInclude = this.includeFields;
        this.fields = new String[]{"_id"};
        this.includeFields = true;
        MorphiaIterator<T, T> res = this.fetch();
        this.fields = oldFields;
        this.includeFields = oldInclude;
        return res;
    }

    @Override
    public MorphiaKeyIterator<T> fetchKeys() {
        String[] oldFields = this.fields;
        Boolean oldInclude = this.includeFields;
        this.fields = new String[]{"_id"};
        this.includeFields = true;
        DBCursor cursor = this.prepareCursor();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting cursor(" + this.dbColl.getName() + ") for query:" + cursor.getQuery());
        }
        this.fields = oldFields;
        this.includeFields = oldInclude;
        return new MorphiaKeyIterator<T>(this.ds, cursor, this.ds.getMapper(), this.clazz, this.dbColl.getName());
    }

    @Override
    public T get() {
        int oldLimit = this.limit;
        this.limit = 1;
        Iterator<T> it = this.fetch().iterator();
        this.limit = oldLimit;
        return it.hasNext() ? (T)it.next() : null;
    }

    @Override
    public Key<T> getKey() {
        int oldLimit = this.limit;
        this.limit = 1;
        Iterator it = this.fetchKeys().iterator();
        this.limit = oldLimit;
        return it.hasNext() ? (Key)it.next() : null;
    }

    @Override
    public MorphiaIterator<T, T> tail() {
        return this.tail(true);
    }

    @Override
    public MorphiaIterator<T, T> tail(boolean awaitData) {
        Query tailQ = this.cloneQuery();
        ((QueryImpl)tailQ).tail = true;
        ((QueryImpl)tailQ).tailAwaitData = awaitData;
        return ((QueryImpl)tailQ).fetch();
    }

    @Override
    public Query<T> batchSize(int value) {
        this.batchSize = value;
        return this;
    }

    @Override
    public QueryImpl<T> cloneQuery() {
        QueryImpl<T> n = new QueryImpl<T>(this.clazz, this.dbColl, this.ds);
        n.batchSize = this.batchSize;
        n.cache = this.ds.getMapper().createEntityCache();
        n.fields = this.fields == null ? null : this.copy();
        n.includeFields = this.includeFields;
        n.indexHint = this.indexHint;
        n.limit = this.limit;
        n.noTimeout = this.noTimeout;
        n.setQuery(n);
        n.offset = this.offset;
        n.readPref = this.readPref;
        n.snapshotted = this.snapshotted;
        n.validateName = this.validateName;
        n.validateType = this.validateType;
        n.sort = (BasicDBObject)(this.sort == null ? null : this.sort.clone());
        n.max = this.max;
        n.min = this.min;
        n.baseQuery = (BasicDBObject)(this.baseQuery == null ? null : this.baseQuery.clone());
        n.setAttachedTo(this.getAttachedTo());
        n.setChildren((List<Criteria>)(this.getChildren() == null ? null : new ArrayList<Criteria>(this.getChildren())));
        n.tail = this.tail;
        n.tailAwaitData = this.tailAwaitData;
        return n;
    }

    @Override
    public Query<T> comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Query<T> disableCursorTimeout() {
        this.noTimeout = true;
        return this;
    }

    @Override
    public Query<T> disableSnapshotMode() {
        this.snapshotted = false;
        return this;
    }

    @Override
    public Query<T> disableValidation() {
        this.validateName = false;
        this.validateType = false;
        return this;
    }

    @Override
    public Query<T> enableCursorTimeout() {
        this.noTimeout = false;
        return this;
    }

    @Override
    public Query<T> enableSnapshotMode() {
        this.snapshotted = true;
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validateName = true;
        this.validateType = true;
        return this;
    }

    @Override
    public Map<String, Object> explain() {
        DBCursor cursor = this.prepareCursor();
        return (BasicDBObject)cursor.explain();
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        return this.field(name, this.validateName);
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        String prop = parts[0].trim();
        FilterOperator op = parts.length == 2 ? this.translate(parts[1]) : FilterOperator.EQUAL;
        this.add(new FieldCriteria(this, prop, op, value, this.validateName, this.validateType));
        return this;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public DBCollection getCollection() {
        return this.dbColl;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.clazz;
    }

    @Override
    public DBObject getFieldsObject() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        HashMap<String, Integer> fieldsFilter = new HashMap<String, Integer>();
        for (String field : this.fields) {
            StringBuilder sb = new StringBuilder(field);
            QueryValidator.validateQuery(this.clazz, this.ds.getMapper(), sb, FilterOperator.EQUAL, null, this.validateName, false);
            field = sb.toString();
            fieldsFilter.put(field, this.includeFields != false ? 1 : 0);
        }
        MappedClass mc = this.ds.getMapper().getMappedClass(this.clazz);
        Entity entityAnnotation = mc.getEntityAnnotation();
        if (this.includeFields.booleanValue() && entityAnnotation != null && !entityAnnotation.noClassnameStored()) {
            fieldsFilter.put("className", 1);
        }
        return new BasicDBObject(fieldsFilter);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public DBObject getQueryObject() {
        BasicDBObject obj = new BasicDBObject();
        if (this.baseQuery != null) {
            obj.putAll((BSONObject)this.baseQuery);
        }
        this.addTo((DBObject)obj);
        return obj;
    }

    public void setQueryObject(DBObject query) {
        this.baseQuery = (BasicDBObject)query;
    }

    @Override
    public DBObject getSortObject() {
        return this.sort == null ? null : this.sort;
    }

    @Override
    public Query<T> hintIndex(String idxName) {
        this.indexHint = idxName;
        return this;
    }

    @Override
    public Query<T> limit(int value) {
        this.limit = value;
        return this;
    }

    @Override
    public Query<T> lowerIndexBound(DBObject lowerBound) {
        if (lowerBound != null) {
            this.min = new BasicDBObject(lowerBound.toMap());
        }
        return this;
    }

    @Override
    public Query<T> maxScan(int value) {
        this.maxScan = value > 0 ? Integer.valueOf(value) : null;
        return this;
    }

    @Override
    public Query<T> maxTime(long value, TimeUnit timeUnitValue) {
        this.maxTime = value > 0L ? Long.valueOf(value) : null;
        this.maxTimeUnit = timeUnitValue;
        return this;
    }

    @Override
    public Query<T> offset(int value) {
        this.offset = value;
        return this;
    }

    @Override
    public Query<T> order(String sort) {
        if (this.snapshotted) {
            throw new QueryException("order cannot be used on a snapshotted query.");
        }
        this.sort = QueryImpl.parseFieldsString(sort, this.clazz, this.ds.getMapper(), this.validateName, Collections.<MappedClass>emptyList(), Collections.<MappedField>emptyList());
        return this;
    }

    @Override
    public Query<T> queryNonPrimary() {
        this.readPref = ReadPreference.secondary();
        return this;
    }

    @Override
    public Query<T> queryPrimaryOnly() {
        this.readPref = ReadPreference.primary();
        return this;
    }

    @Override
    public Query<T> retrieveKnownFields() {
        MappedClass mc = this.ds.getMapper().getMappedClass(this.clazz);
        ArrayList<String> fields = new ArrayList<String>(mc.getPersistenceFields().size() + 1);
        for (MappedField mf : mc.getPersistenceFields()) {
            fields.add(mf.getNameToStore());
        }
        this.retrievedFields(true, fields.toArray(new String[fields.size()]));
        return this;
    }

    @Override
    public Query<T> retrievedFields(boolean include, String ... list) {
        if (this.includeFields != null && include != this.includeFields) {
            throw new IllegalStateException("You cannot mix include and excluded fields together!");
        }
        this.includeFields = include;
        this.fields = list;
        return this;
    }

    @Override
    public Query<T> returnKey() {
        this.returnKey = true;
        return this;
    }

    @Override
    public Query<T> search(String search) {
        BasicDBObject op = new BasicDBObject("$search", (Object)search);
        this.criteria("$text", false).equal(op);
        return this;
    }

    @Override
    public Query<T> search(String search, String language) {
        BasicDBObject op = new BasicDBObject("$search", (Object)search).append("$language", (Object)language);
        this.criteria("$text", false).equal(op);
        return this;
    }

    @Override
    public Query<T> upperIndexBound(DBObject upperBound) {
        if (upperBound != null) {
            this.max = new BasicDBObject(upperBound.toMap());
        }
        return this;
    }

    @Override
    public Query<T> useReadPreference(ReadPreference readPref) {
        this.readPref = readPref;
        return this;
    }

    @Override
    public Query<T> where(String js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public Query<T> where(CodeWScope js) {
        this.add(new WhereCriteria(js));
        return this;
    }

    @Override
    public FieldEnd<? extends CriteriaContainerImpl> criteria(String field) {
        return this.criteria(field, this.validateName);
    }

    @Override
    public String getFieldName() {
        return null;
    }

    public DatastoreImpl getDatastore() {
        return this.ds;
    }

    public boolean isValidatingNames() {
        return this.validateName;
    }

    public boolean isValidatingTypes() {
        return this.validateType;
    }

    public MorphiaIterator<T, T> iterator() {
        return this.fetch();
    }

    public DBCursor prepareCursor() {
        DBObject query = this.getQueryObject();
        DBObject fields = this.getFieldsObject();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Running query(" + this.dbColl.getName() + ") : " + query + ", fields:" + fields + ",off:" + this.offset + ",limit:" + this.limit);
        }
        DBCursor cursor = this.dbColl.find(query, fields);
        cursor.setDecoderFactory(this.ds.getDecoderFact());
        if (this.offset > 0) {
            cursor.skip(this.offset);
        }
        if (this.limit > 0) {
            cursor.limit(this.limit);
        }
        if (this.batchSize != 0) {
            cursor.batchSize(this.batchSize);
        }
        if (this.snapshotted) {
            cursor.snapshot();
        }
        if (this.sort != null) {
            cursor.sort((DBObject)this.sort);
        }
        if (this.indexHint != null) {
            cursor.hint(this.indexHint);
        }
        if (null != this.readPref) {
            cursor.setReadPreference(this.readPref);
        }
        if (this.noTimeout) {
            cursor.addOption(16);
        }
        if (this.tail) {
            cursor.addOption(2);
            if (this.tailAwaitData) {
                cursor.addOption(32);
            }
        }
        if (this.snapshotted && (this.sort != null || this.indexHint != null)) {
            LOG.warning("Snapshotted query should not have hint/sort.");
        }
        if (this.tail && this.sort != null) {
            LOG.warning("Sorting on tail is not allowed.");
        }
        if (this.maxScan != null) {
            cursor.addSpecial("$maxScan", (Object)this.maxScan);
        }
        if (this.maxTime != null && this.maxTimeUnit != null) {
            cursor.maxTime(this.maxTime.longValue(), this.maxTimeUnit);
        }
        if (this.max != null) {
            cursor.addSpecial("$max", (Object)this.max);
        }
        if (this.min != null) {
            cursor.addSpecial("$min", (Object)this.min);
        }
        if (this.comment != null) {
            cursor.addSpecial("$comment", (Object)this.comment);
        }
        if (this.returnKey) {
            cursor.returnKey();
        }
        return cursor;
    }

    @Override
    public String toString() {
        return this.getQueryObject().toString();
    }

    protected FilterOperator translate(String operator) {
        return FilterOperator.fromString(operator);
    }

    private String[] copy() {
        String[] copy = new String[this.fields.length];
        System.arraycopy(this.fields, 0, copy, 0, this.fields.length);
        return copy;
    }

    private FieldEnd<? extends Query<T>> field(String field, boolean validate) {
        return new FieldEndImpl<QueryImpl>(this, field, this, validate);
    }

    FieldEnd<? extends CriteriaContainerImpl> criteria(String field, boolean validate) {
        CriteriaContainerImpl container = new CriteriaContainerImpl(this, CriteriaJoin.AND);
        this.add(container);
        return new FieldEndImpl<CriteriaContainerImpl>(this, field, container, validate);
    }
}

