/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import java.util.ArrayList;
import java.util.List;
import org.mongodb.morphia.annotations.Serialized;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappedClass;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.ValidationException;
import org.mongodb.morphia.query.validation.AllOperationValidator;
import org.mongodb.morphia.query.validation.DefaultTypeValidator;
import org.mongodb.morphia.query.validation.DoubleTypeValidator;
import org.mongodb.morphia.query.validation.EntityAnnotatedValueValidator;
import org.mongodb.morphia.query.validation.EntityTypeAndIdValueValidator;
import org.mongodb.morphia.query.validation.ExistsOperationValidator;
import org.mongodb.morphia.query.validation.GeoWithinOperationValidator;
import org.mongodb.morphia.query.validation.InOperationValidator;
import org.mongodb.morphia.query.validation.IntegerTypeValidator;
import org.mongodb.morphia.query.validation.KeyValueTypeValidator;
import org.mongodb.morphia.query.validation.ListValueValidator;
import org.mongodb.morphia.query.validation.LongTypeValidator;
import org.mongodb.morphia.query.validation.ModOperationValidator;
import org.mongodb.morphia.query.validation.NotInOperationValidator;
import org.mongodb.morphia.query.validation.PatternValueValidator;
import org.mongodb.morphia.query.validation.SizeOperationValidator;
import org.mongodb.morphia.query.validation.ValidationFailure;

final class QueryValidator {
    private static final Logger LOG = MorphiaLoggerFactory.get(QueryValidator.class);

    private QueryValidator() {
    }

    static MappedField validateQuery(Class clazz, Mapper mapper, StringBuilder origProp, FilterOperator op, Object val, boolean validateNames, boolean validateTypes) {
        MappedField mf = null;
        String prop = origProp.toString();
        boolean hasTranslations = false;
        if (!origProp.substring(0, 1).equals("$")) {
            String[] parts = prop.split("\\.");
            if (clazz == null) {
                return null;
            }
            MappedClass mc = mapper.getMappedClass(clazz);
            int i = 0;
            while (true) {
                String part = parts[i];
                boolean fieldIsArrayOperator = part.equals("$");
                mf = mc.getMappedField(part);
                if (mf == null && !fieldIsArrayOperator) {
                    mf = mc.getMappedFieldByJavaField(part);
                    if (validateNames && mf == null) {
                        throw new ValidationException(String.format("The field '%s' could not be found in '%s' while validating - %s; if you wish to continue please disable validation.", part, mc.getClazz().getName(), prop));
                    }
                    hasTranslations = true;
                    if (mf != null) {
                        parts[i] = mf.getNameToStore();
                    }
                }
                ++i;
                if (mf != null && mf.isMap()) {
                    ++i;
                }
                if (i >= parts.length) break;
                if (fieldIsArrayOperator) continue;
                if (validateNames && !QueryValidator.canQueryPast(mf)) {
                    throw new ValidationException(String.format("Cannot use dot-notation past '%s' in '%s'; found while validating - %s", part, mc.getClazz().getName(), prop));
                }
                if (mf == null && mc.isInterface()) break;
                if (mf == null) {
                    throw new ValidationException(String.format("The field '%s' could not be found in '%s'", prop, mc.getClazz().getName()));
                }
                mc = mapper.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass());
            }
            if (hasTranslations) {
                origProp.setLength(0);
                origProp.append(parts[0]);
                for (i = 1; i < parts.length; ++i) {
                    origProp.append('.');
                    origProp.append(parts[i]);
                }
            }
            if (validateTypes && mf != null) {
                ArrayList<ValidationFailure> typeValidationFailures = new ArrayList<ValidationFailure>();
                boolean compatibleForType = QueryValidator.isCompatibleForOperator(mc, mf, mf.getType(), op, val, typeValidationFailures);
                ArrayList<ValidationFailure> subclassValidationFailures = new ArrayList<ValidationFailure>();
                boolean compatibleForSubclass = QueryValidator.isCompatibleForOperator(mc, mf, mf.getSubClass(), op, val, subclassValidationFailures);
                if ((mf.isSingleValue() && !compatibleForType || mf.isMultipleValues() && !compatibleForSubclass && !compatibleForType) && LOG.isWarningEnabled()) {
                    LOG.warning(String.format("The type(s) for the query/update may be inconsistent; using an instance of type '%s' for the field '%s.%s' which is declared as '%s'", val.getClass().getName(), mf.getDeclaringClass().getName(), mf.getJavaFieldName(), mf.getType().getName()));
                    typeValidationFailures.addAll(subclassValidationFailures);
                    LOG.warning("Validation warnings: \n" + typeValidationFailures);
                }
            }
        }
        return mf;
    }

    private static boolean canQueryPast(MappedField mf) {
        return !mf.isReference() && !mf.hasAnnotation(Serialized.class);
    }

    static boolean isCompatibleForOperator(MappedClass mappedClass, MappedField mappedField, Class<?> type, FilterOperator op, Object value, List<ValidationFailure> validationFailures) {
        if (value == null || type == null) {
            return true;
        }
        boolean validationApplied = ExistsOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || SizeOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || InOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || NotInOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || ModOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || GeoWithinOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || AllOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || KeyValueTypeValidator.getInstance().apply(type, value, validationFailures) || IntegerTypeValidator.getInstance().apply(type, value, validationFailures) || LongTypeValidator.getInstance().apply(type, value, validationFailures) || DoubleTypeValidator.getInstance().apply(type, value, validationFailures) || PatternValueValidator.getInstance().apply(type, value, validationFailures) || EntityAnnotatedValueValidator.getInstance().apply(type, value, validationFailures) || ListValueValidator.getInstance().apply(type, value, validationFailures) || EntityTypeAndIdValueValidator.getInstance().apply(mappedClass, mappedField, value, validationFailures) || DefaultTypeValidator.getInstance().apply(type, value, validationFailures);
        return validationApplied && validationFailures.size() == 0;
    }
}

