/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.QueryException;
import org.mongodb.morphia.query.QueryValidator;
import org.mongodb.morphia.query.UpdateOperations;
import org.mongodb.morphia.query.UpdateOperator;

public class UpdateOpsImpl<T>
implements UpdateOperations<T> {
    private final Mapper mapper;
    private final Class<T> clazz;
    private Map<String, Map<String, Object>> ops = new HashMap<String, Map<String, Object>>();
    private boolean validateNames = true;
    private boolean validateTypes = true;
    private boolean isolated;

    public UpdateOpsImpl(Class<T> type, Mapper mapper) {
        this.mapper = mapper;
        this.clazz = type;
    }

    @Override
    public UpdateOperations<T> add(String fieldExpr, Object value) {
        return this.add(fieldExpr, value, false);
    }

    @Override
    public UpdateOperations<T> add(String fieldExpr, Object value, boolean addDups) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(addDups ? UpdateOperator.PUSH : UpdateOperator.ADD_TO_SET, fieldExpr, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> addAll(String fieldExpr, List<?> values, boolean addDups) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Values cannot be null or empty.");
        }
        if (addDups) {
            this.add(UpdateOperator.PUSH_ALL, fieldExpr, values, true);
        } else {
            this.add(UpdateOperator.ADD_TO_SET_EACH, fieldExpr, values, true);
        }
        return this;
    }

    @Override
    public UpdateOperations<T> dec(String field) {
        return this.inc(field, -1);
    }

    @Override
    public UpdateOperations<T> disableValidation() {
        this.validateNames = false;
        this.validateTypes = false;
        return this;
    }

    @Override
    public UpdateOperations<T> enableValidation() {
        this.validateNames = true;
        this.validateTypes = true;
        return this;
    }

    @Override
    public UpdateOperations<T> inc(String field) {
        return this.inc(field, 1);
    }

    @Override
    public UpdateOperations<T> inc(String field, Number value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.INC, field, value, false);
        return this;
    }

    @Override
    public UpdateOperations<T> isolated() {
        this.isolated = true;
        return this;
    }

    @Override
    public UpdateOperations<T> max(String field, Number value) {
        this.add(UpdateOperator.MAX, field, value, false);
        return this;
    }

    @Override
    public UpdateOperations<T> min(String field, Number value) {
        this.add(UpdateOperator.MIN, field, value, false);
        return this;
    }

    @Override
    public UpdateOperations<T> removeAll(String field, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.PULL, field, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> removeAll(String field, List<?> values) {
        if (values == null || values.isEmpty()) {
            throw new QueryException("Value cannot be null or empty.");
        }
        this.add(UpdateOperator.PULL_ALL, field, values, true);
        return this;
    }

    @Override
    public UpdateOperations<T> removeFirst(String field) {
        return this.remove(field, true);
    }

    @Override
    public UpdateOperations<T> removeLast(String field) {
        return this.remove(field, false);
    }

    @Override
    public UpdateOperations<T> set(String field, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.SET, field, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> setOnInsert(String field, Object value) {
        if (value == null) {
            throw new QueryException("Value cannot be null.");
        }
        this.add(UpdateOperator.SET_ON_INSERT, field, value, true);
        return this;
    }

    @Override
    public UpdateOperations<T> unset(String field) {
        this.add(UpdateOperator.UNSET, field, 1, false);
        return this;
    }

    public DBObject getOps() {
        return new BasicDBObject(this.ops);
    }

    public void setOps(DBObject ops) {
        this.ops = (Map)ops;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    protected void add(UpdateOperator op, String f, Object value, boolean convert) {
        String opString;
        if (value == null) {
            throw new QueryException("Val cannot be null");
        }
        Object val = null;
        MappedField mf = null;
        StringBuilder sb = new StringBuilder(f);
        if (this.validateNames || this.validateTypes) {
            mf = QueryValidator.validateQuery(this.clazz, this.mapper, sb, FilterOperator.EQUAL, val, this.validateNames, this.validateTypes);
        }
        if (convert) {
            val = UpdateOperator.PULL_ALL.equals((Object)op) && value instanceof List ? this.toDBObjList(mf, value) : this.mapper.toMongoObject(mf, null, value);
        }
        if (UpdateOperator.ADD_TO_SET_EACH.equals((Object)op)) {
            val = new BasicDBObject(UpdateOperator.EACH.val(), val);
        }
        if (val == null) {
            val = value;
        }
        if (!this.ops.containsKey(opString = op.val())) {
            this.ops.put(opString, new HashMap());
        }
        this.ops.get(opString).put(sb.toString(), val);
    }

    protected UpdateOperations<T> remove(String fieldExpr, boolean firstNotLast) {
        this.add(UpdateOperator.POP, fieldExpr, firstNotLast ? -1 : 1, false);
        return this;
    }

    protected List<Object> toDBObjList(MappedField mf, List<?> values) {
        ArrayList<Object> list = new ArrayList<Object>(values.size());
        for (Object obj : values) {
            list.add(this.mapper.toMongoObject(mf, null, obj));
        }
        return list;
    }
}

