/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query.validation;

import com.mongodb.DBObject;
import java.util.List;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.query.FilterOperator;
import org.mongodb.morphia.query.validation.MappedFieldTypeValidator;
import org.mongodb.morphia.query.validation.OperationValidator;
import org.mongodb.morphia.query.validation.ValidationFailure;

public final class GeoWithinOperationValidator
extends OperationValidator {
    private static final GeoWithinOperationValidator INSTANCE = new GeoWithinOperationValidator();

    private GeoWithinOperationValidator() {
    }

    public static GeoWithinOperationValidator getInstance() {
        return INSTANCE;
    }

    private static boolean isValueAValidGeoQuery(Object value) {
        if (value instanceof DBObject) {
            String key = (String)((DBObject)value).keySet().iterator().next();
            return key.equals("$box") || key.equals("$center") || key.equals("$centerSphere") || key.equals("$polygon");
        }
        return false;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.GEO_WITHIN;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (!MappedFieldTypeValidator.isArrayOfNumbers(mappedField) && !MappedFieldTypeValidator.isIterableOfNumbers(mappedField)) {
            validationFailures.add(new ValidationFailure(String.format("For a $geoWithin operation, if field '%s' is an array or iterable it should have numeric values. Instead it had: %s", mappedField, mappedField.getSubClass())));
        }
        if (!GeoWithinOperationValidator.isValueAValidGeoQuery(value)) {
            validationFailures.add(new ValidationFailure(String.format("For a $geoWithin operation, the value should be a valid geo query. Instead it was: %s", value)));
        }
    }
}

