/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.query.validation;

import java.util.List;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.query.validation.ValidationFailure;
import org.mongodb.morphia.query.validation.ValueValidator;

public final class KeyValueTypeValidator
extends ValueValidator {
    private static final KeyValueTypeValidator INSTANCE = new KeyValueTypeValidator();

    private KeyValueTypeValidator() {
    }

    public static KeyValueTypeValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected Class<?> getRequiredValueType() {
        return Key.class;
    }

    @Override
    protected void validate(Class<?> type, Object value, List<ValidationFailure> validationFailures) {
        if (!type.equals(((Key)value).getType()) && !type.equals(Key.class)) {
            validationFailures.add(new ValidationFailure(String.format("When value is a Key, the type needs to be the right kind of class. Type was %s and value was '%s'", type, value)));
        }
    }
}

