/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.bson.types.CodeWScope;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Key;
import org.mongodb.morphia.annotations.Embedded;
import org.mongodb.morphia.annotations.Entity;
import org.mongodb.morphia.logging.Logger;
import org.mongodb.morphia.logging.MorphiaLoggerFactory;
import org.mongodb.morphia.mapping.MappingException;

public final class ReflectionUtils {
    private static final Logger LOG = MorphiaLoggerFactory.get(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static Field[] getDeclaredAndInheritedFields(Class type, boolean returnFinalFields) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(ReflectionUtils.getValidFields(type.getDeclaredFields(), returnFinalFields));
        for (Class parent = type.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            allFields.addAll(ReflectionUtils.getValidFields(parent.getDeclaredFields(), returnFinalFields));
        }
        return allFields.toArray(new Field[allFields.size()]);
    }

    public static List<Field> getValidFields(Field[] fields, boolean returnFinalFields) {
        ArrayList<Field> validFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || !returnFinalFields && Modifier.isFinal(field.getModifiers())) continue;
            validFields.add(field);
        }
        return validFields;
    }

    public static List<Method> getDeclaredAndInheritedMethods(Class type) {
        return ReflectionUtils.getDeclaredAndInheritedMethods(type, new ArrayList<Method>());
    }

    private static List<Method> getDeclaredAndInheritedMethods(Class type, List<Method> methods) {
        if (type == null || type == Object.class) {
            return methods;
        }
        Class parent = type.getSuperclass();
        List<Method> list = ReflectionUtils.getDeclaredAndInheritedMethods(parent, methods == null ? new ArrayList() : methods);
        for (Method m : type.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers())) continue;
            list.add(m);
        }
        return list;
    }

    public static boolean isIntegerType(Class type) {
        return Arrays.asList(Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE).contains(type);
    }

    public static boolean isPropertyType(Type type) {
        if (type instanceof GenericArrayType) {
            return ReflectionUtils.isPropertyType(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.isPropertyType(((ParameterizedType)type).getRawType());
        }
        return type instanceof Class && ReflectionUtils.isPropertyType((Class)type);
    }

    public static Class getParameterizedClass(Field field) {
        return ReflectionUtils.getParameterizedClass(field, 0);
    }

    public static Class getParameterizedClass(Field field, int index) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            if (type.getActualTypeArguments() != null && type.getActualTypeArguments().length <= index) {
                return null;
            }
            Type paramType = type.getActualTypeArguments()[index];
            if (paramType instanceof GenericArrayType) {
                Class arrayType = (Class)((GenericArrayType)paramType).getGenericComponentType();
                return Array.newInstance(arrayType, 0).getClass();
            }
            if (paramType instanceof ParameterizedType) {
                ParameterizedType paramPType = (ParameterizedType)paramType;
                return (Class)paramPType.getRawType();
            }
            if (paramType instanceof TypeVariable) {
                throw new MappingException("Generic Typed Class not supported:  <" + ((TypeVariable)paramType).getName() + "> = " + ((TypeVariable)paramType).getBounds()[0]);
            }
            if (paramType instanceof Class) {
                return (Class)paramType;
            }
            throw new MappingException("Unknown type... pretty bad... call for help, wave your hands... yeah!");
        }
        return ReflectionUtils.getParameterizedClass(field.getType());
    }

    public static Type getParameterizedType(Field field, int index) {
        if (field != null) {
            if (field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)field.getGenericType();
                if (type.getActualTypeArguments() != null && type.getActualTypeArguments().length <= index) {
                    return null;
                }
                Type paramType = type.getActualTypeArguments()[index];
                if (paramType instanceof GenericArrayType) {
                    return paramType;
                }
                if (paramType instanceof ParameterizedType) {
                    return paramType;
                }
                if (paramType instanceof TypeVariable) {
                    return paramType;
                }
                if (paramType instanceof WildcardType) {
                    return paramType;
                }
                if (paramType instanceof Class) {
                    return paramType;
                }
                throw new MappingException("Unknown type... pretty bad... call for help, wave your hands... yeah!");
            }
            return ReflectionUtils.getParameterizedClass(field.getType());
        }
        return null;
    }

    public static Class getParameterizedClass(Class c) {
        return ReflectionUtils.getParameterizedClass(c, 0);
    }

    public static Class getParameterizedClass(Class c, int index) {
        Type[] interfaces;
        TypeVariable<Class<T>>[] typeVars = c.getTypeParameters();
        if (typeVars.length > 0) {
            TypeVariable typeVariable = typeVars[index];
            Type[] bounds = typeVariable.getBounds();
            Type type = bounds[0];
            if (type instanceof Class) {
                return (Class)type;
            }
            return null;
        }
        Type superclass = c.getGenericSuperclass();
        if (superclass == null && c.isInterface() && (interfaces = c.getGenericInterfaces()).length > 0) {
            superclass = interfaces[index];
        }
        if (superclass instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)superclass).getActualTypeArguments();
            return actualTypeArguments.length > index ? (Class)actualTypeArguments[index] : null;
        }
        if (!Object.class.equals((Object)superclass)) {
            return ReflectionUtils.getParameterizedClass((Class)superclass);
        }
        return null;
    }

    public static boolean isFieldParameterizedWithClass(Field field, Class c) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            for (Type type : genericType.getActualTypeArguments()) {
                if (type == c) {
                    return true;
                }
                if (!c.isInterface() || !ReflectionUtils.implementsInterface((Class)type, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean implementsInterface(Class<?> type, Class<?> interfaceClass) {
        return interfaceClass.isAssignableFrom(type);
    }

    public static boolean isFieldParameterizedWithPropertyType(Field field) {
        if (field.getGenericType() instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)field.getGenericType();
            for (Type type : genericType.getActualTypeArguments()) {
                if (!ReflectionUtils.isPropertyType((Class)type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPropertyType(Class type) {
        return type != null && (ReflectionUtils.isPrimitiveLike(type) || type == DBRef.class || type == Pattern.class || type == CodeWScope.class || type == ObjectId.class || type == Key.class || type == DBObject.class || type == BasicDBObject.class);
    }

    public static boolean isPrimitiveLike(Class type) {
        return type != null && (type == String.class || type == Character.TYPE || type == Character.class || type == Short.TYPE || type == Short.class || type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Double.class || type == Double.TYPE || type == Float.TYPE || type == Float.class || type == Boolean.class || type == Boolean.TYPE || type == Byte.class || type == Byte.TYPE || type == Date.class || type == Locale.class || type == Class.class || type == UUID.class || type == URI.class || type.isEnum());
    }

    public static Embedded getClassEmbeddedAnnotation(Class c) {
        return ReflectionUtils.getAnnotation(c, Embedded.class);
    }

    public static <T> T getAnnotation(Class c, Class<T> annotation) {
        List<T> found = ReflectionUtils.getAnnotations(c, annotation);
        if (found != null && !found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public static <T> List<T> getAnnotations(Class c, Class<T> annotation) {
        ArrayList<T> found = new ArrayList<T>();
        if (c.isAnnotationPresent(annotation)) {
            found.add(c.getAnnotation(annotation));
        }
        for (Class parent = c.getSuperclass(); parent != null && parent != Object.class; parent = parent.getSuperclass()) {
            if (parent.isAnnotationPresent(annotation)) {
                found.add(parent.getAnnotation(annotation));
            }
            for (Class<?> interfaceClass : parent.getInterfaces()) {
                if (!interfaceClass.isAnnotationPresent(annotation)) continue;
                found.add(interfaceClass.getAnnotation(annotation));
            }
        }
        for (Class<?> interfaceClass : c.getInterfaces()) {
            if (!interfaceClass.isAnnotationPresent(annotation)) continue;
            found.add(interfaceClass.getAnnotation(annotation));
        }
        return found;
    }

    public static Entity getClassEntityAnnotation(Class c) {
        return ReflectionUtils.getAnnotation(c, Entity.class);
    }

    public static Set<Class<?>> getClasses(String packageName) throws IOException, ClassNotFoundException {
        return ReflectionUtils.getClasses(packageName, false);
    }

    public static Set<Class<?>> getClasses(String packageName, boolean mapSubPackages) throws IOException, ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return ReflectionUtils.getClasses(loader, packageName, mapSubPackages);
    }

    public static Set<Class<?>> getClasses(ClassLoader loader, String packageName) throws IOException, ClassNotFoundException {
        return ReflectionUtils.getClasses(loader, packageName, false);
    }

    public static Set<Class<?>> getClasses(ClassLoader loader, String packageName, boolean mapSubPackages) throws IOException, ClassNotFoundException {
        HashSet classes = new HashSet();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = loader.getResources(path);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                String filePath = resources.nextElement().getFile();
                if (filePath.indexOf("%20") > 0) {
                    filePath = filePath.replaceAll("%20", " ");
                }
                if (filePath.indexOf("%23") > 0) {
                    filePath = filePath.replaceAll("%23", "#");
                }
                if (filePath == null) continue;
                if (filePath.indexOf("!") > 0 && filePath.indexOf(".jar") > 0) {
                    String jarPath = filePath.substring(0, filePath.indexOf("!")).substring(filePath.indexOf(":") + 1);
                    if (jarPath.contains(":")) {
                        jarPath = jarPath.substring(1);
                    }
                    classes.addAll(ReflectionUtils.getFromJARFile(loader, jarPath, path, mapSubPackages));
                    continue;
                }
                classes.addAll(ReflectionUtils.getFromDirectory(loader, new File(filePath), packageName, mapSubPackages));
            }
        }
        return classes;
    }

    public static Set<Class<?>> getFromJARFile(ClassLoader loader, String jar, String packageName) throws IOException, ClassNotFoundException {
        return ReflectionUtils.getFromJARFile(loader, jar, packageName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> getFromJARFile(ClassLoader loader, String jar, String packageName, boolean mapSubPackages) throws IOException, ClassNotFoundException {
        HashSet classes = new HashSet();
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jar));
        try {
            JarEntry jarEntry;
            do {
                String classPackageName;
                String className;
                if ((jarEntry = jarFile.getNextJarEntry()) == null || !(className = jarEntry.getName()).endsWith(".class") || !(classPackageName = ReflectionUtils.getPackageName(className)).equals(packageName) && (!mapSubPackages || !ReflectionUtils.isSubPackage(classPackageName, packageName))) continue;
                className = ReflectionUtils.stripFilenameExtension(className);
                classes.add(Class.forName(className.replace('/', '.'), true, loader));
            } while (jarEntry != null);
        }
        finally {
            jarFile.close();
        }
        return classes;
    }

    public static Set<Class<?>> getFromDirectory(ClassLoader loader, File directory, String packageName) throws ClassNotFoundException {
        return ReflectionUtils.getFromDirectory(loader, directory, packageName, false);
    }

    public static Set<Class<?>> getFromDirectory(ClassLoader loader, File directory, String packageName, boolean mapSubPackages) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        if (directory.exists()) {
            for (String file : ReflectionUtils.getFileNames(directory, packageName, mapSubPackages)) {
                if (!file.endsWith(".class")) continue;
                String name = ReflectionUtils.stripFilenameExtension(file);
                Class<?> clazz = Class.forName(name, true, loader);
                classes.add(clazz);
            }
        }
        return classes;
    }

    private static Set<String> getFileNames(File directory, String packageName, boolean mapSubPackages) {
        HashSet<String> fileNames = new HashSet<String>();
        for (File file : directory.listFiles()) {
            if (file.isFile()) {
                fileNames.add(packageName + '.' + file.getName());
                continue;
            }
            if (!mapSubPackages) continue;
            fileNames.addAll(ReflectionUtils.getFileNames(file, packageName + '.' + file.getName(), false));
        }
        return fileNames;
    }

    private static String getPackageName(String filename) {
        return filename.contains("/") ? filename.substring(0, filename.lastIndexOf(47)) : filename;
    }

    private static String stripFilenameExtension(String filename) {
        if (filename.indexOf(46) != -1) {
            return filename.substring(0, filename.lastIndexOf(46));
        }
        return filename;
    }

    private static boolean isSubPackage(String fullPackageName, String parentPackageName) {
        return fullPackageName.startsWith(parentPackageName + ".");
    }

    public static <T> List<T> iterToList(Iterable<T> it) {
        if (it instanceof List) {
            return (List)it;
        }
        if (it == null) {
            return null;
        }
        ArrayList<T> ar = new ArrayList<T>();
        for (T o : it) {
            ar.add(o);
        }
        return ar;
    }

    public static Object convertToArray(Class type, List<?> values) {
        Object exampleArray = Array.newInstance(type, values.size());
        try {
            return values.toArray((Object[])exampleArray);
        }
        catch (ClassCastException e) {
            for (int i = 0; i < values.size(); ++i) {
                Array.set(exampleArray, i, values.get(i));
            }
            return exampleArray;
        }
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ReflectionUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            LOG.debug("************ ReflectionUtils.getClass 1st else");
            LOG.debug("************ type = " + type);
            return null;
        }
        LOG.debug("************ ReflectionUtils.getClass final else");
        LOG.debug("************ type = " + type);
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!ReflectionUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(ReflectionUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static <T> Class<?> getTypeArgument(Class<? extends T> clazz, TypeVariable<? extends GenericDeclaration> tv) {
        HashMap resolvedTypes = new HashMap();
        Type type = clazz;
        while (type != null && !Object.class.equals(ReflectionUtils.getClass(type))) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                if (typeParameters[i].equals(tv)) {
                    Class<?> cls = ReflectionUtils.getClass(actualTypeArguments[i]);
                    if (cls != null) {
                        return cls;
                    }
                    Type typeToTest = (Type)resolvedTypes.get(actualTypeArguments[i]);
                    while (typeToTest != null) {
                        Class<?> classToTest = ReflectionUtils.getClass(typeToTest);
                        if (classToTest != null) {
                            return classToTest;
                        }
                        typeToTest = (Type)resolvedTypes.get(typeToTest);
                    }
                }
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(Object.class)) continue;
            type = rawType.getGenericSuperclass();
        }
        return null;
    }
}

