/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.hadoop.MongoConfig;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.input.MongoRecordReader;
import com.mongodb.hadoop.util.MongoSplitter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoInputFormat
extends InputFormat<Object, BSONObject> {
    private static final Log LOG = LogFactory.getLog(MongoInputFormat.class);

    public RecordReader<Object, BSONObject> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        if (!(inputSplit instanceof MongoInputSplit)) {
            throw new IllegalStateException("Creation of a new RecordReader requires a MongoInputSplit instance.");
        }
        MongoInputSplit mongoInputSplit = (MongoInputSplit)inputSplit;
        return new MongoRecordReader(mongoInputSplit);
    }

    public List<InputSplit> getSplits(JobContext jobContext) {
        Configuration configuration = jobContext.getConfiguration();
        MongoConfig mongoConfig = new MongoConfig(configuration);
        return MongoSplitter.calculateSplits(mongoConfig);
    }

    public boolean verifyConfiguration(Configuration configuration) {
        return true;
    }
}

