/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.io;

import com.mongodb.BasicDBObject;
import com.mongodb.hadoop.io.BSONComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.Bits;
import org.bson.io.OutputBuffer;

public class BSONWritable
implements BSONObject,
WritableComparable {
    private static final byte[] HEX_CHAR;
    protected BSONObject _doc = new BasicBSONObject();
    private static final Log log;

    public BSONWritable() {
    }

    public BSONWritable(BSONWritable bSONWritable) {
        this();
        this.copy((Writable)bSONWritable);
    }

    public BSONWritable(BSONObject bSONObject) {
        this();
        this.putAll(bSONObject);
    }

    public Object put(String string, Object object) {
        return this._doc.put(string, object);
    }

    public void putAll(BSONObject bSONObject) {
        this._doc.putAll(bSONObject);
    }

    public void putAll(Map map) {
        this._doc.putAll(map);
    }

    public Object get(String string) {
        return this._doc.get(string);
    }

    public Map toMap() {
        return this._doc.toMap();
    }

    public Object removeField(String string) {
        return this._doc.removeField(string);
    }

    public boolean containsKey(String string) {
        return this._doc.containsKey(string);
    }

    public boolean containsField(String string) {
        return this._doc.containsField(string);
    }

    public Set<String> keySet() {
        return this._doc.keySet();
    }

    public void write(DataOutput dataOutput) throws IOException {
        BasicBSONEncoder basicBSONEncoder = new BasicBSONEncoder();
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        basicBSONEncoder.set((OutputBuffer)basicOutputBuffer);
        basicBSONEncoder.putObject(this._doc);
        basicBSONEncoder.done();
        basicOutputBuffer.pipe(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        BasicBSONDecoder basicBSONDecoder = new BasicBSONDecoder();
        BasicBSONCallback basicBSONCallback = new BasicBSONCallback();
        byte[] byArray = new byte[4];
        try {
            dataInput.readFully(byArray);
            int n = Bits.readInt((byte[])byArray);
            if (log.isDebugEnabled()) {
                log.debug((Object)("*** Expected DataLen: " + n));
            }
            byte[] byArray2 = new byte[n + 4];
            System.arraycopy(byArray, 0, byArray2, 0, 4);
            dataInput.readFully(byArray2, 4, n - 4);
            basicBSONDecoder.decode(byArray2, (BSONCallback)basicBSONCallback);
            this._doc = (BSONObject)basicBSONCallback.get();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Decoded a BSON Object: " + this._doc));
            }
        }
        catch (Exception exception) {
            log.info((Object)("No Length Header available." + exception));
            this._doc = new BasicDBObject();
        }
    }

    public String toString() {
        BasicBSONEncoder basicBSONEncoder = new BasicBSONEncoder();
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        basicBSONEncoder.set((OutputBuffer)basicOutputBuffer);
        basicBSONEncoder.putObject(this._doc);
        basicBSONEncoder.done();
        String string = basicOutputBuffer.asString();
        log.debug((Object)("Output As String: '" + string + "'"));
        return string;
    }

    protected synchronized void copy(Writable writable) {
        if (writable != null) {
            try {
                DataOutputBuffer dataOutputBuffer = new DataOutputBuffer();
                writable.write((DataOutput)dataOutputBuffer);
                DataInputBuffer dataInputBuffer = new DataInputBuffer();
                dataInputBuffer.reset(dataOutputBuffer.getData(), dataOutputBuffer.getLength());
                this.readFields((DataInput)dataInputBuffer);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("map cannot be copied: " + iOException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("source map cannot be null");
        }
    }

    public int compareTo(Object object) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(" ************ Compare: '" + this + "' to '" + object + "'"));
        }
        return new BSONComparator().compare((Object)this, object);
    }

    protected static void dumpBytes(BasicOutputBuffer basicOutputBuffer) {
        BSONWritable.dumpBytes(basicOutputBuffer.toByteArray());
    }

    protected static void dumpBytes(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(2 + 3 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append("0x").append((char)HEX_CHAR[(by & 0xF0) >> 4]).append((char)HEX_CHAR[by & 0xF]).append(" ");
        }
        log.info((Object)("Byte Dump: " + stringBuilder.toString()));
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BSONWritable bSONWritable = (BSONWritable)object;
        return this._doc == bSONWritable._doc || this._doc != null && this._doc.equals(bSONWritable._doc);
    }

    public int hashCode() {
        return this._doc != null ? this._doc.hashCode() : 0;
    }

    static {
        WritableComparator.define(BSONWritable.class, (WritableComparator)new BSONComparator());
        HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        log = LogFactory.getLog(BSONWritable.class);
    }
}

