/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.output;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.hadoop.MongoOutput;
import java.io.IOException;
import org.apache.hadoop.io.AbstractMapWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.bson.BSONObject;

public class MongoRecordWriter<K, V>
extends RecordWriter<K, V> {
    final DBCollection _collection;
    final TaskAttemptContext _context;

    public MongoRecordWriter(DBCollection dBCollection, TaskAttemptContext taskAttemptContext) {
        this._collection = dBCollection;
        this._context = taskAttemptContext;
    }

    public void close(TaskAttemptContext taskAttemptContext) {
        this._collection.getDB().getLastError();
    }

    Object toBSON(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Text || object instanceof UTF8) {
            return object.toString();
        }
        if (object instanceof Writable) {
            if (object instanceof AbstractMapWritable) {
                throw new IllegalArgumentException("ERROR: MapWritables are not presently supported for MongoDB Serialization.");
            }
            if (object instanceof ArrayWritable) {
                Writable[] writableArray = ((ArrayWritable)object).get();
                Object[] objectArray = new Object[writableArray.length];
                for (int i = 0; i < writableArray.length; ++i) {
                    objectArray[i] = (Writable)this.toBSON(writableArray[i]);
                }
            }
            if (object instanceof BooleanWritable) {
                return ((BooleanWritable)object).get();
            }
            if (object instanceof BytesWritable) {
                return ((BytesWritable)object).getBytes();
            }
            if (object instanceof ByteWritable) {
                return ((ByteWritable)object).get();
            }
            if (object instanceof DoubleWritable) {
                return ((DoubleWritable)object).get();
            }
            if (object instanceof FloatWritable) {
                return Float.valueOf(((FloatWritable)object).get());
            }
            if (object instanceof LongWritable) {
                return ((LongWritable)object).get();
            }
            if (object instanceof IntWritable) {
                return ((IntWritable)object).get();
            }
        }
        throw new RuntimeException("can't convert: " + object.getClass().getName() + " to BSON");
    }

    public void write(K k, V v) throws IOException {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (k instanceof MongoOutput) {
            ((MongoOutput)k).appendAsKey((DBObject)basicDBObject);
        } else if (k instanceof BSONObject) {
            basicDBObject.put("_id", k);
        } else {
            basicDBObject.put("_id", this.toBSON(k));
        }
        if (v instanceof MongoOutput) {
            ((MongoOutput)v).appendAsValue((DBObject)basicDBObject);
        } else if (v instanceof BSONObject) {
            basicDBObject.putAll((BSONObject)v);
        } else {
            basicDBObject.put("value", this.toBSON(v));
        }
        try {
            this._collection.save((DBObject)basicDBObject);
        }
        catch (MongoException mongoException) {
            throw new IOException("can't write to mongo", mongoException);
        }
    }

    public TaskAttemptContext getContext() {
        return this._context;
    }
}

